/*
 * Decompiled with CFR 0.152.
 */
package com.peersafe.base.core.binary;

import com.peersafe.base.core.coretypes.AccountID;
import com.peersafe.base.core.coretypes.Amount;
import com.peersafe.base.core.coretypes.Blob;
import com.peersafe.base.core.coretypes.Currency;
import com.peersafe.base.core.coretypes.PathSet;
import com.peersafe.base.core.coretypes.RippleDate;
import com.peersafe.base.core.coretypes.STArray;
import com.peersafe.base.core.coretypes.STObject;
import com.peersafe.base.core.coretypes.Vector256;
import com.peersafe.base.core.coretypes.hash.Hash128;
import com.peersafe.base.core.coretypes.hash.Hash160;
import com.peersafe.base.core.coretypes.hash.Hash256;
import com.peersafe.base.core.coretypes.hash.prefixes.HashPrefix;
import com.peersafe.base.core.coretypes.uint.UInt16;
import com.peersafe.base.core.coretypes.uint.UInt32;
import com.peersafe.base.core.coretypes.uint.UInt64;
import com.peersafe.base.core.coretypes.uint.UInt8;
import com.peersafe.base.core.serialized.BinaryParser;
import com.peersafe.base.core.serialized.StreamBinaryParser;
import com.peersafe.base.core.types.known.sle.LedgerEntry;
import com.peersafe.base.core.types.known.tx.Transaction;
import com.peersafe.base.core.types.known.tx.result.TransactionMeta;
import com.peersafe.base.core.types.known.tx.result.TransactionResult;
import java.util.Arrays;
import java.util.Date;

public class STReader {
    protected BinaryParser parser;

    public STReader(BinaryParser parser) {
        this.parser = parser;
    }

    public STReader(String hex) {
        this.parser = new BinaryParser(hex);
    }

    public static STReader fromFile(String arg) {
        return new STReader(StreamBinaryParser.fromFile(arg));
    }

    public UInt8 uInt8() {
        return UInt8.translate.fromParser(this.parser);
    }

    public UInt16 uInt16() {
        return UInt16.translate.fromParser(this.parser);
    }

    public UInt32 uInt32() {
        return UInt32.translate.fromParser(this.parser);
    }

    public UInt64 uInt64() {
        return UInt64.translate.fromParser(this.parser);
    }

    public Hash128 hash128() {
        return (Hash128)Hash128.translate.fromParser(this.parser);
    }

    public Hash160 hash160() {
        return (Hash160)Hash160.translate.fromParser(this.parser);
    }

    public Currency currency() {
        return (Currency)Currency.translate.fromParser(this.parser);
    }

    public Hash256 hash256() {
        return (Hash256)Hash256.translate.fromParser(this.parser);
    }

    public Vector256 vector256() {
        return (Vector256)Vector256.translate.fromParser(this.parser);
    }

    public AccountID accountID() {
        return (AccountID)AccountID.translate.fromParser(this.parser);
    }

    public Blob variableLength() {
        int hint = this.parser.readVLLength();
        return Blob.translate.fromParser(this.parser, hint);
    }

    public Amount amount() {
        return (Amount)Amount.translate.fromParser(this.parser);
    }

    public PathSet pathSet() {
        return (PathSet)PathSet.translate.fromParser(this.parser);
    }

    public STObject stObject() {
        return (STObject)STObject.translate.fromParser(this.parser);
    }

    public STObject vlStObject() {
        return STObject.translate.fromParser(this.parser, this.parser.readVLLength());
    }

    public HashPrefix hashPrefix() {
        byte[] read = this.parser.read(4);
        for (HashPrefix hashPrefix : HashPrefix.values()) {
            if (!Arrays.equals(read, hashPrefix.bytes)) continue;
            return hashPrefix;
        }
        return null;
    }

    public STArray stArray() {
        return (STArray)STArray.translate.fromParser(this.parser);
    }

    public Date rippleDate() {
        return RippleDate.fromParser(this.parser);
    }

    public BinaryParser parser() {
        return this.parser;
    }

    public TransactionResult readTransactionResult(UInt32 ledgerIndex) {
        Hash256 hash = this.hash256();
        Transaction txn = (Transaction)this.vlStObject();
        TransactionMeta meta = (TransactionMeta)this.vlStObject();
        return new TransactionResult(ledgerIndex.longValue(), hash, txn, meta);
    }

    public LedgerEntry readLE() {
        Hash256 index = this.hash256();
        STObject object = this.vlStObject();
        LedgerEntry le = (LedgerEntry)object;
        le.index(index);
        return le;
    }

    public int readOneInt() {
        return this.parser.readOneInt();
    }

    public boolean end() {
        return this.parser.end();
    }
}

