/*
 * Decompiled with CFR 0.152.
 */
package com.peersafe.base.core.binary;

import com.peersafe.base.core.coretypes.hash.Hash256;
import com.peersafe.base.core.serialized.BinarySerializer;
import com.peersafe.base.core.serialized.BytesSink;
import com.peersafe.base.core.serialized.SerializedType;
import com.peersafe.base.core.types.known.sle.LedgerEntry;
import com.peersafe.base.core.types.known.tx.result.TransactionResult;

public class STWriter
implements BytesSink {
    BytesSink sink;
    BinarySerializer serializer;

    public STWriter(BytesSink bytesSink) {
        this.serializer = new BinarySerializer(bytesSink);
        this.sink = bytesSink;
    }

    public void write(SerializedType obj) {
        obj.toBytesSink(this.sink);
    }

    public void writeVl(SerializedType obj) {
        this.serializer.addLengthEncoded(obj);
    }

    @Override
    public void add(byte aByte) {
        this.sink.add(aByte);
    }

    @Override
    public void add(byte[] bytes) {
        this.sink.add(bytes);
    }

    public void write(TransactionResult result) {
        this.write(result.hash);
        this.writeVl(result.txn);
        this.writeVl(result.meta);
    }

    public void write(Hash256 hash256, LedgerEntry le) {
        this.write(hash256);
        this.writeVl(le);
    }
}

