/*
 * Decompiled with CFR 0.152.
 */
package com.peersafe.base.core.coretypes;

import com.peersafe.base.core.coretypes.AccountID;
import com.peersafe.base.core.coretypes.Currency;
import com.peersafe.base.core.coretypes.Issue;
import com.peersafe.base.core.coretypes.uint.UInt;
import com.peersafe.base.core.coretypes.uint.UInt64;
import com.peersafe.base.core.fields.AmountField;
import com.peersafe.base.core.fields.Field;
import com.peersafe.base.core.fields.Type;
import com.peersafe.base.core.serialized.BinaryParser;
import com.peersafe.base.core.serialized.BytesSink;
import com.peersafe.base.core.serialized.SerializedType;
import com.peersafe.base.core.serialized.TypeTranslator;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import org.json.JSONObject;

public class Amount
extends Number
implements SerializedType,
Comparable<Amount> {
    private static BigDecimal TAKER_PAYS_FOR_THAT_DAMN_OFFER = new BigDecimal("1000000000000.000100");
    public static final MathContext MATH_CONTEXT = new MathContext(16, RoundingMode.HALF_UP);
    public static final int MAXIMUM_IOU_PRECISION = 16;
    public static final int MAXIMUM_NATIVE_SCALE = 6;
    public static final BigDecimal MAX_NATIVE_VALUE = com.peersafe.base.core.coretypes.Amount.parseDecimal("100,000,000,000.0");
    public static final BigDecimal MIN_NATIVE_VALUE = com.peersafe.base.core.coretypes.Amount.parseDecimal("0.000,001");
    public static final UInt64 BINARY_FLAG_IS_IOU = new UInt64("8000000000000000", 16);
    public static final UInt64 BINARY_FLAG_IS_NON_NEGATIVE_NATIVE = new UInt64("4000000000000000", 16);
    public static final Amount ONE_XRP = com.peersafe.base.core.coretypes.Amount.fromString("1.0");
    private BigDecimal value;
    private Currency currency;
    private boolean isNative;
    private boolean unbounded = false;
    private AccountID issuer;
    private UInt64 mantissa = null;
    private int exponent;
    public static Translator translate = new Translator();
    public static AmountField Amount = com.peersafe.base.core.coretypes.Amount.amountField(Field.Amount);
    public static AmountField Balance = com.peersafe.base.core.coretypes.Amount.amountField(Field.Balance);
    public static AmountField LimitAmount = com.peersafe.base.core.coretypes.Amount.amountField(Field.LimitAmount);
    public static AmountField DeliveredAmount = com.peersafe.base.core.coretypes.Amount.amountField(Field.DeliveredAmount);
    public static AmountField TakerPays = com.peersafe.base.core.coretypes.Amount.amountField(Field.TakerPays);
    public static AmountField TakerGets = com.peersafe.base.core.coretypes.Amount.amountField(Field.TakerGets);
    public static AmountField LowLimit = com.peersafe.base.core.coretypes.Amount.amountField(Field.LowLimit);
    public static AmountField HighLimit = com.peersafe.base.core.coretypes.Amount.amountField(Field.HighLimit);
    public static AmountField Fee = com.peersafe.base.core.coretypes.Amount.amountField(Field.Fee);
    public static AmountField SendMax = com.peersafe.base.core.coretypes.Amount.amountField(Field.SendMax);
    public static AmountField MinimumOffer = com.peersafe.base.core.coretypes.Amount.amountField(Field.MinimumOffer);
    public static AmountField RippleEscrow = com.peersafe.base.core.coretypes.Amount.amountField(Field.RippleEscrow);
    public static AmountField taker_gets_funded = com.peersafe.base.core.coretypes.Amount.amountField(Field.taker_gets_funded);
    public static AmountField taker_pays_funded = com.peersafe.base.core.coretypes.Amount.amountField(Field.taker_pays_funded);
    public static AmountField ContractValue = com.peersafe.base.core.coretypes.Amount.amountField(Field.ContractValue);

    public Amount(BigDecimal value, Currency currency, AccountID issuer) {
        this(value, currency, issuer, false);
    }

    public Amount(BigDecimal value) {
        this.isNative = true;
        this.currency = Currency.ZXC;
        this.setAndCheckValue(value);
    }

    public Amount(BigDecimal value, Currency currency, AccountID issuer, boolean isNative, boolean unbounded) {
        this.isNative = isNative;
        this.currency = currency;
        this.unbounded = unbounded;
        this.setAndCheckValue(value);
        this.issuer = issuer;
    }

    public Amount(Currency currency, AccountID account) {
        this(BigDecimal.ZERO, currency, account);
    }

    Amount(BigDecimal newValue, Currency currency, AccountID issuer, boolean isNative) {
        this(newValue, currency, issuer, isNative, false);
    }

    private Amount(BigDecimal value, String currency, String issuer) {
        this(value, currency);
        if (issuer != null) {
            this.issuer = AccountID.fromString(issuer);
        }
    }

    public Amount(BigDecimal value, String currency) {
        this.isNative = false;
        this.currency = Currency.fromString(currency);
        this.setAndCheckValue(value);
    }

    private void setAndCheckValue(BigDecimal value) {
        this.value = value.stripTrailingZeros();
        this.initialize();
    }

    private void initialize() {
        if (this.isNative()) {
            this.issuer = AccountID.XRP_ISSUER;
            if (!this.unbounded) {
                this.checkXRPBounds();
            }
            this.exponent = -6;
        } else {
            this.issuer = AccountID.NEUTRAL;
            this.exponent = this.calculateExponent();
            if (this.value.precision() > 16 && !this.unbounded) {
                String err = "value precision of " + this.value.precision() + " is greater than maximum iou precision of " + 16;
                throw new PrecisionError(err, this);
            }
        }
    }

    private Amount newValue(BigDecimal newValue) {
        return this.newValue(newValue, false, false);
    }

    private Amount newValue(BigDecimal newValue, boolean round, boolean unbounded) {
        if (round) {
            newValue = com.peersafe.base.core.coretypes.Amount.roundValue(newValue, this.isNative);
        }
        return new Amount(newValue, this.currency, this.issuer, this.isNative, unbounded);
    }

    private Amount newValue(BigDecimal val, boolean round) {
        return this.newValue(val, round, false);
    }

    public BigDecimal value() {
        return this.value;
    }

    public Currency currency() {
        return this.currency;
    }

    public AccountID issuer() {
        return this.issuer;
    }

    public Issue issue() {
        return new Issue(this.currency, this.issuer);
    }

    public UInt64 mantissa() {
        if (this.mantissa == null) {
            this.mantissa = this.calculateMantissa();
        }
        return this.mantissa;
    }

    public int exponent() {
        return this.exponent;
    }

    public boolean isNative() {
        return this.isNative;
    }

    public String currencyString() {
        return this.currency.toString();
    }

    public String issuerString() {
        if (this.issuer == null) {
            return "";
        }
        return this.issuer.toString();
    }

    private UInt64 calculateMantissa() {
        if (this.isNative()) {
            return new UInt64(this.bigIntegerDrops().abs());
        }
        return new UInt64(this.bigIntegerIOUMantissa());
    }

    protected int calculateExponent() {
        return -16 + this.value.precision() - this.value.scale();
    }

    public BigInteger bigIntegerIOUMantissa() {
        return this.exactBigIntegerScaledByPowerOfTen(-this.exponent).abs();
    }

    private BigInteger bigIntegerDrops() {
        return this.exactBigIntegerScaledByPowerOfTen(6);
    }

    private BigInteger exactBigIntegerScaledByPowerOfTen(int n) {
        return this.value.scaleByPowerOfTen(n).toBigIntegerExact();
    }

    private boolean equalValue(Amount amt) {
        return this.compareTo(amt) == 0;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Amount) {
            return this.equals((Amount)obj);
        }
        return super.equals(obj);
    }

    public boolean equals(Amount amt) {
        return this.equalValue(amt) && this.currency.equals(amt.currency) && (this.isNative() || this.issuer.equals(amt.issuer));
    }

    public boolean equalsExceptIssuer(Amount amt) {
        return this.equalValue(amt) && this.currencyString().equals(amt.currencyString());
    }

    @Override
    public int compareTo(Amount amount) {
        return this.value.compareTo(amount.value);
    }

    public boolean isZero() {
        return this.value.signum() == 0;
    }

    public boolean isNegative() {
        return this.value.signum() == -1;
    }

    public boolean isPositive() {
        return this.value.signum() == 1;
    }

    public Amount add(BigDecimal augend) {
        return this.newValue(this.value.add(augend), true);
    }

    public Amount add(Amount augend) {
        return this.add(augend.value);
    }

    public Amount add(Number augend) {
        return this.add(BigDecimal.valueOf(augend.doubleValue()));
    }

    public Amount subtract(BigDecimal subtrahend) {
        return this.newValue(this.value.subtract(subtrahend), true);
    }

    public Amount subtract(Amount subtrahend) {
        return this.subtract(subtrahend.value);
    }

    public Amount subtract(Number subtrahend) {
        return this.subtract(BigDecimal.valueOf(subtrahend.doubleValue()));
    }

    public Amount multiply(BigDecimal divisor) {
        return this.newValue(this.value.multiply(divisor, MATH_CONTEXT), true);
    }

    public Amount multiply(Amount multiplicand) {
        return this.multiply(multiplicand.value);
    }

    public Amount multiply(Number multiplicand) {
        return this.multiply(BigDecimal.valueOf(multiplicand.doubleValue()));
    }

    public Amount divide(BigDecimal divisor) {
        return this.newValue(this.value.divide(divisor, MATH_CONTEXT), true);
    }

    public Amount divide(Amount divisor) {
        return this.divide(divisor.value);
    }

    public Amount divide(Number divisor) {
        return this.divide(BigDecimal.valueOf(divisor.doubleValue()));
    }

    public Amount negate() {
        return this.newValue(this.value.negate());
    }

    public Amount abs() {
        return this.newValue(this.value.abs());
    }

    public Amount min(Amount val) {
        return this.compareTo(val) <= 0 ? this : val;
    }

    public Amount max(Amount val) {
        return this.compareTo(val) >= 0 ? this : val;
    }

    public BigDecimal computeQuality(Amount toExchangeThisWith) {
        return this.value.divide(toExchangeThisWith.value, MathContext.DECIMAL128);
    }

    public Amount one() {
        if (this.isNative()) {
            return ONE_XRP;
        }
        return this.issue().amount(1);
    }

    @Override
    public Object toJSON() {
        if (this.isNative()) {
            return this.toDropsString();
        }
        return this.toJSONObject();
    }

    public JSONObject toJSONObject() {
        if (this.isNative()) {
            throw new RuntimeException("Native amounts must be serialized as a string");
        }
        JSONObject out = new JSONObject();
        out.put("currency", (Object)this.currencyString());
        out.put("value", (Object)this.valueText());
        out.put("issuer", (Object)this.issuerString());
        return out;
    }

    @Override
    public byte[] toBytes() {
        return translate.toBytes(this);
    }

    @Override
    public String toHex() {
        return translate.toHex(this);
    }

    @Override
    public void toBytesSink(BytesSink to) {
        UInt64 man = this.mantissa();
        if (this.isNative()) {
            if (!this.isNegative()) {
                man = (UInt64)man.or(BINARY_FLAG_IS_NON_NEGATIVE_NATIVE);
            }
            to.add(man.toByteArray());
        } else {
            int exponent = this.exponent();
            UInt64 packed = this.isZero() ? BINARY_FLAG_IS_IOU : (this.isNegative() ? (UInt64)man.or((UInt)new UInt64(609 + exponent).shiftLeft(54)) : (UInt64)man.or((UInt)new UInt64(865 + exponent).shiftLeft(54)));
            to.add(packed.toByteArray());
            to.add(this.currency.bytes());
            to.add(this.issuer.bytes());
        }
    }

    @Override
    public Type type() {
        return Type.Amount;
    }

    public static BigDecimal xrpFromDropsMantissa(byte[] mantissa, int sign) {
        return new BigDecimal(new BigInteger(sign, mantissa), 6);
    }

    @Override
    public int intValue() {
        return this.value.intValueExact();
    }

    @Override
    public long longValue() {
        return this.value.longValueExact();
    }

    @Override
    public float floatValue() {
        return this.value.floatValue();
    }

    @Override
    public double doubleValue() {
        return this.value.doubleValue();
    }

    public BigInteger bigIntegerValue() {
        return this.value.toBigIntegerExact();
    }

    public Amount newIssuer(AccountID issuer) {
        return new Amount(this.value, this.currency, issuer);
    }

    public Amount copy() {
        return new Amount(this.value, this.currency, this.issuer, this.isNative, this.unbounded);
    }

    public static Amount fromString(String val) {
        if (val.contains("/")) {
            return com.peersafe.base.core.coretypes.Amount.fromIOUString(val);
        }
        if (val.contains(".")) {
            return com.peersafe.base.core.coretypes.Amount.fromXrpString(val);
        }
        return com.peersafe.base.core.coretypes.Amount.fromDropString(val);
    }

    public static Amount fromDropString(String val) {
        BigDecimal drops = new BigDecimal(val).scaleByPowerOfTen(-6);
        com.peersafe.base.core.coretypes.Amount.checkDropsValueWhole(val);
        return new Amount(drops);
    }

    public static Amount fromIOUString(String val) {
        String[] split = val.split("/");
        if (split.length == 1) {
            throw new RuntimeException("IOU string must be in the form number/currencyString or number/currencyString/issuerString");
        }
        if (split.length == 2) {
            return new Amount(new BigDecimal(split[0]), split[1]);
        }
        return new Amount(new BigDecimal(split[0]), split[1], split[2]);
    }

    @Deprecated
    private static Amount fromXrpString(String valueString) {
        BigDecimal val = new BigDecimal(valueString);
        return new Amount(val);
    }

    public String stringRepr() {
        if (this.isNative()) {
            return this.toDropsString();
        }
        return this.iouTextFull();
    }

    public String toDropsString() {
        if (!this.isNative()) {
            throw new RuntimeException("Amount is not native");
        }
        return this.bigIntegerDrops().toString();
    }

    private String iouText() {
        return String.format("%s/%s", this.valueText(), this.currencyString());
    }

    public String iouTextFull() {
        return String.format("%s/%s/%s", this.valueText(), this.currencyString(), this.issuerString());
    }

    public String toTextFull() {
        if (this.isNative()) {
            return this.nativeText();
        }
        return this.iouTextFull();
    }

    public String nativeText() {
        return String.format("%s/ZXC", this.valueText());
    }

    public String toString() {
        return this.toTextFull();
    }

    public String toText() {
        if (this.isNative()) {
            return this.nativeText();
        }
        return this.iouText();
    }

    public String valueText() {
        return this.value.signum() == 0 ? "0" : this.value().toPlainString();
    }

    public void checkLowerDropBound(BigDecimal val) {
        if (val.scale() > 6) {
            PrecisionError bigger = com.peersafe.base.core.coretypes.Amount.getOutOfBoundsError(val, "smaller than min native value", MIN_NATIVE_VALUE);
            bigger.illegal = this;
            throw bigger;
        }
    }

    public void checkUpperBound(BigDecimal val) {
        if (val.compareTo(MAX_NATIVE_VALUE) == 1) {
            PrecisionError bigger = com.peersafe.base.core.coretypes.Amount.getOutOfBoundsError(val, "bigger than max native value ", MAX_NATIVE_VALUE);
            bigger.illegal = this;
            throw bigger;
        }
    }

    private static PrecisionError getOutOfBoundsError(BigDecimal abs, String sized, BigDecimal bound) {
        return new PrecisionError(abs.toPlainString() + " absolute ZXC is " + sized + bound);
    }

    public void checkXRPBounds() {
        BigDecimal v = this.value.abs();
        if (v.compareTo(TAKER_PAYS_FOR_THAT_DAMN_OFFER) == 0) {
            return;
        }
        this.checkLowerDropBound(v);
        this.checkUpperBound(v);
    }

    private static int significantDigits(BigDecimal input) {
        return (input = input.stripTrailingZeros()).scale() < 0 ? input.precision() - input.scale() : input.precision();
    }

    public int significantDigits() {
        return com.peersafe.base.core.coretypes.Amount.significantDigits(this.value);
    }

    public static void checkDropsValueWhole(String drops) {
        boolean contains = drops.contains(".");
        if (contains) {
            throw new RuntimeException("Drops string contains floating point is decimal");
        }
    }

    public static BigDecimal roundValue(BigDecimal value, boolean nativeSrc) {
        int i = value.precision() - value.scale();
        return value.setScale(nativeSrc ? 6 : 16 - i, MATH_CONTEXT.getRoundingMode());
    }

    private static BigDecimal parseDecimal(String s) {
        return new BigDecimal(s.replace(",", ""));
    }

    private static AmountField amountField(final Field f) {
        return new AmountField(){

            @Override
            public Field getField() {
                return f;
            }
        };
    }

    public static class Translator
    extends TypeTranslator<Amount> {
        @Override
        public Amount fromString(String s) {
            return com.peersafe.base.core.coretypes.Amount.fromString(s);
        }

        @Override
        public Amount fromParser(BinaryParser parser, Integer hint) {
            int sign;
            byte[] mantissa = parser.read(8);
            byte b1 = mantissa[0];
            byte b2 = mantissa[1];
            boolean isIOU = (b1 & 0x80) != 0;
            boolean isPositive = (b1 & 0x40) != 0;
            int n = sign = isPositive ? 1 : -1;
            if (isIOU) {
                mantissa[0] = 0;
                Currency curr = (Currency)Currency.translate.fromParser(parser);
                AccountID issuer = (AccountID)AccountID.translate.fromParser(parser);
                int exponent = ((b1 & 0x3F) << 2) + ((b2 & 0xFF) >> 6) - 97;
                mantissa[1] = (byte)(mantissa[1] & 0x3F);
                BigDecimal value = new BigDecimal(new BigInteger(sign, mantissa), -exponent);
                return new Amount(value, curr, issuer, false);
            }
            mantissa[0] = (byte)(mantissa[0] & 0x3F);
            BigDecimal value = com.peersafe.base.core.coretypes.Amount.xrpFromDropsMantissa(mantissa, sign);
            return new Amount(value);
        }

        @Override
        public String toString(Amount obj) {
            return obj.stringRepr();
        }

        @Override
        public JSONObject toJSONObject(Amount obj) {
            return obj.toJSONObject();
        }

        @Override
        public Amount fromJSONObject(JSONObject jsonObject) {
            String valueString = jsonObject.getString("value");
            String issuerString = jsonObject.getString("issuer");
            String currencyString = jsonObject.getString("currency");
            return new Amount(new BigDecimal(valueString), currencyString, issuerString);
        }
    }

    public static class PrecisionError
    extends RuntimeException {
        public Amount illegal;

        public PrecisionError(String s) {
            super(s);
        }

        public PrecisionError(String s, Amount amount) {
            super(s);
            this.illegal = amount;
        }
    }
}

