/*
 * Decompiled with CFR 0.152.
 */
package com.peersafe.base.core.coretypes;

import com.peersafe.base.core.coretypes.RippleDate;
import com.peersafe.base.core.coretypes.hash.Hash;
import com.peersafe.base.core.coretypes.hash.Hash160;
import com.peersafe.base.core.coretypes.uint.UInt64;
import com.peersafe.base.core.serialized.BinaryParser;
import com.peersafe.base.core.serialized.BytesSink;
import com.peersafe.base.encodings.common.B16;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public class Currency
extends Hash160 {
    public static final Currency NEUTRAL = new Currency(BigInteger.ONE.toByteArray());
    public static final Currency ZXC = new Currency(BigInteger.ZERO.toByteArray());
    Type type = Type.fromByte(this.hash[0]);
    public Demurrage demurrage = null;
    public static CurrencyTranslator translate = new CurrencyTranslator();

    @Override
    public Object toJSON() {
        return translate.toJSON(this);
    }

    @Override
    public byte[] toBytes() {
        return translate.toBytes(this);
    }

    @Override
    public String toHex() {
        return translate.toHex(this);
    }

    @Override
    public void toBytesSink(BytesSink to) {
        translate.toBytesSink(this, to);
    }

    public boolean isNative() {
        return this == ZXC || this.equals(ZXC);
    }

    public boolean isIOU() {
        return !this.isNative();
    }

    public Currency(byte[] bytes) {
        super(bytes);
        if (this.type == Type.DEMURRAGE) {
            this.demurrage = new Demurrage(bytes);
        }
    }

    public static Currency fromString(String currency) {
        return translate.fromString(currency);
    }

    @Override
    public String toString() {
        switch (this.type) {
            case ISO: {
                String code = Currency.getCurrencyCodeFromTLCBytes(this.bytes());
                if (code.equals("ZXC")) {
                    return super.toString();
                }
                if (code.equals("\u0000\u0000\u0000")) {
                    return "ZXC";
                }
                return code;
            }
        }
        return super.toString();
    }

    public String humanCode() {
        if (this.type == Type.ISO) {
            return Currency.getCurrencyCodeFromTLCBytes(this.hash);
        }
        if (this.type == Type.DEMURRAGE) {
            return Currency.isoCodeFromBytesAndOffset(this.hash, 1);
        }
        throw new IllegalStateException("No human code for currency of type " + (Object)((Object)this.type));
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof Currency) {
            Currency other = (Currency)obj;
            byte[] bytes = this.bytes();
            byte[] otherBytes = other.bytes();
            if (this.type == Type.ISO && other.type == Type.ISO) {
                return bytes[12] == otherBytes[12] && bytes[13] == otherBytes[13] && bytes[14] == otherBytes[14];
            }
        }
        return super.equals(obj);
    }

    public static byte[] encodeCurrency(String currencyCode) {
        byte[] currencyBytes = new byte[20];
        currencyBytes[12] = (byte)currencyCode.codePointAt(0);
        currencyBytes[13] = (byte)currencyCode.codePointAt(1);
        currencyBytes[14] = (byte)currencyCode.codePointAt(2);
        return currencyBytes;
    }

    public static String getCurrencyCodeFromTLCBytes(byte[] bytes) {
        boolean zeroInNonCurrencyBytes = true;
        for (int i = 0; i < 20; ++i) {
            zeroInNonCurrencyBytes = zeroInNonCurrencyBytes && (i == 12 || i == 13 || i == 14 || bytes[i] == 0);
        }
        if (zeroInNonCurrencyBytes) {
            return Currency.isoCodeFromBytesAndOffset(bytes, 12);
        }
        throw new IllegalStateException("Currency is invalid");
    }

    private static char charFrom(byte[] bytes, int i) {
        return (char)bytes[i];
    }

    private static String isoCodeFromBytesAndOffset(byte[] bytes, int offset) {
        char a = Currency.charFrom(bytes, offset);
        char b = Currency.charFrom(bytes, offset + 1);
        char c = Currency.charFrom(bytes, offset + 2);
        return "" + a + b + c;
    }

    public static class CurrencyTranslator
    extends Hash.HashTranslator<Currency> {
        @Override
        public int byteWidth() {
            return 20;
        }

        @Override
        public Currency newInstance(byte[] b) {
            return new Currency(b);
        }

        @Override
        public Object toJSON(Currency obj) {
            return obj.toString();
        }

        @Override
        public Currency fromString(String value) {
            if (value.length() == 40) {
                return this.newInstance(B16.decode(value));
            }
            if (value.equals("ZXC")) {
                return ZXC;
            }
            if (value.length() != 3) {
                throw new RuntimeException("Currency code must be 3 characters");
            }
            return this.newInstance(Currency.encodeCurrency(value));
        }
    }

    public static class Demurrage {
        public Date interestStart;
        public String isoCode;
        public double interestRate;

        public static BigDecimal applyRate(BigDecimal amount, BigDecimal rate, TimeUnit time, long units) {
            BigDecimal appliedRate = Demurrage.getSeconds(time, units).divide(rate, MathContext.DECIMAL64);
            BigDecimal factor = BigDecimal.valueOf(Math.exp(appliedRate.doubleValue()));
            return amount.multiply(factor, MathContext.DECIMAL64);
        }

        public static BigDecimal calculateRate(BigDecimal rate, TimeUnit time, long units) {
            BigDecimal seconds = Demurrage.getSeconds(time, units);
            BigDecimal log = Demurrage.ln(rate);
            return seconds.divide(log, MathContext.DECIMAL64);
        }

        private static BigDecimal ln(BigDecimal bd) {
            return BigDecimal.valueOf(Math.log(bd.doubleValue()));
        }

        private static BigDecimal getSeconds(TimeUnit time, long units) {
            return BigDecimal.valueOf(time.toSeconds(units));
        }

        public Demurrage(byte[] bytes) {
            BinaryParser parser = new BinaryParser(bytes);
            parser.skip(1);
            this.isoCode = Currency.isoCodeFromBytesAndOffset(parser.read(3), 0);
            this.interestStart = RippleDate.fromParser(parser);
            long l = UInt64.translate.fromParser(parser).longValue();
            this.interestRate = Double.longBitsToDouble(l);
        }
    }

    public static enum Type {
        HASH,
        ISO,
        DEMURRAGE,
        UNKNOWN;


        public static Type fromByte(byte typeByte) {
            if (typeByte == 0) {
                return ISO;
            }
            if (typeByte == 1) {
                return DEMURRAGE;
            }
            if ((typeByte & 0x80) != 0) {
                return HASH;
            }
            return UNKNOWN;
        }
    }
}

