/*
 * Decompiled with CFR 0.152.
 */
package com.peersafe.base.core.fields;

import com.peersafe.base.core.fields.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;

public enum Field {
    Generic(0, Type.Unknown),
    Invalid(-1, Type.Unknown),
    LedgerEntryType(1, Type.UInt16),
    TransactionType(2, Type.UInt16),
    SignerWeight(3, Type.UInt16),
    OpType(50, Type.UInt16),
    ContractOpType(51, Type.UInt16),
    Flags(2, Type.UInt32),
    SourceTag(3, Type.UInt32),
    Sequence(4, Type.UInt32),
    PreviousTxnLgrSeq(5, Type.UInt32),
    LedgerSequence(6, Type.UInt32),
    CloseTime(7, Type.UInt32),
    ParentCloseTime(8, Type.UInt32),
    SigningTime(9, Type.UInt32),
    Expiration(10, Type.UInt32),
    TransferRate(11, Type.UInt32),
    WalletSize(12, Type.UInt32),
    OwnerCount(13, Type.UInt32),
    DestinationTag(14, Type.UInt32),
    HighQualityIn(16, Type.UInt32),
    HighQualityOut(17, Type.UInt32),
    LowQualityIn(18, Type.UInt32),
    LowQualityOut(19, Type.UInt32),
    QualityIn(20, Type.UInt32),
    QualityOut(21, Type.UInt32),
    StampEscrow(22, Type.UInt32),
    BondAmount(23, Type.UInt32),
    LoadFee(24, Type.UInt32),
    OfferSequence(25, Type.UInt32),
    FirstLedgerSequence(26, Type.UInt32),
    LastLedgerSequence(27, Type.UInt32),
    TransactionIndex(28, Type.UInt32),
    OperationLimit(29, Type.UInt32),
    ReferenceFeeUnits(30, Type.UInt32),
    ReserveBase(31, Type.UInt32),
    ReserveIncrement(32, Type.UInt32),
    SetFlag(33, Type.UInt32),
    ClearFlag(34, Type.UInt32),
    SignerQuorum(35, Type.UInt32),
    CancelAfter(36, Type.UInt32),
    FinishAfter(37, Type.UInt32),
    SignerListID(38, Type.UInt32),
    TxnLgrSeq(50, Type.UInt32),
    CreateLgrSeq(51, Type.UInt32),
    NeedVerify(52, Type.UInt32),
    Nonce(53, Type.UInt32),
    Gas(55, Type.UInt32),
    IndexNext(1, Type.UInt64),
    IndexPrevious(2, Type.UInt64),
    BookNode(3, Type.UInt64),
    OwnerNode(4, Type.UInt64),
    BaseFee(5, Type.UInt64),
    ExchangeRate(6, Type.UInt64),
    LowNode(7, Type.UInt64),
    HighNode(8, Type.UInt64),
    EmailHash(1, Type.Hash128),
    LedgerHash(1, Type.Hash256),
    ParentHash(2, Type.Hash256),
    TransactionHash(3, Type.Hash256),
    AccountHash(4, Type.Hash256),
    PreviousTxnID(5, Type.Hash256),
    LedgerIndex(6, Type.Hash256),
    WalletLocator(7, Type.Hash256),
    RootIndex(8, Type.Hash256),
    AccountTxnID(9, Type.Hash256),
    BookDirectory(16, Type.Hash256),
    InvoiceID(17, Type.Hash256),
    Nickname(18, Type.Hash256),
    Amendment(19, Type.Hash256),
    TicketID(20, Type.Hash256),
    Digest(21, Type.Hash256),
    PayChannel(22, Type.Hash256),
    PrevTxnLedgerHash(50, Type.Hash256),
    TxnLedgerHash(51, Type.Hash256),
    TxCheckHash(52, Type.Hash256),
    CreatedLedgerHash(53, Type.Hash256),
    CreatedTxnHash(54, Type.Hash256),
    CurTxHash(55, Type.Hash256),
    FutureTxHash(56, Type.Hash256),
    hash(257, Type.Hash256),
    index(258, Type.Hash256),
    Amount(1, Type.Amount),
    Balance(2, Type.Amount),
    LimitAmount(3, Type.Amount),
    TakerPays(4, Type.Amount),
    TakerGets(5, Type.Amount),
    LowLimit(6, Type.Amount),
    HighLimit(7, Type.Amount),
    Fee(8, Type.Amount),
    SendMax(9, Type.Amount),
    DeliverMin(10, Type.Amount),
    MinimumOffer(16, Type.Amount),
    RippleEscrow(17, Type.Amount),
    DeliveredAmount(18, Type.Amount),
    ContractValue(19, Type.Amount),
    taker_gets_funded(258, Type.Amount),
    taker_pays_funded(259, Type.Amount),
    PublicKey(1, Type.Blob),
    MessageKey(2, Type.Blob),
    SigningPubKey(3, Type.Blob),
    TxnSignature(4, Type.Blob),
    Signature(6, Type.Blob),
    Domain(7, Type.Blob),
    FundCode(8, Type.Blob),
    RemoveCode(9, Type.Blob),
    ExpireCode(10, Type.Blob),
    CreateCode(11, Type.Blob),
    MemoType(12, Type.Blob),
    MemoData(13, Type.Blob),
    MemoFormat(14, Type.Blob),
    Fulfillment(16, Type.Blob),
    Condition(17, Type.Blob),
    MasterSignature(18, Type.Blob),
    Token(50, Type.Blob),
    TableName(51, Type.Blob),
    Raw(52, Type.Blob),
    TableNewName(53, Type.Blob),
    AutoFillField(54, Type.Blob),
    Statements(55, Type.Blob),
    OperationRule(56, Type.Blob),
    TransferFeeMin(62, Type.Blob),
    TransferFeeMax(63, Type.Blob),
    ContractCode(64, Type.Blob),
    ContractData(65, Type.Blob),
    Account(1, Type.AccountID),
    Owner(2, Type.AccountID),
    Destination(3, Type.AccountID),
    Issuer(4, Type.AccountID),
    Target(7, Type.AccountID),
    RegularKey(8, Type.AccountID),
    User(50, Type.AccountID),
    OriginalAddress(51, Type.AccountID),
    ContractAddress(52, Type.AccountID),
    ObjectEndMarker(1, Type.STObject),
    TransactionMetaData(2, Type.STObject),
    CreatedNode(3, Type.STObject),
    DeletedNode(4, Type.STObject),
    ModifiedNode(5, Type.STObject),
    PreviousFields(6, Type.STObject),
    FinalFields(7, Type.STObject),
    NewFields(8, Type.STObject),
    TemplateEntry(9, Type.STObject),
    Memo(10, Type.STObject),
    SignerEntry(11, Type.STObject),
    Signer(16, Type.STObject),
    Majority(18, Type.STObject),
    Table(50, Type.STObject),
    ArrayEndMarker(1, Type.STArray),
    Signers(3, Type.STArray),
    SignerEntries(4, Type.STArray),
    Template(5, Type.STArray),
    Necessary(6, Type.STArray),
    Sufficient(7, Type.STArray),
    AffectedNodes(8, Type.STArray),
    Memos(9, Type.STArray),
    Majorities(16, Type.STArray),
    TableEntries(50, Type.STArray),
    Tables(51, Type.STArray),
    Users(52, Type.STArray),
    CloseResolution(1, Type.UInt8),
    Method(2, Type.UInt8),
    TransactionResult(3, Type.UInt8),
    TakerPaysCurrency(1, Type.Hash160),
    TakerPaysIssuer(2, Type.Hash160),
    TakerGetsCurrency(3, Type.Hash160),
    TakerGetsIssuer(4, Type.Hash160),
    NameInDB(50, Type.Hash160),
    Paths(1, Type.PathSet),
    Indexes(1, Type.Vector256),
    Hashes(2, Type.Vector256),
    Amendments(3, Type.Vector256),
    StorageOverlay(1, Type.Map256),
    Transaction(1, Type.Transaction),
    LedgerEntry(1, Type.LedgerEntry),
    Validation(1, Type.Validation);

    public final int id;
    boolean signingField = true;
    boolean isSerialized = true;
    boolean isVlEncoded = false;
    final int code;
    final Type type;
    private final byte[] bytes;
    public Object tag = null;
    private static HashMap<Integer, Field> byCode;
    public static Comparator<Field> comparator;

    public static Field fromString(String key) {
        Field f;
        try {
            f = Field.valueOf(key);
        }
        catch (IllegalArgumentException e) {
            f = null;
        }
        return f;
    }

    public static byte[] asBytes(Field field) {
        int name = field.getId();
        int type = field.getType().getId();
        ArrayList<Byte> header = new ArrayList<Byte>(3);
        if (type < 16) {
            if (name < 16) {
                header.add((byte)(type << 4 | name));
            } else {
                header.add((byte)(type << 4));
                header.add((byte)name);
            }
        } else if (name < 16) {
            header.add((byte)name);
            header.add((byte)type);
        } else {
            header.add((byte)0);
            header.add((byte)type);
            header.add((byte)name);
        }
        byte[] headerBytes = new byte[header.size()];
        for (int i = 0; i < header.size(); ++i) {
            headerBytes[i] = (Byte)header.get(i);
        }
        return headerBytes;
    }

    public int getId() {
        return this.id;
    }

    private Field(int fid, Type tid) {
        this.id = fid;
        this.type = tid;
        this.code = this.type.id << 16 | fid;
        this.bytes = (byte[])(this.isSerialized() ? Field.asBytes(this) : null);
        this.isSerialized = Field.isSerialized(this);
    }

    public static Iterator<Field> sorted(Collection<Field> fields) {
        ArrayList<Field> fieldList = new ArrayList<Field>(fields);
        Collections.sort(fieldList, comparator);
        return fieldList.iterator();
    }

    public static Field fromCode(Integer integer) {
        return byCode.get(integer);
    }

    public Type getType() {
        return this.type;
    }

    public boolean isSerialized() {
        return this.isSerialized;
    }

    public boolean isVLEncoded() {
        return this.isVlEncoded;
    }

    public boolean isSigningField() {
        return this.signingField;
    }

    private static boolean isSerialized(Field f) {
        return f.type.id > 0 && f.type.id < 256 && f.id > 0 && f.id < 256;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    static {
        byCode = new HashMap();
        comparator = new Comparator<Field>(){

            @Override
            public int compare(Field o1, Field o2) {
                return o1.code - o2.code;
            }
        };
        block3: for (Field f : Field.values()) {
            byCode.put(f.code, f);
            f.signingField = f.isSerialized = Field.isSerialized(f);
            switch (f.type) {
                case Blob: 
                case AccountID: 
                case Vector256: {
                    f.isVlEncoded = true;
                    continue block3;
                }
            }
        }
        Field.TxnSignature.signingField = false;
        Field.Signers.signingField = false;
        Field[] values = Field.values();
        ArrayList<Field> sortedFields = new ArrayList<Field>(Arrays.asList(values));
        Collections.sort(sortedFields, comparator);
        for (int i = 0; i < values.length; ++i) {
            Field av = values[i];
            Field lv = sortedFields.get(i);
            if (av.code == lv.code) continue;
            throw new RuntimeException("Field enum declaration isn't presorted");
        }
    }
}

