/*
 * Decompiled with CFR 0.152.
 */
package com.peersafe.base.core.fields;

import java.util.Map;
import java.util.TreeMap;

public enum Type {
    Unknown(-2),
    Done(-1),
    NotPresent(0),
    UInt16(1),
    UInt32(2),
    UInt64(3),
    Hash128(4),
    Hash256(5),
    Amount(6),
    Blob(7),
    AccountID(8),
    STObject(14),
    STArray(15),
    UInt8(16),
    Hash160(17),
    PathSet(18),
    Vector256(19),
    Map256(29),
    Transaction(10001),
    LedgerEntry(10002),
    Validation(10003);

    private static Map<Integer, Type> byInt;
    final int id;

    public static Type valueOf(Integer integer) {
        return byInt.get(integer);
    }

    private Type(int type) {
        this.id = type;
    }

    public int getId() {
        return this.id;
    }

    static {
        byInt = new TreeMap<Integer, Type>();
        Type[] typeArray = Type.values();
        int n = typeArray.length;
        for (int i = 0; i < n; ++i) {
            Type a;
            Type t = a = typeArray[i];
            byInt.put(t.id, t);
        }
    }
}

