/*
 * Decompiled with CFR 0.152.
 */
package com.peersafe.base.core.formats;

import com.peersafe.base.core.fields.Field;
import java.util.EnumMap;

public abstract class Format {
    public EnumMap<Field, Requirement> requirementEnumMap = new EnumMap(Field.class);

    public void addCommonFields() {
    }

    public EnumMap<Field, Requirement> requirements() {
        return this.requirementEnumMap;
    }

    public abstract String name();

    public Format(Object[] args) {
        if (args.length % 2 != 0 || args.length < 2) {
            throw new IllegalArgumentException("Varargs length should be a minimum multiple of 2");
        }
        for (int i = 0; i < args.length; i += 2) {
            Field f = (Field)((Object)args[i]);
            Requirement r = (Requirement)((Object)args[i + 1]);
            this.put(f, r);
        }
    }

    protected void put(Field f, Requirement r) {
        this.requirementEnumMap.put(f, r);
    }

    public static enum Requirement {
        INVALID(-1),
        REQUIRED(0),
        OPTIONAL(1),
        DEFAULT(2);


        private Requirement(int i) {
        }
    }
}

