/*
 * Decompiled with CFR 0.152.
 */
package com.peersafe.base.core.formats;

import com.peersafe.base.core.fields.Field;
import com.peersafe.base.core.formats.Format;
import com.peersafe.base.core.serialized.enums.TransactionType;
import java.util.EnumMap;

public class TxFormat
extends Format {
    public static EnumMap<TransactionType, TxFormat> formats = new EnumMap(TransactionType.class);
    public final TransactionType transactionType;
    public static TxFormat AccountSet = new TxFormat(TransactionType.AccountSet, new Object[]{Field.EmailHash, Format.Requirement.OPTIONAL, Field.WalletLocator, Format.Requirement.OPTIONAL, Field.WalletSize, Format.Requirement.OPTIONAL, Field.MessageKey, Format.Requirement.OPTIONAL, Field.Domain, Format.Requirement.OPTIONAL, Field.TransferRate, Format.Requirement.OPTIONAL, Field.TransferFeeMin, Format.Requirement.OPTIONAL, Field.TransferFeeMax, Format.Requirement.OPTIONAL, Field.SetFlag, Format.Requirement.OPTIONAL, Field.ClearFlag, Format.Requirement.OPTIONAL});
    public static TxFormat TrustSet = new TxFormat(TransactionType.TrustSet, new Object[]{Field.LimitAmount, Format.Requirement.OPTIONAL, Field.QualityIn, Format.Requirement.OPTIONAL, Field.QualityOut, Format.Requirement.OPTIONAL});
    public static TxFormat OfferCreate = new TxFormat(TransactionType.OfferCreate, new Object[]{Field.TakerPays, Format.Requirement.REQUIRED, Field.TakerGets, Format.Requirement.REQUIRED, Field.Expiration, Format.Requirement.OPTIONAL, Field.OfferSequence, Format.Requirement.OPTIONAL});
    public static TxFormat OfferCancel = new TxFormat(TransactionType.OfferCancel, new Object[]{Field.OfferSequence, Format.Requirement.REQUIRED});
    public static TxFormat TicketCreate = new TxFormat(TransactionType.TicketCreate, new Object[]{Field.Target, Format.Requirement.OPTIONAL, Field.Expiration, Format.Requirement.OPTIONAL});
    public static TxFormat TicketCancel = new TxFormat(TransactionType.TicketCancel, new Object[]{Field.TicketID, Format.Requirement.REQUIRED});
    public static TxFormat SignerListSet = new TxFormat(TransactionType.SignerListSet, new Object[]{Field.SignerQuorum, Format.Requirement.REQUIRED, Field.SignerEntries, Format.Requirement.OPTIONAL});
    public static TxFormat SetRegularKey = new TxFormat(TransactionType.SetRegularKey, new Object[]{Field.RegularKey, Format.Requirement.OPTIONAL});
    public static TxFormat Payment = new TxFormat(TransactionType.Payment, new Object[]{Field.Destination, Format.Requirement.REQUIRED, Field.Amount, Format.Requirement.REQUIRED, Field.SendMax, Format.Requirement.OPTIONAL, Field.Paths, Format.Requirement.DEFAULT, Field.InvoiceID, Format.Requirement.OPTIONAL, Field.DestinationTag, Format.Requirement.OPTIONAL});
    public static TxFormat EscrowCreate = new TxFormat(TransactionType.EscrowCreate, new Object[]{Field.Destination, Format.Requirement.REQUIRED, Field.Amount, Format.Requirement.REQUIRED, Field.Condition, Format.Requirement.OPTIONAL, Field.CancelAfter, Format.Requirement.OPTIONAL, Field.FinishAfter, Format.Requirement.OPTIONAL, Field.DestinationTag, Format.Requirement.OPTIONAL});
    public static TxFormat EscrowFinish = new TxFormat(TransactionType.EscrowFinish, new Object[]{Field.Owner, Format.Requirement.REQUIRED, Field.OfferSequence, Format.Requirement.REQUIRED, Field.Fulfillment, Format.Requirement.OPTIONAL, Field.Condition, Format.Requirement.OPTIONAL});
    public static TxFormat EscrowCancel = new TxFormat(TransactionType.EscrowCancel, new Object[]{Field.Owner, Format.Requirement.REQUIRED, Field.OfferSequence, Format.Requirement.REQUIRED});
    public static TxFormat TableListSet = new TxFormat(TransactionType.TableListSet, new Object[]{Field.Tables, Format.Requirement.REQUIRED, Field.TableNewName, Format.Requirement.OPTIONAL, Field.User, Format.Requirement.OPTIONAL, Field.Raw, Format.Requirement.OPTIONAL, Field.Token, Format.Requirement.OPTIONAL, Field.OpType, Format.Requirement.REQUIRED, Field.TxnLgrSeq, Format.Requirement.OPTIONAL, Field.OriginalAddress, Format.Requirement.OPTIONAL, Field.CurTxHash, Format.Requirement.OPTIONAL, Field.FutureTxHash, Format.Requirement.OPTIONAL, Field.OperationRule, Format.Requirement.OPTIONAL});
    public static TxFormat SQLStatement = new TxFormat(TransactionType.SQLStatement, new Object[]{Field.Owner, Format.Requirement.REQUIRED, Field.Tables, Format.Requirement.REQUIRED, Field.Raw, Format.Requirement.REQUIRED, Field.AutoFillField, Format.Requirement.OPTIONAL, Field.TxCheckHash, Format.Requirement.OPTIONAL, Field.OpType, Format.Requirement.REQUIRED, Field.TxnLgrSeq, Format.Requirement.OPTIONAL, Field.OriginalAddress, Format.Requirement.OPTIONAL, Field.CurTxHash, Format.Requirement.OPTIONAL, Field.FutureTxHash, Format.Requirement.OPTIONAL});
    public static TxFormat SQLTransaction = new TxFormat(TransactionType.SQLTransaction, new Object[]{Field.Statements, Format.Requirement.REQUIRED, Field.NeedVerify, Format.Requirement.REQUIRED, Field.TxnLgrSeq, Format.Requirement.OPTIONAL, Field.OriginalAddress, Format.Requirement.OPTIONAL, Field.CurTxHash, Format.Requirement.OPTIONAL, Field.FutureTxHash, Format.Requirement.OPTIONAL});
    public static TxFormat Contract = new TxFormat(TransactionType.Contract, new Object[]{Field.ContractOpType, Format.Requirement.REQUIRED, Field.ContractData, Format.Requirement.REQUIRED, Field.Gas, Format.Requirement.REQUIRED, Field.ContractAddress, Format.Requirement.OPTIONAL, Field.ContractValue, Format.Requirement.OPTIONAL});
    public static TxFormat EnableAmendment = new TxFormat(TransactionType.EnableAmendment, new Object[]{Field.Amendment, Format.Requirement.REQUIRED});
    public static TxFormat SetFee = new TxFormat(TransactionType.SetFee, new Object[]{Field.BaseFee, Format.Requirement.REQUIRED, Field.ReferenceFeeUnits, Format.Requirement.REQUIRED, Field.ReserveBase, Format.Requirement.REQUIRED, Field.ReserveIncrement, Format.Requirement.REQUIRED});

    public static TxFormat fromString(String name) {
        return TxFormat.getTxFormat(TransactionType.valueOf(name));
    }

    public static TxFormat fromNumber(Number ord) {
        return TxFormat.getTxFormat(TransactionType.fromNumber(ord));
    }

    public static TxFormat fromValue(Object o) {
        if (o instanceof Number) {
            return TxFormat.fromNumber(((Number)o).intValue());
        }
        if (o instanceof String) {
            return TxFormat.fromString((String)o);
        }
        return null;
    }

    private static TxFormat getTxFormat(TransactionType key) {
        if (key == null) {
            return null;
        }
        return formats.get(key);
    }

    public TxFormat(TransactionType type, Object ... args) {
        super(args);
        this.transactionType = type;
        this.addCommonFields();
        formats.put(this.transactionType, this);
    }

    @Override
    public void addCommonFields() {
        this.put(Field.TransactionType, Format.Requirement.REQUIRED);
        this.put(Field.Account, Format.Requirement.REQUIRED);
        this.put(Field.Sequence, Format.Requirement.REQUIRED);
        this.put(Field.Fee, Format.Requirement.REQUIRED);
        this.put(Field.SigningPubKey, Format.Requirement.REQUIRED);
        this.put(Field.Flags, Format.Requirement.OPTIONAL);
        this.put(Field.SourceTag, Format.Requirement.OPTIONAL);
        this.put(Field.PreviousTxnID, Format.Requirement.OPTIONAL);
        this.put(Field.OperationLimit, Format.Requirement.OPTIONAL);
        this.put(Field.TxnSignature, Format.Requirement.OPTIONAL);
        this.put(Field.AccountTxnID, Format.Requirement.OPTIONAL);
        this.put(Field.LastLedgerSequence, Format.Requirement.OPTIONAL);
        this.put(Field.Memos, Format.Requirement.OPTIONAL);
        this.put(Field.Signers, Format.Requirement.OPTIONAL);
    }

    @Override
    public String name() {
        return this.transactionType.toString();
    }
}

