/*
 * Decompiled with CFR 0.152.
 */
package com.peersafe.base.core.serialized;

import com.peersafe.base.core.serialized.BytesSink;
import java.security.MessageDigest;
import java.util.ArrayList;

public class BytesList
implements BytesSink {
    private ArrayList<byte[]> buffer = new ArrayList();
    private int len = 0;
    public static String[] hexLookup = new String[256];

    public void add(BytesList bl) {
        for (byte[] bytes : bl.rawList()) {
            this.add(bytes);
        }
    }

    @Override
    public void add(byte aByte) {
        this.add(new byte[]{aByte});
    }

    @Override
    public void add(byte[] bytes) {
        this.len += bytes.length;
        this.buffer.add(bytes);
    }

    public int get8(int offset) {
        if (offset + 1 > this.len) {
            return -1;
        }
        return this.bytes()[offset] & 0xFF;
    }

    public int getInteger(int offset) {
        if (offset + 4 > this.len) {
            return -1;
        }
        int number = 0;
        byte[] bts = this.bytes();
        for (int i = 0; i < 4; ++i) {
            if (i != 0) {
                number <<= 8;
            }
            number |= bts[offset + i];
        }
        return number;
    }

    public byte[] bytes() {
        int n = this.bytesLength();
        byte[] bytes = new byte[n];
        this.addBytes(bytes, 0);
        return bytes;
    }

    public String bytesHex() {
        StringBuilder builder = new StringBuilder(this.len * 2);
        for (byte[] buf : this.buffer) {
            for (byte aBytes : buf) {
                builder.append(hexLookup[aBytes & 0xFF]);
            }
        }
        return builder.toString();
    }

    public int bytesLength() {
        return this.len;
    }

    private int addBytes(byte[] bytes, int destPos) {
        for (byte[] buf : this.buffer) {
            System.arraycopy(buf, 0, bytes, destPos, buf.length);
            destPos += buf.length;
        }
        return destPos;
    }

    public void updateDigest(MessageDigest digest) {
        for (byte[] buf : this.buffer) {
            digest.update(buf);
        }
    }

    public ArrayList<byte[]> rawList() {
        return this.buffer;
    }

    static {
        for (int i = 0; i < 256; ++i) {
            String s = Integer.toHexString(i).toUpperCase();
            if (s.length() == 1) {
                s = "0" + s;
            }
            BytesList.hexLookup[i] = s;
        }
    }
}

