/*
 * Decompiled with CFR 0.152.
 */
package com.peersafe.base.core.serialized;

import com.peersafe.base.core.serialized.BinaryParser;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.zip.GZIPInputStream;

public class StreamBinaryParser
extends BinaryParser {
    final BufferedInputStream stream;

    public StreamBinaryParser(InputStream stream, long size) {
        super((int)size);
        this.stream = new BufferedInputStream(stream);
    }

    private static boolean isGZip(File fio) {
        return fio.getName().endsWith("gz");
    }

    private static int getUncompressedSize(File fio) {
        if (StreamBinaryParser.isGZip(fio)) {
            int val;
            try {
                RandomAccessFile raf = new RandomAccessFile(fio, "r");
                raf.seek(raf.length() - 4L);
                int b4 = raf.read();
                int b3 = raf.read();
                int b2 = raf.read();
                int b1 = raf.read();
                val = b1 << 24 | (b2 << 16) + (b3 << 8) + b4;
                raf.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return val;
        }
        return (int)fio.length();
    }

    @Override
    public void skip(int n) {
        try {
            long skipped = this.stream.skip(n);
            if (skipped != (long)n) {
                throw new RuntimeException("Expected to skip more bytes");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public byte readOne() {
        return this.read(1)[0];
    }

    @Override
    public byte[] read(int n) {
        byte[] ret = new byte[n];
        try {
            int read = this.stream.read(ret);
            if (read != n) {
                throw new RuntimeException("Expected to read more bytes");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.cursor += n;
        return ret;
    }

    public static StreamBinaryParser fromFile(String path) {
        try {
            FileInputStream fstream;
            File f = new File(path);
            InputStream stream = fstream = new FileInputStream(path);
            long s = fstream.getChannel().size();
            if (StreamBinaryParser.isGZip(f)) {
                s = StreamBinaryParser.getUncompressedSize(f);
                stream = new GZIPInputStream(fstream);
            }
            return new StreamBinaryParser(stream, s);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

