/*
 * Decompiled with CFR 0.152.
 */
package com.peersafe.base.core.types.known.sle;

import com.peersafe.base.core.coretypes.AccountID;
import com.peersafe.base.core.coretypes.Amount;
import com.peersafe.base.core.coretypes.STObject;
import com.peersafe.base.core.coretypes.hash.Hash256;
import com.peersafe.base.core.coretypes.uint.UInt32;
import com.peersafe.base.core.fields.Field;
import com.peersafe.base.core.formats.LEFormat;
import com.peersafe.base.core.serialized.SerializedType;
import com.peersafe.base.core.serialized.enums.LedgerEntryType;
import com.peersafe.base.core.types.known.sle.entries.AccountRoot;
import com.peersafe.base.core.types.known.sle.entries.DirectoryNode;
import com.peersafe.base.core.types.known.sle.entries.Offer;
import com.peersafe.base.core.types.known.sle.entries.RippleState;
import java.util.TreeSet;

public class LedgerEntry
extends STObject {
    public LedgerEntry(LedgerEntryType type) {
        this.setFormat(LEFormat.formats.get(type));
        this.put(Field.LedgerEntryType, type);
    }

    public LedgerEntryType ledgerEntryType() {
        return LedgerEntry.ledgerEntryType(this);
    }

    public Hash256 index() {
        return this.get(Hash256.index);
    }

    public UInt32 flags() {
        return this.get(UInt32.Flags);
    }

    public Hash256 ledgerIndex() {
        return this.get(Hash256.LedgerIndex);
    }

    public void flags(UInt32 val) {
        this.put(Field.Flags, (SerializedType)val);
    }

    public void ledgerIndex(Hash256 val) {
        this.put(Field.LedgerIndex, (SerializedType)val);
    }

    public TreeSet<AccountID> owners() {
        TreeSet<AccountID> owners = new TreeSet<AccountID>();
        if (this.has(Field.LowLimit)) {
            owners.add(this.get(Amount.LowLimit).issuer());
        }
        if (this.has(Field.HighLimit)) {
            owners.add(this.get(Amount.HighLimit).issuer());
        }
        if (this.has(Field.Account)) {
            owners.add(this.get(AccountID.Account));
        }
        return owners;
    }

    public void index(Hash256 index) {
        this.put(Hash256.index, index);
    }

    public void setDefaults() {
        if (this.flags() == null) {
            this.flags(UInt32.ZERO);
        }
    }

    public static abstract class OnLedgerEntry {
        public abstract void onOffer(Offer var1);

        public abstract void onDirectoryNode(DirectoryNode var1);

        public abstract void onRippleState(RippleState var1);

        public abstract void onAccountRoot(AccountRoot var1);

        public abstract void onAll(LedgerEntry var1);

        public void onObject(STObject object) {
            if (object instanceof Offer) {
                this.onOffer((Offer)object);
            } else if (object instanceof AccountRoot) {
                this.onAccountRoot((AccountRoot)object);
            } else if (object instanceof DirectoryNode) {
                this.onDirectoryNode((DirectoryNode)object);
            } else if (object instanceof RippleState) {
                this.onRippleState((RippleState)object);
            }
            this.onAll((LedgerEntry)object);
        }
    }
}

