/*
 * Decompiled with CFR 0.152.
 */
package com.peersafe.base.core.types.ledger;

import com.peersafe.base.core.binary.STReader;
import com.peersafe.base.core.coretypes.RippleDate;
import com.peersafe.base.core.coretypes.hash.HalfSha512;
import com.peersafe.base.core.coretypes.hash.Hash256;
import com.peersafe.base.core.coretypes.hash.prefixes.HashPrefix;
import com.peersafe.base.core.coretypes.uint.UInt32;
import com.peersafe.base.core.coretypes.uint.UInt64;
import com.peersafe.base.core.coretypes.uint.UInt8;
import com.peersafe.base.core.serialized.BinaryParser;
import com.peersafe.base.core.serialized.BytesSink;
import java.util.Date;
import org.json.JSONWriter;

public class LedgerHeader {
    public UInt32 version;
    public UInt32 sequence;
    public UInt64 totalXRP;
    public Hash256 previousLedger;
    public Hash256 transactionHash;
    public Hash256 stateHash;
    public UInt32 parentCloseTime;
    public UInt32 closeTime;
    public UInt8 closeResolution;
    public UInt8 closeFlags;
    public Date closeDate;

    public LedgerHeader() {
        this.version = HashPrefix.ledgerMaster.uInt32;
    }

    public static LedgerHeader fromParser(BinaryParser parser) {
        return LedgerHeader.fromReader(new STReader(parser));
    }

    public static LedgerHeader fromReader(STReader reader) {
        LedgerHeader ledger = new LedgerHeader();
        ledger.sequence = reader.uInt32();
        ledger.totalXRP = reader.uInt64();
        ledger.previousLedger = reader.hash256();
        ledger.transactionHash = reader.hash256();
        ledger.stateHash = reader.hash256();
        ledger.parentCloseTime = reader.uInt32();
        ledger.closeTime = reader.uInt32();
        ledger.closeResolution = reader.uInt8();
        ledger.closeFlags = reader.uInt8();
        ledger.closeDate = RippleDate.fromSecondsSinceRippleEpoch(ledger.closeTime);
        return ledger;
    }

    public void toBytesSink(BytesSink sink) {
        this.sequence.toBytesSink(sink);
        this.totalXRP.toBytesSink(sink);
        this.previousLedger.toBytesSink(sink);
        this.transactionHash.toBytesSink(sink);
        this.stateHash.toBytesSink(sink);
        this.parentCloseTime.toBytesSink(sink);
        this.closeTime.toBytesSink(sink);
        this.closeResolution.toBytesSink(sink);
        this.closeFlags.toBytesSink(sink);
    }

    public Hash256 hash() {
        HalfSha512 half = HalfSha512.prefixed256(HashPrefix.ledgerMaster);
        this.toBytesSink(half);
        return half.finish();
    }

    public void toJSONWriter(JSONWriter writer) {
        writer.key("ledger_index");
        writer.value(this.sequence.toJSON());
        writer.key("total_coins");
        writer.value((Object)this.totalXRP.toString(10));
        writer.key("parent_hash");
        writer.value(this.previousLedger.toJSON());
        writer.key("transaction_hash");
        writer.value(this.transactionHash.toJSON());
        writer.key("account_hash");
        writer.value(this.stateHash.toJSON());
        writer.key("close_time");
        writer.value(this.closeTime.toJSON());
        writer.key("parent_close_time");
        writer.value(this.parentCloseTime.toJSON());
        writer.key("close_time_resolution");
        writer.value(this.closeResolution.toJSON());
        writer.key("close_flags");
        writer.value(this.closeFlags.toJSON());
    }
}

