/*
 * Decompiled with CFR 0.152.
 */
package com.peersafe.base.core.types.shamap;

import com.peersafe.base.core.coretypes.hash.HalfSha512;
import com.peersafe.base.core.coretypes.hash.Hash256;

public class NodeStore {
    KeyValueBackend backend;

    public NodeStore(KeyValueBackend backend) {
        this.backend = backend;
    }

    private Hash256 storeContent(byte[] content) {
        HalfSha512 hasher = new HalfSha512();
        hasher.update(content);
        Hash256 key = hasher.finish();
        this.storeHashKeyedContent(key, content);
        return key;
    }

    private void storeHashKeyedContent(Hash256 hash, byte[] content) {
        this.backend.put(hash, content);
    }

    public byte[] get(Hash256 hash) {
        return this.backend.get(hash);
    }

    public Hash256 set(byte[] content) {
        return this.storeContent(content);
    }

    public static interface KeyValueBackend {
        public void put(Hash256 var1, byte[] var2);

        public byte[] get(Hash256 var1);
    }
}

