/*
 * Decompiled with CFR 0.152.
 */
package com.peersafe.base.utils;

import com.peersafe.base.utils.Sha512;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.bouncycastle.crypto.digests.RIPEMD160Digest;

public class HashUtils {
    private static final MessageDigest digest;

    public static byte[] doubleDigest(byte[] input) {
        return HashUtils.doubleDigest(input, 0, input.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] doubleDigest(byte[] input, int offset, int length) {
        MessageDigest messageDigest = digest;
        synchronized (messageDigest) {
            digest.reset();
            digest.update(input, offset, length);
            byte[] first = digest.digest();
            return digest.digest(first);
        }
    }

    public static byte[] halfSha512(byte[] bytes) {
        return new Sha512(bytes).finish256();
    }

    public static byte[] quarterSha512(byte[] bytes) {
        return new Sha512(bytes).finish128();
    }

    public static byte[] sha512(byte[] bytes) {
        return new Sha512(bytes).finish();
    }

    public static byte[] SHA256_RIPEMD160(byte[] input) {
        try {
            byte[] sha256 = MessageDigest.getInstance("SHA-256").digest(input);
            RIPEMD160Digest digest = new RIPEMD160Digest();
            digest.update(sha256, 0, sha256.length);
            byte[] out = new byte[20];
            digest.doFinal(out, 0);
            return out;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        try {
            digest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

