/*
 * Decompiled with CFR 0.152.
 */
package com.peersafe.chainsql.contract;

import com.peersafe.abi.EventEncoder;
import com.peersafe.abi.EventValues;
import com.peersafe.abi.FunctionEncoder;
import com.peersafe.abi.FunctionReturnDecoder;
import com.peersafe.abi.TypeReference;
import com.peersafe.abi.datatypes.Address;
import com.peersafe.abi.datatypes.Event;
import com.peersafe.abi.datatypes.Function;
import com.peersafe.abi.datatypes.Type;
import com.peersafe.base.client.pubsub.Publisher;
import com.peersafe.base.core.coretypes.Amount;
import com.peersafe.base.core.serialized.enums.TransactionType;
import com.peersafe.base.core.types.known.tx.Transaction;
import com.peersafe.chainsql.contract.exception.ContractCallException;
import com.peersafe.chainsql.contract.exception.TransactionException;
import com.peersafe.chainsql.core.Chainsql;
import com.peersafe.chainsql.core.Submit;
import com.peersafe.chainsql.util.Util;
import java.lang.reflect.Constructor;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class Contract
extends Submit {
    public static final BigInteger GAS_LIMIT = BigInteger.valueOf(300000L);
    public static final BigInteger INITIAL_DROPS = BigInteger.valueOf(5000000L);
    public static final String FUNC_DEPLOY = "deploy";
    protected final String contractBinary;
    protected String contractAddress;
    protected Map<String, String> deployedAddresses;
    protected BigInteger gasLimit;
    protected Chainsql chainsql;
    private JSONObject mTxJson;

    protected Contract(Chainsql chainsql, String contractBinary, String contractAddress, BigInteger gasLimit) {
        this.chainsql = chainsql;
        this.contractAddress = contractAddress;
        this.contractBinary = contractBinary;
        this.gasLimit = gasLimit;
        this.connection = chainsql.connection;
        this.eventManager = chainsql.eventManager();
    }

    public void setTxJson(JSONObject json) {
        this.mTxJson = json;
    }

    public void setContractAddress(String contractAddress) {
        this.contractAddress = contractAddress;
    }

    public String getContractAddress() {
        return this.contractAddress;
    }

    public String getContractBinary() {
        return this.contractBinary;
    }

    public BigInteger getGasLimit() {
        return this.gasLimit;
    }

    public Chainsql getChainsql() {
        return this.chainsql;
    }

    private List<Type> executeCall(Function function) throws ContractCallException {
        JSONObject objTx = this.prepareCallParam(function);
        JSONObject ret = this.chainsql.connection.client.contractCall(objTx);
        if (ret.has("error")) {
            throw new ContractCallException(ret.getString("error"));
        }
        return FunctionReturnDecoder.decode((String)ret.getString("contract_call_result"), (List)function.getOutputParameters());
    }

    private void executeCall(final Function function, final Publisher.Callback<List<Type>> cb) throws ContractCallException {
        JSONObject objTx = this.prepareCallParam(function);
        this.chainsql.connection.client.contractCall(objTx, new Publisher.Callback<JSONObject>(){

            @Override
            public void called(JSONObject ret) {
                if (ret.has("error")) {
                    throw new ContractCallException(ret.getString("error"));
                }
                cb.called(FunctionReturnDecoder.decode((String)ret.getString("contract_call_result"), (List)function.getOutputParameters()));
            }
        });
    }

    private JSONObject prepareCallParam(Function function) {
        String encodedFunction = FunctionEncoder.encode((Function)function);
        String data = encodedFunction.substring(2, encodedFunction.length());
        JSONObject objTx = new JSONObject();
        objTx.put("account", (Object)this.chainsql.connection.address);
        objTx.put("contract_data", (Object)data);
        objTx.put("contract_address", (Object)this.contractAddress);
        return objTx;
    }

    protected <T extends Type> T executeCallSingleValueReturn(Function function) throws ContractCallException {
        List<Type> values = this.executeCall(function);
        if (!values.isEmpty()) {
            return (T)values.get(0);
        }
        return null;
    }

    protected <T extends Type> void executeCallSingleValueReturn(Function function, final Publisher.Callback<T> cb) throws ContractCallException {
        this.executeCall(function, new Publisher.Callback<List<Type>>(){

            @Override
            public void called(List<Type> values) {
                if (!values.isEmpty()) {
                    cb.called(values.get(0));
                } else {
                    cb.called(null);
                }
            }
        });
    }

    protected <T extends Type, R> R executeCallSingleValueReturn(Function function, Class<R> returnType) throws ContractCallException {
        T result = this.executeCallSingleValueReturn(function);
        if (result == null) {
            throw new ContractCallException("Empty value (0x) returned from contract");
        }
        Object value = result.getValue();
        if (returnType.isAssignableFrom(value.getClass())) {
            return (R)value;
        }
        if (result.getClass().equals(Address.class) && returnType.equals(String.class)) {
            return (R)result.toString();
        }
        throw new ContractCallException("Unable to convert response: " + value + " to expected type: " + returnType.getSimpleName());
    }

    protected <T extends Type, R> void executeCallSingleValueReturn(Function function, final Class<R> returnType, final Publisher.Callback<R> cb) throws ContractCallException {
        this.executeCallSingleValueReturn(function, new Publisher.Callback<T>(){

            @Override
            public void called(T result) {
                if (result == null) {
                    throw new ContractCallException("Empty value (0x) returned from contract");
                }
                Object value = result.getValue();
                if (returnType.isAssignableFrom(value.getClass())) {
                    cb.called(value);
                } else if (result.getClass().equals(Address.class) && returnType.equals(String.class)) {
                    cb.called(result.toString());
                } else {
                    throw new ContractCallException("Unable to convert response: " + value + " to expected type: " + returnType.getSimpleName());
                }
            }
        });
    }

    protected List<Type> executeCallMultipleValueReturn(Function function) throws ContractCallException {
        return this.executeCall(function);
    }

    protected void executeCallMultipleValueReturn(Function function, Publisher.Callback<List<Type>> cb) throws ContractCallException {
        this.executeCall(function, cb);
    }

    protected Contract executeTransaction(Function function) {
        return this.executeTransaction(function, BigInteger.ZERO);
    }

    private Contract executeTransaction(Function function, BigInteger dropValue) {
        return this.executeTransaction(FunctionEncoder.encode((Function)function), dropValue, function.getName());
    }

    Contract executeTransaction(String data, BigInteger dropValue, String funcName) {
        JSONObject objTx = new JSONObject();
        objTx.put("Account", (Object)this.chainsql.connection.address);
        objTx.put("ContractOpType", ContractOpType.MessageSend.value());
        if (data.length() > 2) {
            objTx.put("ContractData", (Object)data.substring(2, data.length()));
        } else {
            objTx.put("ContractData", (Object)"");
        }
        objTx.put("Gas", this.gasLimit.intValue());
        if (dropValue.intValue() > 0) {
            objTx.put("ContractValue", (Object)Amount.fromString(dropValue.toString()));
        }
        objTx.put("ContractAddress", (Object)this.contractAddress);
        this.mTxJson = objTx;
        return this;
    }

    @Override
    protected JSONObject prepareSigned() {
        try {
            if (this.mTxJson.toString().equals("{}")) {
                return Util.errorObject("Exception occured:Json not prepared");
            }
            this.mTxJson.put("Account", (Object)this.connection.address);
            Transaction tx = this.toTransaction(this.mTxJson, TransactionType.Contract);
            this.signed = tx.sign(this.connection.secret);
            return Util.successObject();
        }
        catch (Exception e) {
            if (!e.getMessage().equals("")) {
                return Util.errorObject(e.getMessage());
            }
            e.printStackTrace();
            return Util.errorObject("Exception occured");
        }
    }

    protected <T extends Type> T executeRemoteCallSingleValueReturn(Function function) throws ContractCallException {
        return this.executeCallSingleValueReturn(function);
    }

    protected <T> T executeRemoteCallSingleValueReturn(Function function, Class<T> returnType) throws ContractCallException {
        return this.executeCallSingleValueReturn(function, returnType);
    }

    protected <T> void executeRemoteCallSingleValueReturn(Function function, Class<T> returnType, Publisher.Callback<T> cb) throws ContractCallException {
        this.executeCallSingleValueReturn(function, returnType, cb);
    }

    protected List<Type> executeRemoteCallMultipleValueReturn(Function function) throws ContractCallException {
        return this.executeCallMultipleValueReturn(function);
    }

    protected void executeRemoteCallMultipleValueReturn(Function function, Publisher.Callback<List<Type>> cb) throws ContractCallException {
        this.executeCallMultipleValueReturn(function, cb);
    }

    protected Contract executeRemoteCallTransaction(Function function) {
        return this.executeTransaction(function);
    }

    protected Contract executeRemoteCallTransaction(Function function, BigInteger dropValue) {
        return this.executeTransaction(function, dropValue);
    }

    private static <T extends Contract> T create(final T contract, String binary, String encodedConstructor, BigInteger value, final Publisher.Callback<T> cb) throws TransactionException {
        JSONObject objTx = new JSONObject();
        final Chainsql c = contract.getChainsql();
        objTx.put("Account", (Object)c.connection.address);
        objTx.put("ContractOpType", ContractOpType.ContractCreation.value());
        objTx.put("ContractData", (Object)(binary + encodedConstructor));
        objTx.put("Gas", contract.getGasLimit().intValue());
        objTx.put("ContractValue", (Object)Amount.fromString(value.toString()));
        contract.setTxJson(objTx);
        if (cb == null) {
            JSONObject obj = contract.submit(Submit.SyncCond.validate_success);
            String contractAddress = null;
            if (!obj.getString("status").equals("validate_success")) {
                if (obj.has("error_message")) {
                    if (obj.has("error_code")) {
                        throw new TransactionException(obj.getString("error_message"), obj.getInt("error_code"));
                    }
                    throw new TransactionException(obj.getString("error_message"));
                }
                throw new TransactionException("deploy failed,unknown error");
            }
            JSONObject tx = c.connection.client.getTransaction(obj.getString("tx_hash"));
            contractAddress = Util.getNewAccountFromTx(tx);
            contract.setContractAddress(contractAddress);
            return contract;
        }
        contract.submit(new Publisher.Callback<JSONObject>(){

            @Override
            public void called(JSONObject obj) {
                if (!obj.has("transaction")) {
                    return;
                }
                String hash = obj.getJSONObject("transaction").getString("hash");
                if (obj.getString("status").equals("validate_success")) {
                    try {
                        c.connection.client.getTransaction(hash, new Publisher.Callback<JSONObject>(){

                            @Override
                            public void called(JSONObject tx) {
                                if (tx == null) {
                                    cb.called(null);
                                } else {
                                    String contractAddress = Util.getNewAccountFromTx(tx);
                                    contract.setContractAddress(contractAddress);
                                    contract.cb = null;
                                    cb.called(contract);
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        cb.called(null);
                    }
                } else {
                    if (obj.has("error_message")) {
                        System.err.println(obj);
                    }
                    cb.called(null);
                }
            }
        });
        return null;
    }

    protected static <T extends Contract> T deploy(Class<T> type, Chainsql chainsql, BigInteger gasLimit, String binary, String encodedConstructor, BigInteger value) throws TransactionException {
        try {
            Constructor<T> constructor = type.getDeclaredConstructor(Chainsql.class, String.class, BigInteger.class);
            constructor.setAccessible(true);
            Contract contract = (Contract)constructor.newInstance(chainsql, "", gasLimit);
            return (T)Contract.create(contract, binary, encodedConstructor, value, null);
        }
        catch (TransactionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected static <T extends Contract> void deploy(Class<T> type, Chainsql chainsql, BigInteger gasLimit, String binary, String encodedConstructor, BigInteger value, Publisher.Callback<T> cb) throws TransactionException {
        try {
            Constructor<T> constructor = type.getDeclaredConstructor(Chainsql.class, String.class, BigInteger.class);
            constructor.setAccessible(true);
            Contract contract = (Contract)constructor.newInstance(chainsql, binary, gasLimit);
            Contract.create(contract, binary, encodedConstructor, value, cb);
        }
        catch (TransactionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T extends Contract> T deployRemoteCall(Class<T> type, Chainsql chainsql, BigInteger gasLimit, String binary, String encodedConstructor, BigInteger value) throws TransactionException {
        return Contract.deploy(type, chainsql, gasLimit, binary, encodedConstructor, value);
    }

    public static <T extends Contract> void deployRemoteCall(Class<T> type, Chainsql chainsql, BigInteger gasLimit, String binary, String encodedConstructor, BigInteger value, Publisher.Callback<T> cb) throws TransactionException {
        Contract.deploy(type, chainsql, gasLimit, binary, encodedConstructor, value, cb);
    }

    public static <T extends Contract> T deployRemoteCall(Class<T> type, Chainsql chainsql, BigInteger gasLimit, String binary, String encodedConstructor) throws TransactionException {
        return Contract.deployRemoteCall(type, chainsql, gasLimit, binary, encodedConstructor, BigInteger.ZERO);
    }

    public static <T extends Contract> void deployRemoteCall(Class<T> type, Chainsql chainsql, BigInteger gasLimit, String binary, String encodedConstructor, Publisher.Callback<T> cb) throws TransactionException {
        Contract.deployRemoteCall(type, chainsql, gasLimit, binary, encodedConstructor, BigInteger.ZERO, cb);
    }

    public EventValues extractEventParameters(Event event, List<String> topics, String logData) {
        String encodedEventSignature = EventEncoder.encode((Event)event);
        encodedEventSignature = encodedEventSignature.substring(2, encodedEventSignature.length());
        if (!topics.get(0).equals(encodedEventSignature.toUpperCase())) {
            return null;
        }
        ArrayList<Type> indexedValues = new ArrayList<Type>();
        List nonIndexedValues = FunctionReturnDecoder.decode((String)logData, (List)event.getNonIndexedParameters());
        List indexedParameters = event.getIndexedParameters();
        for (int i = 0; i < indexedParameters.size(); ++i) {
            Type value = FunctionReturnDecoder.decodeIndexedValue((String)topics.get(i + 1), (TypeReference)((TypeReference)indexedParameters.get(i)));
            indexedValues.add(value);
        }
        return new EventValues(indexedValues, nonIndexedValues);
    }

    protected void on(final Event event, final Publisher.Callback<EventValues> cb) {
        this.eventManager.subscribeContract(this.contractAddress, event, new Publisher.Callback<JSONObject>(){

            @Override
            public void called(JSONObject args) {
                JSONArray arr = args.getJSONArray("ContractEventTopics");
                ArrayList<String> list = new ArrayList<String>();
                for (int i = 0; i < arr.length(); ++i) {
                    list.add(arr.getString(i));
                }
                EventValues ev = Contract.this.extractEventParameters(event, list, args.getString("ContractEventInfo"));
                cb.called(ev);
            }
        });
    }

    protected String getStaticDeployedAddress(String networkId) {
        return null;
    }

    public final void setDeployedAddress(String networkId, String address) {
        if (this.deployedAddresses == null) {
            this.deployedAddresses = new HashMap<String, String>();
        }
        this.deployedAddresses.put(networkId, address);
    }

    public final String getDeployedAddress(String networkId) {
        String addr = null;
        if (this.deployedAddresses != null) {
            addr = this.deployedAddresses.get(networkId);
        }
        return addr == null ? this.getStaticDeployedAddress(networkId) : addr;
    }

    protected static <S extends Type, T> List<T> convertToNative(List<S> arr) {
        ArrayList<Object> out = new ArrayList<Object>();
        Iterator<S> it = arr.iterator();
        while (it.hasNext()) {
            out.add(((Type)it.next()).getValue());
        }
        return out;
    }

    public static class EventValuesWithLog {
        private final EventValues eventValues;

        private EventValuesWithLog(EventValues eventValues) {
            this.eventValues = eventValues;
        }

        public List<Type> getIndexedValues() {
            return this.eventValues.getIndexedValues();
        }

        public List<Type> getNonIndexedValues() {
            return this.eventValues.getNonIndexedValues();
        }
    }

    public static enum ContractOpType {
        ContractCreation(1),
        MessageSend(2);

        private int nType;

        private ContractOpType(int type) {
            this.nType = type;
        }

        public int value() {
            return this.nType;
        }
    }
}

