/*
 * Decompiled with CFR 0.152.
 */
package com.peersafe.chainsql.core;

import com.peersafe.base.client.Client;
import com.peersafe.base.core.coretypes.AccountID;
import com.peersafe.base.core.coretypes.Amount;
import com.peersafe.base.core.coretypes.Currency;
import com.peersafe.base.core.coretypes.RippleDate;
import com.peersafe.base.core.serialized.enums.TransactionType;
import com.peersafe.base.core.types.known.tx.Transaction;
import com.peersafe.chainsql.core.Chainsql;
import com.peersafe.chainsql.core.Submit;
import com.peersafe.chainsql.util.Util;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.logging.Level;
import org.json.JSONObject;

public class Ripple
extends Submit {
    private static final Double PRECISION = 1.0E-7;
    private JSONObject mTxJson;

    public Ripple(Chainsql chainsql) {
        this.connection = chainsql.connection;
        this.eventManager = chainsql.eventManager;
    }

    public void setTxJson(JSONObject obj) {
        this.mTxJson = obj;
    }

    @Override
    protected JSONObject prepareSigned() {
        try {
            if (this.mTxJson.toString().equals("{}")) {
                return Util.errorObject("Exception occured");
            }
            this.mTxJson.put("Account", (Object)this.connection.address);
            String sType = this.mTxJson.get("TransactionType").toString();
            if (sType.isEmpty()) {
                return Util.errorObject("Exception occured, no exist TransactionType");
            }
            TransactionType type = TransactionType.translate.fromString(sType);
            Transaction payment = this.toTransaction(this.mTxJson, type);
            this.signed = payment.sign(this.connection.secret);
            return Util.successObject();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Util.errorObject(e.getMessage());
        }
    }

    private Ripple pay(String accountId, Amount amount) {
        this.mTxJson = new JSONObject();
        this.mTxJson.put("Account", (Object)this.connection.address);
        if (amount.currency() != Currency.ZXC) {
            JSONObject result = this.connection.client.accountInfo(amount.issuer());
            if (!result.has("error")) {
                BigDecimal value = amount.value();
                JSONObject accountData = result.optJSONObject("account_data");
                if (accountData != null) {
                    String feeMin = null;
                    String feeMax = null;
                    long lFeeRate = 0L;
                    if (accountData.has("TransferFeeMin")) {
                        feeMin = accountData.getString("TransferFeeMin");
                    }
                    if (accountData.has("TransferFeeMax")) {
                        feeMax = accountData.getString("TransferFeeMax");
                    }
                    if (accountData.has("TransferRate")) {
                        lFeeRate = accountData.getLong("TransferRate");
                    }
                    if (null != feeMin || null != feeMax || lFeeRate != 0L) {
                        if (feeMin.equals(feeMax) && !feeMin.isEmpty()) {
                            value = value.add(new BigDecimal(feeMin));
                        } else if (lFeeRate > 1000000000L && lFeeRate <= 2000000000L) {
                            BigDecimal baseComputeNum = new BigDecimal(1000000000);
                            BigDecimal rate = new BigDecimal(lFeeRate).subtract(baseComputeNum);
                            rate = rate.divide(baseComputeNum);
                            BigDecimal fee = value.multiply(rate);
                            if (null != feeMin && !feeMin.isEmpty() && new BigDecimal(feeMin).compareTo(fee) > 0) {
                                fee = new BigDecimal(feeMin);
                            }
                            if (null != feeMax && !feeMax.isEmpty() && fee.compareTo(new BigDecimal(feeMax)) > 0) {
                                fee = new BigDecimal(feeMax);
                            }
                            value = value.add(fee);
                        } else {
                            try {
                                throw new Exception("Exception:transfer fee not valid!");
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
                Amount maxAmount = new Amount(value, amount.currency(), amount.issuer());
                this.mTxJson.put("SendMax", maxAmount.toJSON());
            } else {
                System.err.println(result.get("error_message"));
            }
        }
        this.mTxJson.put("Destination", (Object)accountId);
        this.mTxJson.put("Amount", amount.toJSON());
        this.mTxJson.put("TransactionType", (Object)"Payment");
        return this;
    }

    public Ripple pay(String accountId, String value) {
        BigDecimal bigCount = new BigDecimal(value);
        Amount amount = new Amount(bigCount);
        return this.pay(accountId, amount);
    }

    public Ripple pay(String accountId, String value, String sCurrency, String sIssuer) {
        BigDecimal bigCount = new BigDecimal(value);
        Amount amount = new Amount(bigCount, Currency.fromString(sCurrency), AccountID.fromAddress(sIssuer));
        return this.pay(accountId, amount);
    }

    public Ripple payToContract(String contract_address, String value, int gasLimit) {
        this.mTxJson = new JSONObject();
        this.mTxJson.put("Account", (Object)this.connection.address);
        this.mTxJson.put("ContractAddress", (Object)contract_address);
        this.mTxJson.put("ContractOpType", 2);
        this.mTxJson.put("Gas", gasLimit);
        BigInteger bigCount = new BigInteger(value);
        BigInteger amount = bigCount.multiply(BigInteger.valueOf(1000000L));
        this.mTxJson.put("ContractValue", (Object)amount.toString());
        this.mTxJson.put("ContractData", (Object)"");
        this.mTxJson.put("TransactionType", (Object)"Contract");
        return this;
    }

    private Ripple escrowCreate(String sDestAddr, Amount amount, String dateFormatTMFinish, String dateFormatTMCancel) throws Exception {
        long diffFinish = 0L;
        if (!dateFormatTMFinish.equals("")) {
            diffFinish = RippleDate.secondsSinceRippleEpoch(dateFormatTMFinish);
        }
        long diffCancel = 0L;
        if (!dateFormatTMCancel.equals("")) {
            diffCancel = RippleDate.secondsSinceRippleEpoch(dateFormatTMCancel);
        }
        if (diffFinish != 0L && diffCancel != 0L && diffFinish >= diffCancel) {
            throw new Exception("\"CancelAfter\" must be after \"FinishAfter\" for EscrowCreate!");
        }
        if (diffFinish == 0L && diffCancel == 0L) {
            throw new Exception("Either \"CancelAfter\" or \"FinishAfter\" should be valid for EscrowCreate!");
        }
        this.mTxJson = new JSONObject();
        this.mTxJson.put("Account", (Object)this.connection.address);
        this.mTxJson.put("Destination", (Object)sDestAddr);
        this.mTxJson.put("Amount", amount.toJSON());
        if (diffFinish != 0L) {
            this.mTxJson.put("FinishAfter", diffFinish);
        }
        if (diffCancel != 0L) {
            this.mTxJson.put("CancelAfter", diffCancel);
        }
        this.mTxJson.put("TransactionType", (Object)"EscrowCreate");
        return this;
    }

    public Ripple escrowCreate(String sDestAddr, String value, String dateFormatTMFinish, String dateFormatTMCancel) throws Exception {
        BigDecimal bigValue = new BigDecimal(value);
        Amount amount = new Amount(bigValue);
        return this.escrowCreate(sDestAddr, amount, dateFormatTMFinish, dateFormatTMCancel);
    }

    public Ripple escrowCreate(String sDestAddr, String value, String sCurrency, String sIssuer, String dateFormatTMFinish, String dateFormatTMCancel) throws Exception {
        BigDecimal bigCount = new BigDecimal(value);
        Amount amount = new Amount(bigCount, Currency.fromString(sCurrency), AccountID.fromAddress(sIssuer));
        return this.escrowCreate(sDestAddr, amount, dateFormatTMFinish, dateFormatTMCancel);
    }

    public Ripple escrowExecute(String sOwner, int nCreateEscrowSeq) {
        this.mTxJson = new JSONObject();
        this.mTxJson.put("Owner", (Object)sOwner);
        this.mTxJson.put("OfferSequence", nCreateEscrowSeq);
        this.mTxJson.put("TransactionType", (Object)"EscrowFinish");
        return this;
    }

    public Ripple escrowCancel(String sOwner, int nCreateEscrowSeq) {
        this.mTxJson = new JSONObject();
        this.mTxJson.put("Owner", (Object)sOwner);
        this.mTxJson.put("OfferSequence", nCreateEscrowSeq);
        this.mTxJson.put("TransactionType", (Object)"EscrowCancel");
        return this;
    }

    public Ripple accountSet(int nFlag, boolean bSet) {
        this.mTxJson = new JSONObject();
        this.mTxJson.put("Account", (Object)this.connection.address);
        if (bSet) {
            this.mTxJson.put("SetFlag", nFlag);
        } else {
            this.mTxJson.put("ClearFlag", nFlag);
        }
        this.mTxJson.put("TransactionType", (Object)"AccountSet");
        return this;
    }

    public Ripple accountSet(String transferRate, String transferFeeMin, String transferFeeMax) {
        double rate = 1.0;
        try {
            rate = Double.parseDouble(transferRate);
            if (rate != 0.0 && rate < 1.0 || rate > 2.0) {
                Client.logger.log(Level.WARNING, "TransferRate must be 0 or a number >= 1.0 && <= 2.0");
                return null;
            }
            double feeMin = Double.parseDouble(transferFeeMin);
            double feeMax = Double.parseDouble(transferFeeMax);
            if (feeMin < 0.0 || feeMax < 0.0) {
                Client.logger.log(Level.WARNING, "min or max cannot be less than 0");
                return null;
            }
            if (feeMin > feeMax) {
                Client.logger.log(Level.WARNING, "min cannot be greater than max");
                return null;
            }
            if (feeMin == feeMax && feeMin > 0.0 && rate > PRECISION && rate - 1.0 > PRECISION) {
                Client.logger.log(Level.WARNING, "fee mismatch transferRate");
                return null;
            }
            if (feeMin < feeMax && (rate < PRECISION || rate - 1.0 < PRECISION)) {
                Client.logger.log(Level.WARNING, "fee mismatch transferRate");
                return null;
            }
        }
        catch (Exception e) {
            Client.logger.log(Level.WARNING, e + "\nTransferRate must be a number >= 1.0 && <= 2.0; TransferFeeMin and TransferFeeMax must be decimal number string.");
            return null;
        }
        transferRate = transferRate.replace(".", "");
        for (int nLen = 10 - transferRate.length(); nLen > 0; --nLen) {
            transferRate = transferRate.concat("0");
        }
        transferFeeMin = Util.toHexString(transferFeeMin);
        transferFeeMax = Util.toHexString(transferFeeMax);
        this.mTxJson = new JSONObject();
        this.mTxJson.put("Account", (Object)this.connection.address);
        this.mTxJson.put("TransferRate", (Object)transferRate);
        this.mTxJson.put("TransferFeeMin", (Object)transferFeeMin);
        this.mTxJson.put("TransferFeeMax", (Object)transferFeeMax);
        this.mTxJson.put("TransactionType", (Object)"AccountSet");
        return this;
    }

    public Ripple trustSet(String value, String sCurrency, String sIssuer) {
        BigDecimal bigCount = new BigDecimal(value);
        Amount amount = new Amount(bigCount, Currency.fromString(sCurrency), AccountID.fromAddress(sIssuer));
        this.mTxJson = new JSONObject();
        this.mTxJson.put("LimitAmount", amount.toJSON());
        this.mTxJson.put("Account", (Object)this.connection.address);
        this.mTxJson.put("TransactionType", (Object)"TrustSet");
        return this;
    }
}

