/*
 * Decompiled with CFR 0.152.
 */
package com.peersafe.chainsql.core;

import com.peersafe.base.client.Account;
import com.peersafe.base.client.pubsub.Publisher;
import com.peersafe.base.client.responses.Response;
import com.peersafe.base.client.transactions.ManagedTxn;
import com.peersafe.base.client.transactions.TransactionManager;
import com.peersafe.base.core.coretypes.AccountID;
import com.peersafe.base.core.coretypes.Amount;
import com.peersafe.base.core.coretypes.uint.UInt32;
import com.peersafe.base.core.serialized.enums.TransactionType;
import com.peersafe.base.core.types.known.tx.Transaction;
import com.peersafe.base.core.types.known.tx.signed.SignedTransaction;
import com.peersafe.chainsql.manager.EventManager;
import com.peersafe.chainsql.net.Connection;
import com.peersafe.chainsql.util.GenericPair;
import com.peersafe.chainsql.util.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class Submit {
    public Connection connection;
    protected Publisher.Callback<JSONObject> cb;
    private SubmitState submit_state;
    private SyncState sync_state;
    private JSONObject submitRes;
    private JSONObject syncRes;
    private boolean sync = false;
    protected SyncCond condition;
    protected SignedTransaction signed;
    protected CrossChainArgs crossChainArgs = null;
    protected EventManager eventManager = new EventManager();
    protected List<JSONObject> cache = new ArrayList<JSONObject>();
    protected Map<GenericPair<String, String>, String> mapToken = new HashMap<GenericPair<String, String>, String>();
    protected boolean transaction = false;
    protected Integer needVerify = 1;
    protected boolean strictMode = false;
    private static final int wait_milli = 50;
    private static final int submit_wait = 10000;
    private static final int sync_maxtime = 30000;

    public void setRestrict(boolean falg) {
        this.strictMode = falg;
    }

    public void setNeedVerify(boolean flag) {
        this.needVerify = flag ? 1 : 0;
    }

    public JSONObject submit(Publisher.Callback<JSONObject> cb) {
        this.cb = cb;
        return this.doSubmit();
    }

    public JSONObject submit(SyncCond cond) {
        this.sync = true;
        this.condition = cond;
        return this.doSubmit();
    }

    public JSONObject submit() {
        this.sync = false;
        this.cb = null;
        return this.doSubmit();
    }

    public void setCrossChainArgs(String originalAddress, int txnLedgerSeq, String curTxHash, String futureHash) {
        this.crossChainArgs = new CrossChainArgs();
        this.crossChainArgs.originalAddress = originalAddress;
        this.crossChainArgs.txnLedgerSeq = txnLedgerSeq;
        this.crossChainArgs.curTxHash = curTxHash;
        this.crossChainArgs.futureHash = futureHash;
    }

    public void setCrossChainArgs(CrossChainArgs args) {
        this.crossChainArgs = args;
    }

    public boolean isCrossChainArgsSet() {
        return this.crossChainArgs != null;
    }

    protected abstract JSONObject prepareSigned();

    private JSONObject getError(String err) {
        JSONObject obj = new JSONObject();
        obj.put("status", (Object)"error");
        obj.put("error_message", (Object)err);
        return obj;
    }

    public EventManager eventManager() {
        return this.eventManager;
    }

    protected JSONObject doSubmit() {
        JSONObject obj = this.prepareSigned();
        if (obj.has("final_result") || obj.has("error")) {
            return obj;
        }
        return this.doSubmitNoPrepare();
    }

    protected JSONObject doSubmitNoPrepare() {
        if (this.signed == null) {
            return this.getError("Signing failed,maybe ripple node error");
        }
        this.submit_state = SubmitState.waiting_submit;
        this.sync_state = SyncState.waiting_sync;
        Account account = this.connection.client.accountFromSeed(this.connection.secret);
        TransactionManager tm = account.transactionManager();
        ManagedTxn tx = new ManagedTxn(this.signed);
        if (this.sync || this.cb != null) {
            if (tx == null || tx.hash == null) {
                return this.getError("Submit failed,transaction hash is null.");
            }
            this.subscribeTx(tx.hash.toString());
        }
        tm.submitSigned(tx.onSubmitSuccess(new ManagedTxn.OnSubmitSuccess(){

            @Override
            public void called(Response args) {
                Submit.this.onSubmitSuccess(args);
            }
        }).onError(new Publisher.Callback<Response>(){

            @Override
            public void called(Response args) {
                Submit.this.onSubmitError(args);
            }
        }));
        int count = 200;
        while (this.submit_state == SubmitState.waiting_submit) {
            Util.waiting();
            if (--count > 0) continue;
            this.submit_state = SubmitState.submit_error;
            this.submitRes = this.getError("waiting submit result timeout");
            break;
        }
        if (this.sync) {
            if (this.submit_state == SubmitState.submit_error || this.submit_state == SubmitState.send_success && this.condition == SyncCond.send_success) {
                return this.submitRes;
            }
            count = 600;
            while (this.sync_state != SyncState.sync_response) {
                Util.waiting();
                if (--count > 0) continue;
                this.syncRes = this.getError("waiting sync result timeout");
                break;
            }
            return this.syncRes;
        }
        return this.submitRes;
    }

    private void subscribeTx(final String txId) {
        this.eventManager.subscribeTx(txId, new Publisher.Callback<JSONObject>(){

            @Override
            public void called(JSONObject data) {
                if (Submit.this.cb != null) {
                    if (!data.getString("status").equals("success")) {
                        Submit.this.cb.called(data);
                    }
                } else if (Submit.this.sync) {
                    if (!data.has("transaction")) {
                        return;
                    }
                    JSONObject obj = data;
                    JSONObject res = new JSONObject();
                    JSONObject tx = (JSONObject)obj.get("transaction");
                    String hash = tx.get("hash").toString();
                    if (!hash.equals(txId)) {
                        return;
                    }
                    res.put("tx_hash", (Object)hash);
                    boolean bUnsubcribe = true;
                    if (Submit.this.condition == SyncCond.validate_success && obj.get("status").equals("validate_success")) {
                        res.put("status", (Object)"validate_success");
                    } else if (Submit.this.condition == SyncCond.db_success && obj.get("status").equals("db_success")) {
                        res.put("status", (Object)"db_success");
                    } else if (!obj.get("status").equals("validate_success") && !obj.get("status").equals("db_success")) {
                        res.put("status", obj.get("status"));
                        if (obj.has("error_message")) {
                            res.put("error_message", obj.get("error_message"));
                        }
                    } else {
                        bUnsubcribe = false;
                    }
                    if (bUnsubcribe) {
                        Submit.this.unSubscribeTx(hash);
                    }
                    if (!res.isNull("status") && Submit.this.sync_state == SyncState.waiting_sync) {
                        Submit.this.syncRes = res;
                        Submit.this.sync_state = SyncState.sync_response;
                        Submit.this.submit_state = SubmitState.send_success;
                    }
                }
            }
        });
    }

    private void unSubscribeTx(String txId) {
        this.eventManager.unsubscribeTx(txId, null);
    }

    private void onSubmitSuccess(Response res) {
        JSONObject obj = new JSONObject();
        obj.put("status", (Object)"send_success");
        JSONObject tx_json = (JSONObject)res.result.get("tx_json");
        obj.put("tx_hash", (Object)tx_json.get("hash").toString());
        this.submitRes = obj;
        this.submit_state = SubmitState.send_success;
    }

    private void onSubmitError(Response res) {
        JSONObject obj = new JSONObject();
        obj.put("status", (Object)"error");
        if (res.result.has("engine_result_message")) {
            obj.put("error_message", (Object)res.result.getString("engine_result_message"));
        }
        if (res.result.has("engine_result_message_detail")) {
            obj.put("error_message", (Object)res.result.getString("engine_result_message_detail"));
        }
        if (res.result.has("engine_result")) {
            obj.put("error", (Object)res.result.getString("engine_result"));
        }
        if (res.result.has("engine_result_code")) {
            obj.put("error_code", res.result.getInt("engine_result_code"));
        }
        if (res.result.has("tx_json")) {
            obj.put("tx_json", (Object)res.result.getJSONObject("tx_json"));
        }
        if (this.sync || this.cb != null) {
            this.unSubscribeTx(this.signed.hash.toString());
            if (this.cb != null) {
                this.cb.called(obj);
            }
        }
        this.submitRes = obj;
        this.submit_state = SubmitState.submit_error;
    }

    protected JSONArray getTableArray(String tableName) {
        String tablestr = "{\"Table\":{\"TableName\":\"" + Util.toHexString(tableName) + "\"}}";
        return Util.strToJSONArray(tablestr);
    }

    protected boolean mapError(Map<String, Object> map) {
        return map.get("Sequence") == null;
    }

    protected Transaction toTransaction(JSONObject json, TransactionType type) throws Exception {
        Amount fee;
        Transaction tx = new Transaction(type);
        if (this.connection.client.serverInfo.primed()) {
            fee = this.connection.client.serverInfo.transactionFee(tx);
            if (!json.has(UInt32.LastLedgerSequence.toString())) {
                tx.put(UInt32.LastLedgerSequence, new UInt32(this.connection.client.serverInfo.ledger_index + 5L));
            }
        } else {
            fee = Amount.fromString("50");
            JSONObject ledger = this.connection.client.getLedgerVersion();
            if (ledger.has("ledger_current_index")) {
                tx.put(UInt32.LastLedgerSequence, new UInt32(ledger.getInt("ledger_current_index") + 5));
            }
        }
        Amount extraFee = Util.getExtraFee(json, type);
        fee = fee.add(extraFee);
        tx.as(Amount.Fee, fee);
        AccountID account = AccountID.fromAddress(this.connection.address);
        JSONObject obj = this.connection.client.accountInfo(account);
        if (obj.has("error")) {
            throw new Exception(obj.getString("error_message"));
        }
        tx.as(UInt32.Sequence, obj.getJSONObject("account_data").getInt("Sequence"));
        try {
            tx.parseFromJson(json);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return tx;
    }

    public class CrossChainArgs {
        public String originalAddress;
        public int txnLedgerSeq;
        public String curTxHash;
        public String futureHash;
    }

    public static enum SyncState {
        waiting_sync,
        sync_response;

    }

    public static enum SubmitState {
        waiting_submit,
        send_success,
        submit_error;

    }

    public static enum SyncCond {
        send_success,
        validate_success,
        db_success;

    }
}

