/*
 * Decompiled with CFR 0.152.
 */
package com.peersafe.chainsql.crypto;

import com.peersafe.chainsql.util.Util;
import java.security.Provider;
import java.security.Security;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class Aes256 {
    public static boolean initialized = false;
    public static final int AESKeyLength = 32;
    public static final int IVLength = 16;

    public static byte[] crypt(byte[] bytes, byte[] key, boolean bEncrypt) {
        if (bytes.length == 0 || key.length == 0) {
            return null;
        }
        Aes256.initialize();
        try {
            key = Util.paddingPass(key, 32);
            byte[] iv = new byte[16];
            System.arraycopy(key, 0, iv, 0, 16);
            ParametersWithIV keyWithIv = new ParametersWithIV((CipherParameters)new KeyParameter(key), iv);
            PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher((BlockCipher)new CBCBlockCipher((BlockCipher)new AESEngine()));
            cipher.init(bEncrypt, (CipherParameters)keyWithIv);
            byte[] cryptedBytes = new byte[cipher.getOutputSize(bytes.length)];
            int length1 = cipher.processBytes(bytes, 0, bytes.length, cryptedBytes, 0);
            int length2 = cipher.doFinal(cryptedBytes, length1);
            byte[] finalBytes = cryptedBytes;
            int finalLength = length1 + length2;
            if (!bEncrypt && finalLength != cryptedBytes.length) {
                finalBytes = new byte[finalLength];
                System.arraycopy(cryptedBytes, 0, finalBytes, 0, finalLength);
            }
            return finalBytes;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] encrypt(byte[] plainBytes, byte[] key) {
        return Aes256.crypt(plainBytes, key, true);
    }

    public static byte[] decrypt(byte[] cipherBytes, byte[] key) {
        return Aes256.crypt(cipherBytes, key, false);
    }

    public static void initialize() {
        if (initialized) {
            return;
        }
        Security.addProvider((Provider)new BouncyCastleProvider());
        initialized = true;
    }

    public static void main(String[] args) {
        String plainText = "hello,world";
        String key = "abcdefg";
        byte[] cipher = Aes256.encrypt(plainText.getBytes(), key.getBytes());
        System.out.println(Util.bytesToHex(cipher));
        byte[] decrypted = Aes256.decrypt(cipher, key.getBytes());
        System.out.println(new String(decrypted));
    }
}

