/*
 * Decompiled with CFR 0.152.
 */
package com.peersafe.chainsql.crypto;

import com.peersafe.base.config.Config;
import com.peersafe.chainsql.crypto.Aes256;
import com.peersafe.chainsql.crypto.Ecies;
import com.peersafe.chainsql.util.Util;

public class EncryptCommon {
    public static byte[] asymEncrypt(byte[] plainBytes, byte[] publicKey) {
        if (Config.isUseGM()) {
            return null;
        }
        return Ecies.eciesEncrypt(plainBytes, publicKey);
    }

    public static byte[] asymDecrypt(byte[] cipher, byte[] privateKey) {
        if (Config.isUseGM()) {
            return null;
        }
        try {
            return Ecies.eciesDecrypt(cipher, privateKey);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] symEncrypt(byte[] plainBytes, byte[] password) {
        if (Config.isUseGM()) {
            return null;
        }
        return Aes256.encrypt(plainBytes, password);
    }

    public static byte[] symDecrypt(byte[] cipherText, byte[] password) {
        if (Config.isUseGM()) {
            return null;
        }
        return Aes256.decrypt(cipherText, password);
    }

    public static String symEncrypt(String plainBytes, String password) {
        if (Config.isUseGM()) {
            return null;
        }
        return Util.bytesToHex(Aes256.encrypt(plainBytes.getBytes(), password.getBytes()));
    }

    public static String symDecrypt(String cipherText, String password) {
        if (Config.isUseGM()) {
            return null;
        }
        return new String(Aes256.decrypt(Util.hexToBytes(cipherText), password.getBytes()));
    }
}

