/*
 * Decompiled with CFR 0.152.
 */
package com.peersafe.chainsql.manager;

import com.peersafe.abi.EventEncoder;
import com.peersafe.abi.datatypes.Event;
import com.peersafe.base.client.Client;
import com.peersafe.base.client.pubsub.Publisher;
import com.peersafe.base.config.Config;
import com.peersafe.base.core.serialized.enums.TransactionType;
import com.peersafe.chainsql.crypto.EncryptCommon;
import com.peersafe.chainsql.net.Connection;
import com.peersafe.chainsql.util.Util;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class EventManager {
    public Connection connection;
    public boolean onTbMessage;
    public boolean onTxMessage;
    public boolean onContractMessage;
    public boolean onSubRet;
    private HashMap<String, Publisher.Callback> mapCache;
    private HashMap<String, byte[]> mapPass;
    private HashMap<String, Map<Event, Publisher.Callback>> mapContractEvents;
    public JSONObject result;

    public void init(Connection connection) {
        this.connection = connection;
        this.mapCache = new HashMap();
        this.mapPass = new HashMap();
        this.mapContractEvents = new HashMap();
        this.onTbMessage = false;
        this.onTxMessage = false;
        this.onSubRet = false;
        this.onContractMessage = false;
    }

    public void reSubscribe() {
        int ownerLen = this.connection.address.length();
        for (String key : this.mapCache.keySet()) {
            String name = key.substring(0, key.length() - ownerLen);
            String owner = key.substring(key.length() - ownerLen);
            JSONObject messageTx = new JSONObject();
            messageTx.put("command", (Object)"subscribe");
            messageTx.put("owner", (Object)owner);
            messageTx.put("tablename", (Object)name);
            this.connection.client.subscriptions.addMessage(messageTx);
        }
        for (String address : this.mapContractEvents.keySet()) {
            JSONObject contractEv = new JSONObject();
            contractEv.put("command", (Object)"subscribe");
            JSONArray arrAdd = new JSONArray();
            arrAdd.put((Object)address);
            contractEv.put("accounts_contract", (Object)arrAdd);
            this.connection.client.subscriptions.addMessage(contractEv);
        }
    }

    private void onChainsqlSubRet() {
        this.connection.client.OnSubChainsqlRet(new Client.OnChainsqlSubRet(){

            @Override
            public void called(JSONObject args) {
                String key;
                if (args.has("owner") && args.has("tablename")) {
                    key = args.getString("tablename") + args.getString("owner");
                    EventManager.this.makeCallback(key, args.getJSONObject("result"));
                }
                if (args.has("transaction")) {
                    key = args.getString("transaction");
                    EventManager.this.makeCallback(key, args.getJSONObject("result"));
                }
            }
        });
    }

    public void subscribeTable(String name, String owner, Publisher.Callback<?> cb) {
        JSONObject messageTx = new JSONObject();
        messageTx.put("command", (Object)"subscribe");
        messageTx.put("owner", (Object)owner);
        messageTx.put("tablename", (Object)name);
        this.connection.client.subscriptions.addMessage(messageTx);
        if (!this.onTbMessage) {
            this.connection.client.OnTBMessage(new Client.OnTBMessage(){

                @Override
                public void called(JSONObject args) {
                    EventManager.this.onTBMessage(args);
                }
            });
            this.onTbMessage = true;
        }
        if (!this.onSubRet) {
            this.onChainsqlSubRet();
            this.onSubRet = true;
        }
        this.mapCache.put(name + owner, cb);
    }

    public void subscribeTx(String id, Publisher.Callback<?> cb) {
        JSONObject messageTx = new JSONObject();
        messageTx.put("command", (Object)"subscribe");
        messageTx.put("transaction", (Object)id);
        this.connection.client.subscriptions.addMessage(messageTx);
        if (!this.onTxMessage) {
            this.connection.client.OnTXMessage(new Client.OnTXMessage(){

                @Override
                public void called(JSONObject args) {
                    EventManager.this.onTXMessage(args);
                }
            });
            this.onTxMessage = true;
        }
        if (!this.onSubRet) {
            this.onChainsqlSubRet();
            this.onSubRet = true;
        }
        this.mapCache.put(id, cb);
    }

    public void subscribeContract(final String address, Event event, Publisher.Callback cb) {
        if (this.mapContractEvents.containsKey(address)) {
            this.mapContractEvents.get(address).put(event, cb);
        } else {
            HashMap<Event, Publisher.Callback> map = new HashMap<Event, Publisher.Callback>();
            map.put(event, cb);
            this.mapContractEvents.put(address, map);
            JSONObject messageEv = new JSONObject();
            messageEv.put("command", (Object)"subscribe");
            JSONArray arr = new JSONArray();
            arr.put((Object)address);
            messageEv.put("accounts_contract", (Object)arr);
            this.connection.client.subscriptions.addMessage(messageEv);
            if (!this.onContractMessage) {
                this.connection.client.onContractEvent(new Client.OnContractEvent(){

                    @Override
                    public void called(JSONObject args) {
                        if (!args.has("ContractEventTopics")) {
                            System.err.println("no ContractEventTopics found,not a valid event callback!");
                            return;
                        }
                        Map mapCb = (Map)EventManager.this.mapContractEvents.get(address);
                        for (Map.Entry entry : mapCb.entrySet()) {
                            String encodedEventSignature = EventEncoder.encode((Event)((Event)entry.getKey()));
                            if (!(encodedEventSignature = encodedEventSignature.substring(2, encodedEventSignature.length())).toUpperCase().equals(args.getJSONArray("ContractEventTopics").get(0))) continue;
                            ((Publisher.Callback)entry.getValue()).called(args);
                            break;
                        }
                    }
                });
                this.onContractMessage = true;
            }
        }
    }

    public void unsubscribeContract(String address, Event event) {
    }

    public void unsubscribeTable(String name, String owner, Publisher.Callback<JSONObject> cb) {
        JSONObject messageTx = new JSONObject();
        messageTx.put("command", (Object)"unsubscribe");
        messageTx.put("owner", (Object)owner);
        messageTx.put("tablename", (Object)name);
        this.connection.client.subscriptions.addMessage(messageTx);
        String key = name + owner;
        JSONObject obj = new JSONObject();
        if (this.mapCache.containsKey(key)) {
            obj.put("status", (Object)"success");
            obj.put("result", (Object)"unsubscribe table success");
            obj.put("type", (Object)"response");
            this.mapCache.remove(key);
            this.mapPass.remove(key);
        } else {
            obj.put("status", (Object)"error");
            obj.put("result", (Object)("have not subscribe the table:" + name));
            obj.put("type", (Object)"response");
        }
        cb.called(obj);
    }

    public void unsubscribeTx(String id, Publisher.Callback<JSONObject> cb) {
        JSONObject messageTx = new JSONObject();
        messageTx.put("command", (Object)"unsubscribe");
        messageTx.put("transaction", (Object)id);
        this.connection.client.subscriptions.addMessage(messageTx);
        JSONObject obj = new JSONObject();
        if (this.mapCache.containsKey(id)) {
            obj.put("status", (Object)"success");
            obj.put("result", (Object)"unsubscribe transaction success");
            obj.put("type", (Object)"response");
            this.mapCache.remove(id);
        } else {
            obj.put("status", (Object)"error");
            obj.put("result", (Object)("have not subscribe the tx:" + id));
            obj.put("type", (Object)"response");
        }
        if (cb != null) {
            cb.called(obj);
        }
    }

    private void onChainsqlMessage(final JSONObject data, final String key, String owner, String name) {
        final JSONObject tx = data.getJSONObject("transaction");
        if (this.mapPass.containsKey(key)) {
            Util.decryptData(this.mapPass.get(key), tx);
            this.makeCallback(key, data);
        } else {
            this.connection.client.getUserToken(owner, this.connection.address, name, new Publisher.Callback<JSONObject>(){

                @Override
                public void called(JSONObject res) {
                    if (res.has("error")) {
                        System.err.println(res);
                        EventManager.this.mapPass.put(key, null);
                        Util.decryptData((byte[])EventManager.this.mapPass.get(key), tx);
                        EventManager.this.makeCallback(key, data);
                    } else {
                        String token = res.getString("token");
                        if (token.length() != 0) {
                            try {
                                byte[] seedBytes = null;
                                if (!EventManager.this.connection.secret.isEmpty()) {
                                    seedBytes = Config.getB58IdentiferCodecs().decodeFamilySeed(EventManager.this.connection.secret);
                                }
                                byte[] password = EncryptCommon.asymDecrypt(Util.hexToBytes(token), seedBytes);
                                EventManager.this.mapPass.put(key, password);
                                Util.decryptData((byte[])EventManager.this.mapPass.get(key), tx);
                                EventManager.this.makeCallback(key, data);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        } else {
                            EventManager.this.mapPass.put(key, null);
                            Util.decryptData((byte[])EventManager.this.mapPass.get(key), tx);
                            EventManager.this.makeCallback(key, data);
                        }
                    }
                }
            });
        }
    }

    private void onTBMessage(JSONObject data) {
        String owner = data.getString("owner");
        String name = data.getString("tablename");
        String key = name + owner;
        this.onChainsqlMessage(data, key, owner, name);
    }

    private void onTXMessage(JSONObject data) {
        String key = ((JSONObject)data.get("transaction")).getString("hash");
        this.makeCallback(key, data);
        if (data.has("transaction") && data.getJSONObject("transaction").has("TransactionType")) {
            JSONObject tx = data.getJSONObject("transaction");
            TransactionType type = TransactionType.valueOf(tx.getString("TransactionType"));
            if (Util.isChainsqlType(type)) {
                if (!"validate_success".equals(data.getString("status"))) {
                    this.mapCache.remove(key);
                }
            } else {
                this.mapCache.remove(key);
            }
        }
    }

    private void makeCallback(String key, JSONObject data) {
        if (this.mapCache.containsKey(key)) {
            this.mapCache.get(key).called(data);
        }
    }
}

