/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.impl;

import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import net.i2p.I2PAppContext;
import net.i2p.client.I2PSessionException;
import net.i2p.client.SendMessageOptions;
import net.i2p.client.impl.I2PSessionImpl;
import net.i2p.data.DataFormatException;
import net.i2p.data.Destination;
import net.i2p.data.LeaseSet;
import net.i2p.data.Payload;
import net.i2p.data.PrivateKey;
import net.i2p.data.SessionKey;
import net.i2p.data.SessionTag;
import net.i2p.data.SigningPrivateKey;
import net.i2p.data.i2cp.AbuseReason;
import net.i2p.data.i2cp.AbuseSeverity;
import net.i2p.data.i2cp.CreateLeaseSetMessage;
import net.i2p.data.i2cp.CreateSessionMessage;
import net.i2p.data.i2cp.DestroySessionMessage;
import net.i2p.data.i2cp.MessageId;
import net.i2p.data.i2cp.ReconfigureSessionMessage;
import net.i2p.data.i2cp.ReportAbuseMessage;
import net.i2p.data.i2cp.SendMessageExpiresMessage;
import net.i2p.data.i2cp.SendMessageMessage;
import net.i2p.data.i2cp.SessionConfig;
import net.i2p.data.i2cp.SessionId;
import net.i2p.util.Log;

class I2CPMessageProducer {
    private final Log _log;
    private final I2PAppContext _context;
    private int _maxBytesPerSecond;
    private volatile int _sendPeriodBytes;
    private volatile long _sendPeriodBeginTime;
    private final ReentrantLock _lock;
    private static final String PROP_MAX_BW = "i2cp.outboundBytesPerSecond";
    private static final int TYP_SIZE = 1781;
    private static final int MIN_RATE = 3562;
    static final boolean END_TO_END_CRYPTO = false;

    public I2CPMessageProducer(I2PAppContext context) {
        this._context = context;
        this._log = context.logManager().getLog(I2CPMessageProducer.class);
        this._lock = new ReentrantLock(true);
        context.statManager().createRateStat("client.sendThrottled", "Times waited for bandwidth", "ClientMessages", new long[]{60000L});
        context.statManager().createRateStat("client.sendDropped", "Length of msg dropped waiting for bandwidth", "ClientMessages", new long[]{60000L});
    }

    public void updateBandwidth(I2PSessionImpl session) {
        String max = session.getOptions().getProperty(PROP_MAX_BW);
        if (max != null) {
            try {
                int iMax = Integer.parseInt(max);
                this._maxBytesPerSecond = iMax > 0 ? 256 + Math.max(3562, 1781 * ((iMax + 1781 - 1) / 1781)) : 0;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Setting " + this._maxBytesPerSecond + " BPS max");
        }
    }

    public void connect(I2PSessionImpl session) throws I2PSessionException {
        this.updateBandwidth(session);
        CreateSessionMessage msg = new CreateSessionMessage();
        SessionConfig cfg = new SessionConfig(session.getMyDestination());
        cfg.setOptions(session.getOptions());
        if (this._log.shouldLog(10)) {
            this._log.debug("config created");
        }
        try {
            cfg.signSessionConfig(session.getPrivateKey());
        }
        catch (DataFormatException dfe) {
            throw new I2PSessionException("Unable to sign the session config", dfe);
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("config signed");
        }
        msg.setSessionConfig(cfg);
        if (this._log.shouldLog(10)) {
            this._log.debug("config loaded into message");
        }
        session.sendMessage_unchecked(msg);
        if (this._log.shouldLog(10)) {
            this._log.debug("config message sent");
        }
    }

    public void disconnect(I2PSessionImpl session) throws I2PSessionException {
        if (session.isClosed()) {
            return;
        }
        DestroySessionMessage dmsg = new DestroySessionMessage();
        dmsg.setSessionId(session.getSessionId());
        session.sendMessage_unchecked(dmsg);
    }

    public void sendMessage(I2PSessionImpl session, Destination dest, long nonce, byte[] payload, SessionTag tag, SessionKey key, Set<SessionTag> tags, SessionKey newKey, long expires) throws I2PSessionException {
        this.sendMessage(session, dest, nonce, payload, expires, 0);
    }

    public void sendMessage(I2PSessionImpl session, Destination dest, long nonce, byte[] payload, long expires, int flags) throws I2PSessionException {
        SendMessageMessage msg;
        if (!this.updateBps(payload.length, expires)) {
            return;
        }
        if (expires > 0L || flags > 0) {
            SendMessageExpiresMessage smsg = new SendMessageExpiresMessage();
            smsg.setExpiration(expires);
            smsg.setFlags(flags);
            msg = smsg;
        } else {
            msg = new SendMessageMessage();
        }
        msg.setDestination(dest);
        SessionId sid = session.getSessionId();
        if (sid == null) {
            this._log.error(session.toString() + " send message w/o session", new Exception());
            return;
        }
        msg.setSessionId(sid);
        msg.setNonce(nonce);
        Payload data = this.createPayload(dest, payload, null, null, null, null);
        msg.setPayload(data);
        session.sendMessage(msg);
    }

    public void sendMessage(I2PSessionImpl session, Destination dest, long nonce, byte[] payload, SendMessageOptions options) throws I2PSessionException {
        long expires = options.getTime();
        if (!this.updateBps(payload.length, expires)) {
            return;
        }
        SendMessageExpiresMessage msg = new SendMessageExpiresMessage(options);
        msg.setDestination(dest);
        SessionId sid = session.getSessionId();
        if (sid == null) {
            this._log.error(session.toString() + " send message w/o session", new Exception());
            return;
        }
        msg.setSessionId(sid);
        msg.setNonce(nonce);
        Payload data = this.createPayload(dest, payload, null, null, null, null);
        msg.setPayload(data);
        session.sendMessage(msg);
    }

    private boolean updateBps(int len, long expires) {
        if (this._maxBytesPerSecond <= 0) {
            return true;
        }
        this._lock.lock();
        try {
            int waitCount = 0;
            while (true) {
                long now = this._context.clock().now();
                if (waitCount > 0 && expires > 0L && expires < now) {
                    this._context.statManager().addRateData("client.sendDropped", len, 0L);
                    if (this._log.shouldLog(30)) {
                        this._log.warn("Dropping " + len + " byte msg expired in queue");
                    }
                    boolean bl = false;
                    return bl;
                }
                long period = now - this._sendPeriodBeginTime;
                if (period >= 2000L) {
                    this._sendPeriodBytes = len;
                    this._sendPeriodBeginTime = now;
                    if (this._log.shouldLog(10)) {
                        this._log.debug("New period after idle, " + len + " bytes");
                    }
                    boolean bl = true;
                    return bl;
                }
                if (period >= 1000L) {
                    this._sendPeriodBytes = this._sendPeriodBytes > 0 && (this._sendPeriodBeginTime / 1000L & 1L) == 0L ? (this._sendPeriodBytes += len - this._maxBytesPerSecond) : len;
                    this._sendPeriodBeginTime += 1000L;
                    if (this._log.shouldLog(10)) {
                        this._log.debug("New period, " + len + " bytes");
                    }
                    boolean bl = true;
                    return bl;
                }
                if (this._sendPeriodBytes + len <= this._maxBytesPerSecond) {
                    this._sendPeriodBytes += len;
                    if (this._log.shouldLog(10)) {
                        this._log.debug("Sending " + len + ", Elapsed " + period + "ms, total " + this._sendPeriodBytes + " bytes");
                    }
                    boolean bl = true;
                    return bl;
                }
                if (waitCount >= 2) {
                    this._context.statManager().addRateData("client.sendDropped", len, 0L);
                    if (this._log.shouldLog(30)) {
                        this._log.warn("Dropping " + len + " byte msg after waiting " + waitCount + " times");
                    }
                    boolean bl = false;
                    return bl;
                }
                this._context.statManager().addRateData("client.sendThrottled", ++waitCount, 0L);
                if (this._log.shouldLog(10)) {
                    this._log.debug("Throttled " + len + " bytes, wait #" + waitCount + ' ' + (1000L - period) + "ms");
                }
                try {
                    this._lock.newCondition().await(1000L - period, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        finally {
            this._lock.unlock();
        }
    }

    private Payload createPayload(Destination dest, byte[] payload, SessionTag tag, SessionKey key, Set<SessionTag> tags, SessionKey newKey) throws I2PSessionException {
        if (dest == null) {
            throw new I2PSessionException("No destination specified");
        }
        if (payload == null) {
            throw new I2PSessionException("No payload specified");
        }
        Payload data = new Payload();
        data.setEncryptedData(payload);
        return data;
    }

    public void reportAbuse(I2PSessionImpl session, int msgId, int severity) throws I2PSessionException {
        ReportAbuseMessage msg = new ReportAbuseMessage();
        MessageId id = new MessageId();
        id.setMessageId(msgId);
        msg.setMessageId(id);
        AbuseReason reason = new AbuseReason();
        reason.setReason("Not specified");
        msg.setReason(reason);
        AbuseSeverity sv = new AbuseSeverity();
        sv.setSeverity(severity);
        msg.setSeverity(sv);
        session.sendMessage(msg);
    }

    public void createLeaseSet(I2PSessionImpl session, LeaseSet leaseSet, SigningPrivateKey signingPriv, PrivateKey priv) throws I2PSessionException {
        CreateLeaseSetMessage msg = new CreateLeaseSetMessage();
        msg.setLeaseSet(leaseSet);
        msg.setPrivateKey(priv);
        msg.setSigningPrivateKey(signingPriv);
        SessionId sid = session.getSessionId();
        if (sid == null) {
            this._log.error(session.toString() + " create LS w/o session", new Exception());
            return;
        }
        msg.setSessionId(sid);
        session.sendMessage_unchecked(msg);
    }

    public void updateTunnels(I2PSessionImpl session, int tunnels) throws I2PSessionException {
        ReconfigureSessionMessage msg = new ReconfigureSessionMessage();
        SessionConfig cfg = new SessionConfig(session.getMyDestination());
        Properties props = session.getOptions();
        if (tunnels > 0) {
            Properties newprops = new Properties();
            newprops.putAll((Map<?, ?>)props);
            props = newprops;
            props.setProperty("inbound.quantity", "" + tunnels);
            props.setProperty("outbound.quantity", "" + tunnels);
            props.setProperty("inbound.backupQuantity", "0");
            props.setProperty("outbound.backupQuantity", "0");
        }
        cfg.setOptions(props);
        try {
            cfg.signSessionConfig(session.getPrivateKey());
        }
        catch (DataFormatException dfe) {
            throw new I2PSessionException("Unable to sign the session config", dfe);
        }
        msg.setSessionConfig(cfg);
        SessionId sid = session.getSessionId();
        if (sid == null) {
            this._log.error(session.toString() + " update config w/o session", new Exception());
            return;
        }
        msg.setSessionId(sid);
        session.sendMessage(msg);
    }
}

