/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.impl;

import net.i2p.I2PAppContext;
import net.i2p.client.impl.BWLimitsMessageHandler;
import net.i2p.client.impl.DestReplyMessageHandler;
import net.i2p.client.impl.DisconnectMessageHandler;
import net.i2p.client.impl.HostReplyMessageHandler;
import net.i2p.client.impl.I2CPMessageHandler;
import net.i2p.client.impl.MessagePayloadMessageHandler;
import net.i2p.client.impl.MessageStatusMessageHandler;
import net.i2p.client.impl.RequestLeaseSetMessageHandler;
import net.i2p.client.impl.RequestVariableLeaseSetMessageHandler;
import net.i2p.client.impl.SessionStatusMessageHandler;
import net.i2p.client.impl.SetDateMessageHandler;

class I2PClientMessageHandlerMap {
    protected I2CPMessageHandler[] _handlers;

    public I2PClientMessageHandlerMap() {
    }

    public I2PClientMessageHandlerMap(I2PAppContext context) {
        int highest = 30;
        highest = Math.max(highest, 20);
        highest = Math.max(highest, 21);
        highest = Math.max(highest, 31);
        highest = Math.max(highest, 22);
        highest = Math.max(highest, 33);
        highest = Math.max(highest, 35);
        highest = Math.max(highest, 39);
        highest = Math.max(highest, 23);
        highest = Math.max(highest, 37);
        this._handlers = new I2CPMessageHandler[highest + 1];
        this._handlers[30] = new DisconnectMessageHandler(context);
        this._handlers[20] = new SessionStatusMessageHandler(context);
        this._handlers[21] = new RequestLeaseSetMessageHandler(context);
        this._handlers[31] = new MessagePayloadMessageHandler(context);
        this._handlers[22] = new MessageStatusMessageHandler(context);
        this._handlers[33] = new SetDateMessageHandler(context);
        this._handlers[35] = new DestReplyMessageHandler(context);
        this._handlers[23] = new BWLimitsMessageHandler(context);
        this._handlers[37] = new RequestVariableLeaseSetMessageHandler(context);
        this._handlers[39] = new HostReplyMessageHandler(context);
    }

    public I2CPMessageHandler getHandler(int messageTypeId) {
        if (messageTypeId < 0 || messageTypeId >= this._handlers.length) {
            return null;
        }
        return this._handlers[messageTypeId];
    }
}

