/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.naming;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Map;
import net.i2p.crypto.DSAEngine;
import net.i2p.crypto.SigType;
import net.i2p.data.Base32;
import net.i2p.data.Base64;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.data.PrivateKeyFile;
import net.i2p.data.Signature;
import net.i2p.data.SigningPrivateKey;
import net.i2p.data.SigningPublicKey;
import net.i2p.util.OrderedProperties;
import net.i2p.util.RandomSource;

public class HostTxtEntry {
    private final String name;
    private final String dest;
    private final OrderedProperties props;
    private boolean isValidated;
    private boolean isValid;
    public static final char KV_SEPARATOR = '=';
    public static final String PROPS_SEPARATOR = "#!";
    public static final char PROP_SEPARATOR = '#';
    public static final String PROP_ACTION = "action";
    public static final String PROP_DATE = "date";
    public static final String PROP_DEST = "dest";
    public static final String PROP_EXPIRES = "expires";
    public static final String PROP_NAME = "name";
    public static final String PROP_OLDDEST = "olddest";
    public static final String PROP_OLDNAME = "oldname";
    public static final String PROP_OLDSIG = "oldsig";
    public static final String PROP_SIG = "sig";
    public static final String ACTION_ADDDEST = "adddest";
    public static final String ACTION_ADDNAME = "addname";
    public static final String ACTION_ADDSUBDOMAIN = "addsubdomain";
    public static final String ACTION_CHANGEDEST = "changedest";
    public static final String ACTION_CHANGENAME = "changename";
    public static final String ACTION_REMOVE = "remove";
    public static final String ACTION_REMOVEALL = "removeall";
    public static final String ACTION_UPDATE = "update";

    public HostTxtEntry(String name, String dest) {
        this(name, dest, (OrderedProperties)null);
    }

    public HostTxtEntry(String name, String dest, String sprops) throws IllegalArgumentException {
        this(name, dest, HostTxtEntry.parseProps(sprops));
    }

    public HostTxtEntry(String sprops) throws IllegalArgumentException {
        this(null, null, HostTxtEntry.parseProps(sprops));
    }

    public HostTxtEntry(String name, String dest, OrderedProperties props) {
        this.name = name;
        this.dest = dest;
        this.props = props;
    }

    public String getName() {
        return this.name;
    }

    public String getDest() {
        return this.dest;
    }

    public OrderedProperties getProps() {
        return this.props;
    }

    private static OrderedProperties parseProps(String line) throws IllegalArgumentException {
        line = line.trim();
        OrderedProperties rv = new OrderedProperties();
        String[] entries = DataHelper.split(line, "#");
        for (int i = 0; i < entries.length; ++i) {
            String v;
            String kv = entries[i];
            int eq = kv.indexOf("=");
            if (eq <= 0 || eq == kv.length() - 1) {
                throw new IllegalArgumentException("No value: \"" + kv + '\"');
            }
            String k = kv.substring(0, eq);
            Object old = rv.setProperty(k, v = kv.substring(eq + 1));
            if (old == null) continue;
            throw new IllegalArgumentException("Dup key: " + k);
        }
        return rv;
    }

    public void write(BufferedWriter out) throws IOException {
        this.write((Writer)out);
        out.newLine();
    }

    public void write(Writer out) throws IOException {
        if (this.name != null && this.dest != null) {
            out.write(this.name);
            out.write(61);
            out.write(this.dest);
        }
        this.writeProps(out);
    }

    public void writeRemoveLine(BufferedWriter out) throws IOException {
        this.writeRemove(out);
        out.newLine();
    }

    public void writeRemove(Writer out) throws IOException {
        if (this.props == null) {
            throw new IllegalStateException();
        }
        if (this.name != null && this.dest != null) {
            this.props.setProperty(PROP_NAME, this.name);
            this.props.setProperty(PROP_DEST, this.dest);
        }
        this.writeProps(out);
        if (this.name != null && this.dest != null) {
            this.props.remove(PROP_NAME);
            this.props.remove(PROP_DEST);
        }
    }

    public void writeProps(Writer out) throws IOException {
        this.writeProps(out, false, false);
    }

    private void writeProps(Writer out, boolean omitSig, boolean omitOldSig) throws IOException {
        if (this.props == null) {
            return;
        }
        boolean started = false;
        for (Map.Entry<Object, Object> e : this.props.entrySet()) {
            String k = (String)e.getKey();
            if (omitSig && k.equals(PROP_SIG) || omitOldSig && k.equals(PROP_OLDSIG)) continue;
            if (started) {
                out.write(35);
            } else {
                started = true;
                out.write(PROPS_SEPARATOR);
            }
            String v = (String)e.getValue();
            out.write(k);
            out.write(61);
            out.write(v);
        }
    }

    public boolean hasValidSig() {
        if (this.props == null || this.name == null || this.dest == null) {
            return false;
        }
        if (!this.isValidated) {
            Signature s;
            Destination d;
            this.isValidated = true;
            StringWriter buf = new StringWriter(1024);
            String sig = this.props.getProperty(PROP_SIG);
            if (sig == null) {
                return false;
            }
            buf.append(this.name);
            buf.append('=');
            buf.append(this.dest);
            try {
                this.writeProps(buf, true, false);
            }
            catch (IOException ioe) {
                return false;
            }
            byte[] sdata = Base64.decode(sig);
            if (sdata == null) {
                return false;
            }
            try {
                d = new Destination(this.dest);
            }
            catch (DataFormatException dfe) {
                return false;
            }
            SigningPublicKey spk = d.getSigningPublicKey();
            SigType type = spk.getType();
            if (type == null) {
                return false;
            }
            try {
                s = new Signature(type, sdata);
            }
            catch (IllegalArgumentException iae) {
                return false;
            }
            this.isValid = DSAEngine.getInstance().verifySignature(s, DataHelper.getUTF8(buf.toString()), spk);
        }
        return this.isValid;
    }

    public boolean hasValidInnerSig() {
        Signature s;
        Destination d;
        if (this.props == null || this.name == null || this.dest == null) {
            return false;
        }
        boolean rv = false;
        StringWriter buf = new StringWriter(1024);
        String sig = this.props.getProperty(PROP_OLDSIG);
        String olddest = this.props.getProperty(PROP_OLDDEST);
        if (sig == null || olddest == null) {
            return false;
        }
        buf.append(this.name);
        buf.append('=');
        buf.append(this.dest);
        try {
            this.writeProps(buf, true, true);
        }
        catch (IOException ioe) {
            return false;
        }
        byte[] sdata = Base64.decode(sig);
        if (sdata == null) {
            return false;
        }
        try {
            d = new Destination(olddest);
        }
        catch (DataFormatException dfe) {
            return false;
        }
        SigningPublicKey spk = d.getSigningPublicKey();
        SigType type = spk.getType();
        if (type == null) {
            return false;
        }
        try {
            s = new Signature(type, sdata);
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
        rv = DSAEngine.getInstance().verifySignature(s, DataHelper.getUTF8(buf.toString()), spk);
        return rv;
    }

    public boolean hasValidRemoveSig() {
        Signature s;
        Destination d;
        if (this.props == null) {
            return false;
        }
        boolean rv = false;
        StringWriter buf = new StringWriter(1024);
        String sig = this.props.getProperty(PROP_SIG);
        String olddest = this.props.getProperty(PROP_DEST);
        if (sig == null || olddest == null) {
            return false;
        }
        try {
            this.writeProps(buf, true, true);
        }
        catch (IOException ioe) {
            return false;
        }
        byte[] sdata = Base64.decode(sig);
        if (sdata == null) {
            return false;
        }
        try {
            d = new Destination(olddest);
        }
        catch (DataFormatException dfe) {
            return false;
        }
        SigningPublicKey spk = d.getSigningPublicKey();
        SigType type = spk.getType();
        if (type == null) {
            return false;
        }
        try {
            s = new Signature(type, sdata);
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
        rv = DSAEngine.getInstance().verifySignature(s, DataHelper.getUTF8(buf.toString()), spk);
        return rv;
    }

    public int hashCode() {
        return this.dest.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HostTxtEntry)) {
            return false;
        }
        HostTxtEntry he = (HostTxtEntry)o;
        return this.dest.equals(he.getDest());
    }

    public void sign(SigningPrivateKey spk) {
        this.signIt(spk, PROP_SIG);
    }

    public void signInner(SigningPrivateKey spk) {
        this.signIt(spk, PROP_OLDSIG);
    }

    public void signRemove(SigningPrivateKey spk) {
        if (this.props == null) {
            throw new IllegalStateException();
        }
        if (this.props.containsKey(PROP_SIG)) {
            throw new IllegalStateException();
        }
        this.props.setProperty(PROP_NAME, this.name);
        this.props.setProperty(PROP_DEST, this.dest);
        StringWriter buf = new StringWriter(1024);
        try {
            this.writeProps(buf);
        }
        catch (IOException ioe) {
            throw new IllegalStateException(ioe);
        }
        this.props.remove(PROP_NAME);
        this.props.remove(PROP_DEST);
        Signature s = DSAEngine.getInstance().sign(DataHelper.getUTF8(buf.toString()), spk);
        if (s == null) {
            throw new IllegalArgumentException("sig failed");
        }
        this.props.setProperty(PROP_SIG, s.toBase64());
    }

    private void signIt(SigningPrivateKey spk, String sigprop) {
        if (this.props == null) {
            throw new IllegalStateException();
        }
        if (this.props.containsKey(sigprop)) {
            throw new IllegalStateException();
        }
        StringWriter buf = new StringWriter(1024);
        buf.append(this.name);
        buf.append('=');
        buf.append(this.dest);
        try {
            this.writeProps(buf);
        }
        catch (IOException ioe) {
            throw new IllegalStateException(ioe);
        }
        Signature s = DSAEngine.getInstance().sign(DataHelper.getUTF8(buf.toString()), spk);
        if (s == null) {
            throw new IllegalArgumentException("sig failed");
        }
        this.props.setProperty(sigprop, s.toBase64());
    }

    public static void main(String[] args) throws Exception {
        PrivateKeyFile pkf2;
        String host;
        boolean inner = false;
        boolean remove = false;
        if (args.length > 0 && args[0].equals("-i")) {
            inner = true;
            args = Arrays.copyOfRange(args, 1, args.length);
        }
        if (args.length > 0 && args[0].equals("-x")) {
            remove = true;
            args = Arrays.copyOfRange(args, 1, args.length);
        }
        if (args.length > 0 && args[0].endsWith(".i2p")) {
            host = args[0];
            args = Arrays.copyOfRange(args, 1, args.length);
        } else {
            byte[] rand = new byte[5];
            RandomSource.getInstance().nextBytes(rand);
            host = Base32.encode(rand) + ".i2p";
        }
        OrderedProperties props = new OrderedProperties();
        for (int i = 0; i < args.length; ++i) {
            int eq = args[i].indexOf("=");
            props.setProperty(args[i].substring(0, eq), args[i].substring(eq + 1));
        }
        props.setProperty("zzzz", "zzzzzzzzzzzzzzz");
        File f = new File("tmp-eepPriv.dat");
        PrivateKeyFile pkf = new PrivateKeyFile(f);
        pkf.createIfAbsent(SigType.EdDSA_SHA512_Ed25519);
        if (inner) {
            File f2 = new File("tmp-eepPriv2.dat");
            pkf2 = new PrivateKeyFile(f2);
            pkf2.createIfAbsent(SigType.DSA_SHA1);
            props.setProperty(PROP_OLDDEST, pkf2.getDestination().toBase64());
        } else {
            pkf2 = null;
        }
        HostTxtEntry he = new HostTxtEntry(host, pkf.getDestination().toBase64(), props);
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter(System.out));
        SigningPrivateKey priv = pkf.getSigningPrivKey();
        StringWriter sw = new StringWriter(1024);
        BufferedWriter buf = new BufferedWriter(sw);
        if (!remove) {
            if (inner) {
                SigningPrivateKey priv2 = pkf2.getSigningPrivKey();
                he.signInner(priv2);
            }
            he.sign(priv);
            he.write(out);
            out.flush();
            if (inner && !he.hasValidInnerSig()) {
                throw new IllegalStateException("Inner fail 1");
            }
            if (!he.hasValidSig()) {
                throw new IllegalStateException("Outer fail 1");
            }
            he.write(buf);
            buf.flush();
            String line = sw.toString();
            line = line.substring(line.indexOf(PROPS_SEPARATOR) + 2);
            HostTxtEntry he2 = new HostTxtEntry(host, pkf.getDestination().toBase64(), line);
            if (inner && !he2.hasValidInnerSig()) {
                throw new IllegalStateException("Inner fail 2");
            }
            if (!he2.hasValidSig()) {
                throw new IllegalStateException("Outer fail 2");
            }
        } else {
            he.getProps().remove(PROP_SIG);
            he.signRemove(priv);
            sw = new StringWriter(1024);
            buf = new BufferedWriter(sw);
            he.writeRemoveLine(buf);
            buf.flush();
            out.write(sw.toString());
            out.flush();
            String line = sw.toString().substring(2).trim();
            HostTxtEntry he3 = new HostTxtEntry(line);
            if (!he3.hasValidRemoveSig()) {
                throw new IllegalStateException("Remove verify fail");
            }
        }
    }
}

