/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto;

import java.math.BigInteger;
import net.i2p.I2PAppContext;
import net.i2p.crypto.CryptoConstants;
import net.i2p.crypto.SigUtil;
import net.i2p.crypto.YKGenerator;
import net.i2p.data.Base64;
import net.i2p.data.DataHelper;
import net.i2p.data.PrivateKey;
import net.i2p.data.PublicKey;
import net.i2p.util.Log;
import net.i2p.util.NativeBigInteger;
import net.i2p.util.SimpleByteCache;

public final class ElGamalEngine {
    private final Log _log;
    private final I2PAppContext _context;
    private final YKGenerator _ykgen;
    private static final BigInteger ELGPM1 = CryptoConstants.elgp.subtract(BigInteger.ONE);

    public ElGamalEngine(I2PAppContext context) {
        context.statManager().createRequiredRateStat("crypto.elGamal.encrypt", "Time for ElGamal encryption (ms)", "Encryption", new long[]{3600000L});
        context.statManager().createRequiredRateStat("crypto.elGamal.decrypt", "Time for ElGamal decryption (ms)", "Encryption", new long[]{3600000L});
        this._context = context;
        this._log = context.logManager().getLog(ElGamalEngine.class);
        this._ykgen = new YKGenerator(context);
        this._ykgen.start();
    }

    public void shutdown() {
        this._ykgen.shutdown();
        SigUtil.clearCaches();
    }

    public void restart() {
    }

    private BigInteger[] getNextYK() {
        return this._ykgen.getNextYK();
    }

    public byte[] encrypt(byte[] data, PublicKey publicKey) {
        if (data == null || data.length >= 223) {
            throw new IllegalArgumentException("Data to encrypt must be < 223 bytes at the moment");
        }
        if (publicKey == null) {
            throw new IllegalArgumentException("Null public key specified");
        }
        long start = this._context.clock().now();
        byte[] d2 = new byte[33 + data.length];
        d2[0] = -1;
        this._context.sha().calculateHash(data, 0, data.length, d2, 1);
        System.arraycopy(data, 0, d2, 33, data.length);
        NativeBigInteger m = new NativeBigInteger(1, d2);
        if (m.compareTo(CryptoConstants.elgp) >= 0) {
            throw new IllegalArgumentException("ARGH.  Data cannot be larger than the ElGamal prime.  FIXME");
        }
        NativeBigInteger aalpha = new NativeBigInteger(1, publicKey.getData());
        BigInteger[] yk = this.getNextYK();
        BigInteger k = yk[1];
        BigInteger y = yk[0];
        BigInteger d = ((BigInteger)aalpha).modPow(k, CryptoConstants.elgp);
        d = d.multiply(m);
        d = d.mod(CryptoConstants.elgp);
        byte[] ybytes = y.toByteArray();
        byte[] dbytes = d.toByteArray();
        byte[] out = new byte[514];
        System.arraycopy(ybytes, 0, out, ybytes.length < 257 ? 257 - ybytes.length : 0, ybytes.length > 257 ? 257 : ybytes.length);
        System.arraycopy(dbytes, 0, out, dbytes.length < 257 ? 514 - dbytes.length : 257, dbytes.length > 257 ? 257 : dbytes.length);
        long end = this._context.clock().now();
        long diff = end - start;
        if (diff > 1000L && this._log.shouldLog(30)) {
            this._log.warn("Took too long to encrypt ElGamal block (" + diff + "ms)");
        }
        this._context.statManager().addRateData("crypto.elGamal.encrypt", diff);
        return out;
    }

    public byte[] decrypt(byte[] encrypted, PrivateKey privateKey) {
        int i;
        if (encrypted == null || encrypted.length != 514) {
            throw new IllegalArgumentException("Data to decrypt must be exactly 514 bytes");
        }
        long start = this._context.clock().now();
        NativeBigInteger a = new NativeBigInteger(1, privateKey.getData());
        BigInteger y1p = ELGPM1.subtract(a);
        byte[] buf = SimpleByteCache.acquire(257);
        System.arraycopy(encrypted, 0, buf, 0, 257);
        NativeBigInteger y = new NativeBigInteger(1, buf);
        BigInteger ya = y.modPowCT(y1p, CryptoConstants.elgp);
        System.arraycopy(encrypted, 257, buf, 0, 257);
        NativeBigInteger d = new NativeBigInteger(1, buf);
        BigInteger m = ya.multiply(d);
        m = m.mod(CryptoConstants.elgp);
        byte[] val = m.toByteArray();
        for (i = 0; i < val.length && val[i] == 0; ++i) {
        }
        int payloadLen = val.length - i - 1 - 32;
        if (payloadLen < 0) {
            if (this._log.shouldLog(40)) {
                this._log.error("Decrypted data is too small (" + (val.length - i) + ")");
            }
            return null;
        }
        byte[] rv = new byte[payloadLen];
        System.arraycopy(val, i + 1 + 32, rv, 0, rv.length);
        this._context.sha().calculateHash(rv, 0, payloadLen, buf, 0);
        boolean ok = DataHelper.eq(buf, 0, val, i + 1, 32);
        SimpleByteCache.release(buf);
        long end = this._context.clock().now();
        long diff = end - start;
        if (diff > 1000L && this._log.shouldLog(30)) {
            this._log.warn("Took too long to decrypt and verify ElGamal block (" + diff + "ms)");
        }
        this._context.statManager().addRateData("crypto.elGamal.decrypt", diff);
        if (ok) {
            return rv;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Doesn't match hash data = " + Base64.encode(rv), new Exception("Doesn't match"));
        }
        return null;
    }
}

