/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import javax.security.auth.x500.X500Principal;
import net.i2p.crypto.DSAEngine;
import net.i2p.crypto.KeyGenerator;
import net.i2p.crypto.SHA1;
import net.i2p.crypto.SigType;
import net.i2p.crypto.SigUtil;
import net.i2p.data.DataHelper;
import net.i2p.data.Signature;
import net.i2p.data.SigningPrivateKey;
import net.i2p.data.SigningPublicKey;
import net.i2p.data.SimpleDataStructure;
import net.i2p.util.RandomSource;

public final class SelfSignedGenerator {
    private static final boolean DEBUG = false;
    private static final String OID_CN = "2.5.4.3";
    private static final String OID_C = "2.5.4.6";
    private static final String OID_L = "2.5.4.7";
    private static final String OID_ST = "2.5.4.8";
    private static final String OID_O = "2.5.4.10";
    private static final String OID_OU = "2.5.4.11";
    private static final String OID_SKI = "2.5.29.14";
    private static final String OID_CRLNUM = "2.5.29.20";
    private static final Map<String, String> OIDS = new HashMap<String, String>(16);

    public static Object[] generate(String cname, String ou, String o, String l, String st, String c, int validDays, SigType type) throws GeneralSecurityException {
        X509Certificate cert;
        String oid;
        SimpleDataStructure[] keys = KeyGenerator.getInstance().generateSigningKeys(type);
        SigningPublicKey pub = (SigningPublicKey)keys[0];
        SigningPrivateKey priv = (SigningPrivateKey)keys[1];
        PublicKey jpub = SigUtil.toJavaKey(pub);
        PrivateKey jpriv = SigUtil.toJavaKey(priv);
        switch (type) {
            case DSA_SHA1: 
            case ECDSA_SHA256_P256: 
            case ECDSA_SHA384_P384: 
            case ECDSA_SHA512_P521: 
            case RSA_SHA256_2048: 
            case RSA_SHA384_3072: 
            case RSA_SHA512_4096: 
            case EdDSA_SHA512_Ed25519: 
            case EdDSA_SHA512_Ed25519ph: {
                oid = type.getOID();
                break;
            }
            default: {
                throw new GeneralSecurityException("Unsupported: " + (Object)((Object)type));
            }
        }
        byte[] sigoid = SelfSignedGenerator.getEncodedOIDSeq(oid);
        byte[] tbs = SelfSignedGenerator.genTBS(cname, ou, o, l, st, c, validDays, sigoid, jpub);
        int tbslen = tbs.length;
        Signature sig = DSAEngine.getInstance().sign(tbs, priv);
        if (sig == null) {
            throw new GeneralSecurityException("sig failed");
        }
        byte[] sigbytes = SigUtil.toJavaSig(sig);
        int seqlen = tbslen + sigoid.length + SelfSignedGenerator.spaceFor(sigbytes.length + 1);
        int totlen = SelfSignedGenerator.spaceFor(seqlen);
        byte[] cb = new byte[totlen];
        int idx = 0;
        cb[idx++] = 48;
        idx = SigUtil.intToASN1(cb, idx, seqlen);
        System.arraycopy(tbs, 0, cb, idx, tbs.length);
        System.arraycopy(sigoid, 0, cb, idx += tbs.length, sigoid.length);
        idx += sigoid.length;
        cb[idx++] = 3;
        idx = SigUtil.intToASN1(cb, idx, sigbytes.length + 1);
        cb[idx++] = 0;
        System.arraycopy(sigbytes, 0, cb, idx, sigbytes.length);
        ByteArrayInputStream bais = new ByteArrayInputStream(cb);
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            cert = (X509Certificate)cf.generateCertificate(bais);
            cert.checkValidity();
        }
        catch (IllegalArgumentException iae) {
            throw new GeneralSecurityException("cert error", iae);
        }
        X509CRL crl = SelfSignedGenerator.generateCRL(cert, validDays, 1, sigoid, jpriv);
        PublicKey cpub = cert.getPublicKey();
        cert.verify(cpub);
        if (!cpub.equals(jpub)) {
            throw new GeneralSecurityException("pubkey mismatch");
        }
        Object[] rv = new Object[]{jpub, jpriv, cert, crl};
        return rv;
    }

    private static X509CRL generateCRL(X509Certificate cert, int validDays, int crlNum, byte[] sigoid, PrivateKey jpriv) throws GeneralSecurityException {
        X509CRL rv;
        SigningPrivateKey priv = SigUtil.fromJavaKey(jpriv);
        byte[] tbs = SelfSignedGenerator.genTBSCRL(cert, validDays, crlNum, sigoid);
        int tbslen = tbs.length;
        Signature sig = DSAEngine.getInstance().sign(tbs, priv);
        if (sig == null) {
            throw new GeneralSecurityException("sig failed");
        }
        byte[] sigbytes = SigUtil.toJavaSig(sig);
        int seqlen = tbslen + sigoid.length + SelfSignedGenerator.spaceFor(sigbytes.length + 1);
        int totlen = SelfSignedGenerator.spaceFor(seqlen);
        byte[] cb = new byte[totlen];
        int idx = 0;
        cb[idx++] = 48;
        idx = SigUtil.intToASN1(cb, idx, seqlen);
        System.arraycopy(tbs, 0, cb, idx, tbs.length);
        System.arraycopy(sigoid, 0, cb, idx += tbs.length, sigoid.length);
        idx += sigoid.length;
        cb[idx++] = 3;
        idx = SigUtil.intToASN1(cb, idx, sigbytes.length + 1);
        cb[idx++] = 0;
        System.arraycopy(sigbytes, 0, cb, idx, sigbytes.length);
        ByteArrayInputStream bais = new ByteArrayInputStream(cb);
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            rv = (X509CRL)cf.generateCRL(bais);
        }
        catch (IllegalArgumentException iae) {
            throw new GeneralSecurityException("cert error", iae);
        }
        return rv;
    }

    private static byte[] genTBS(String cname, String ou, String o, String l, String st, String c, int validDays, byte[] sigoid, PublicKey jpub) throws GeneralSecurityException {
        byte[] version = new byte[]{-96, 3, 2, 1, 2};
        byte[] serial = new byte[6];
        serial[0] = 2;
        serial[1] = 4;
        RandomSource.getInstance().nextBytes(serial, 2, 4);
        serial[2] = (byte)(serial[2] & 0x7F);
        String dname = "CN=" + cname + ",OU=" + ou + ",O=" + o + ",L=" + l + ",ST=" + st + ",C=" + c;
        byte[] issuer = new X500Principal(dname, OIDS).getEncoded();
        byte[] validity = SelfSignedGenerator.getValidity(validDays);
        byte[] subject = issuer;
        byte[] pubbytes = jpub.getEncoded();
        byte[] extbytes = SelfSignedGenerator.getExtensions(pubbytes);
        int len = version.length + serial.length + sigoid.length + issuer.length + validity.length + subject.length + pubbytes.length + extbytes.length;
        int totlen = SelfSignedGenerator.spaceFor(len);
        byte[] rv = new byte[totlen];
        int idx = 0;
        rv[idx++] = 48;
        idx = SigUtil.intToASN1(rv, idx, len);
        System.arraycopy(version, 0, rv, idx, version.length);
        System.arraycopy(serial, 0, rv, idx += version.length, serial.length);
        System.arraycopy(sigoid, 0, rv, idx += serial.length, sigoid.length);
        System.arraycopy(issuer, 0, rv, idx += sigoid.length, issuer.length);
        System.arraycopy(validity, 0, rv, idx += issuer.length, validity.length);
        System.arraycopy(subject, 0, rv, idx += validity.length, subject.length);
        System.arraycopy(pubbytes, 0, rv, idx += subject.length, pubbytes.length);
        System.arraycopy(extbytes, 0, rv, idx += pubbytes.length, extbytes.length);
        return rv;
    }

    private static byte[] genTBSCRL(X509Certificate cert, int validDays, int crlNum, byte[] sigalg) throws GeneralSecurityException {
        byte[] version = new byte[]{2, 1, 1};
        byte[] issuer = cert.getIssuerX500Principal().getEncoded();
        byte[] serial = cert.getSerialNumber().toByteArray();
        if (serial.length > 255) {
            throw new IllegalArgumentException();
        }
        long now = System.currentTimeMillis();
        long then = now + (long)validDays * 24L * 60L * 60L * 1000L;
        byte[] nowbytes = SelfSignedGenerator.getDate(now);
        byte[] thenbytes = SelfSignedGenerator.getDate(then);
        byte[] extbytes = SelfSignedGenerator.getCRLExtensions(crlNum);
        int revlen = 2 + serial.length + nowbytes.length;
        int revseqlen = SelfSignedGenerator.spaceFor(revlen);
        int revsseqlen = SelfSignedGenerator.spaceFor(revseqlen);
        int len = version.length + sigalg.length + issuer.length + nowbytes.length + thenbytes.length + revsseqlen + extbytes.length;
        int totlen = SelfSignedGenerator.spaceFor(len);
        byte[] rv = new byte[totlen];
        int idx = 0;
        rv[idx++] = 48;
        idx = SigUtil.intToASN1(rv, idx, len);
        System.arraycopy(version, 0, rv, idx, version.length);
        System.arraycopy(sigalg, 0, rv, idx += version.length, sigalg.length);
        System.arraycopy(issuer, 0, rv, idx += sigalg.length, issuer.length);
        System.arraycopy(nowbytes, 0, rv, idx += issuer.length, nowbytes.length);
        System.arraycopy(thenbytes, 0, rv, idx += nowbytes.length, thenbytes.length);
        idx += thenbytes.length;
        rv[idx++] = 48;
        idx = SigUtil.intToASN1(rv, idx, revseqlen);
        rv[idx++] = 48;
        idx = SigUtil.intToASN1(rv, idx, revlen);
        rv[idx++] = 2;
        rv[idx++] = (byte)serial.length;
        System.arraycopy(serial, 0, rv, idx, serial.length);
        System.arraycopy(nowbytes, 0, rv, idx += serial.length, nowbytes.length);
        System.arraycopy(extbytes, 0, rv, idx += nowbytes.length, extbytes.length);
        return rv;
    }

    private static int spaceFor(int val) {
        int rv = val > 255 ? 3 : (val > 127 ? 2 : 1);
        return 1 + rv + val;
    }

    private static byte[] getValidity(int validDays) {
        byte[] rv = new byte[32];
        rv[0] = 48;
        rv[1] = 30;
        long now = System.currentTimeMillis();
        long then = now + (long)validDays * 24L * 60L * 60L * 1000L;
        byte[] nowbytes = SelfSignedGenerator.getDate(now);
        byte[] thenbytes = SelfSignedGenerator.getDate(then);
        System.arraycopy(nowbytes, 0, rv, 2, 15);
        System.arraycopy(thenbytes, 0, rv, 17, 15);
        return rv;
    }

    private static byte[] getDate(long now) {
        SimpleDateFormat fmt = new SimpleDateFormat("yyMMddHHmmss");
        fmt.setTimeZone(TimeZone.getTimeZone("GMT"));
        byte[] nowbytes = DataHelper.getASCII(fmt.format(new Date(now)));
        if (nowbytes.length != 12) {
            throw new IllegalArgumentException();
        }
        byte[] rv = new byte[15];
        rv[0] = 23;
        rv[1] = 13;
        System.arraycopy(nowbytes, 0, rv, 2, 12);
        rv[14] = 90;
        return rv;
    }

    private static byte[] getExtensions(byte[] pubbytes) {
        byte skip;
        int pidx = 1;
        if (((skip = pubbytes[pidx++]) & 0x80) != 0) {
            pidx += skip & 0x80;
        }
        MessageDigest md = SHA1.getInstance();
        md.update(pubbytes, ++pidx, pubbytes.length - pidx);
        byte[] sha = md.digest();
        byte[] oid = SelfSignedGenerator.getEncodedOID(OID_SKI);
        int wraplen = SelfSignedGenerator.spaceFor(sha.length);
        int extlen = oid.length + SelfSignedGenerator.spaceFor(wraplen);
        int extslen = SelfSignedGenerator.spaceFor(extlen);
        int seqlen = SelfSignedGenerator.spaceFor(extslen);
        int totlen = SelfSignedGenerator.spaceFor(seqlen);
        byte[] rv = new byte[totlen];
        int idx = 0;
        rv[idx++] = -93;
        idx = SigUtil.intToASN1(rv, idx, seqlen);
        rv[idx++] = 48;
        idx = SigUtil.intToASN1(rv, idx, extslen);
        rv[idx++] = 48;
        idx = SigUtil.intToASN1(rv, idx, extlen);
        System.arraycopy(oid, 0, rv, idx, oid.length);
        idx += oid.length;
        rv[idx++] = 4;
        idx = SigUtil.intToASN1(rv, idx, wraplen);
        rv[idx++] = 4;
        idx = SigUtil.intToASN1(rv, idx, sha.length);
        System.arraycopy(sha, 0, rv, idx, sha.length);
        return rv;
    }

    private static byte[] getCRLExtensions(int crlNum) {
        if (crlNum < 0 || crlNum > 255) {
            throw new IllegalArgumentException();
        }
        byte[] oid = SelfSignedGenerator.getEncodedOID(OID_CRLNUM);
        int extlen = oid.length + 5;
        int extslen = SelfSignedGenerator.spaceFor(extlen);
        int seqlen = SelfSignedGenerator.spaceFor(extslen);
        int totlen = SelfSignedGenerator.spaceFor(seqlen);
        byte[] rv = new byte[totlen];
        int idx = 0;
        rv[idx++] = -96;
        idx = SigUtil.intToASN1(rv, idx, seqlen);
        rv[idx++] = 48;
        idx = SigUtil.intToASN1(rv, idx, extslen);
        rv[idx++] = 48;
        idx = SigUtil.intToASN1(rv, idx, extlen);
        System.arraycopy(oid, 0, rv, idx, oid.length);
        idx += oid.length;
        rv[idx++] = 4;
        rv[idx++] = 3;
        rv[idx++] = 2;
        rv[idx++] = 1;
        rv[idx++] = (byte)crlNum;
        return rv;
    }

    private static byte[] getEncodedOIDSeq(String oid) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(16);
        baos.write(48);
        baos.write(0);
        byte[] b = SelfSignedGenerator.getEncodedOID(oid);
        baos.write(b, 0, b.length);
        baos.write(5);
        baos.write(0);
        byte[] rv = baos.toByteArray();
        rv[1] = (byte)(rv.length - 2);
        return rv;
    }

    private static byte[] getEncodedOID(String oid) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(16);
        baos.write(6);
        baos.write(0);
        String[] f = DataHelper.split(oid, "[.]");
        if (f.length < 2) {
            throw new IllegalArgumentException("length: " + f.length);
        }
        baos.write(40 * Integer.parseInt(f[0]) + Integer.parseInt(f[1]));
        for (int i = 2; i < f.length; ++i) {
            int v = Integer.parseInt(f[i]);
            if (v >= 0x200000 || v < 0) {
                throw new IllegalArgumentException();
            }
            if (v >= 16384) {
                baos.write(v >> 14 | 0x80);
            }
            if (v >= 128) {
                baos.write(v >> 7 | 0x80);
            }
            baos.write(v & 0x7F);
        }
        byte[] rv = baos.toByteArray();
        if (rv.length > 129) {
            throw new IllegalArgumentException();
        }
        rv[1] = (byte)(rv.length - 2);
        return rv;
    }

    static {
        OIDS.put(OID_CN, "CN");
        OIDS.put(OID_C, "C");
        OIDS.put(OID_L, "L");
        OIDS.put(OID_ST, "ST");
        OIDS.put(OID_O, "O");
        OIDS.put(OID_OU, "OU");
        OIDS.put(OID_SKI, "SKI");
    }
}

