/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data;

import java.io.IOException;
import java.io.InputStream;
import net.i2p.data.DataFormatException;
import net.i2p.data.SDSCache;
import net.i2p.data.SimpleDataStructure;

public class PublicKey
extends SimpleDataStructure {
    public static final int KEYSIZE_BYTES = 256;
    private static final int CACHE_SIZE = 1024;
    private static final SDSCache<PublicKey> _cache = new SDSCache<PublicKey>(PublicKey.class, 256, 1024);

    public static PublicKey create(byte[] data, int off) {
        return _cache.get(data, off);
    }

    public static PublicKey create(InputStream in) throws IOException {
        return _cache.get(in);
    }

    public PublicKey() {
    }

    public PublicKey(byte[] data) {
        if (data == null) {
            throw new IllegalArgumentException("Data must be specified");
        }
        this._data = data;
    }

    public PublicKey(String base64Data) throws DataFormatException {
        this.fromBase64(base64Data);
    }

    @Override
    public int length() {
        return 256;
    }

    public static void clearCache() {
        _cache.clear();
    }
}

