/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data.i2cp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.i2cp.I2CPMessageException;
import net.i2p.data.i2cp.I2CPMessageImpl;
import net.i2p.data.i2cp.SessionId;

public class MessageStatusMessage
extends I2CPMessageImpl {
    public static final int MESSAGE_TYPE = 22;
    private int _sessionId = -1;
    private long _messageId = -1L;
    private long _nonce = -1L;
    private long _size = -1L;
    private int _status = -1;
    public static final int STATUS_AVAILABLE = 0;
    public static final int STATUS_SEND_ACCEPTED = 1;
    public static final int STATUS_SEND_BEST_EFFORT_SUCCESS = 2;
    public static final int STATUS_SEND_BEST_EFFORT_FAILURE = 3;
    public static final int STATUS_SEND_GUARANTEED_SUCCESS = 4;
    public static final int STATUS_SEND_GUARANTEED_FAILURE = 5;
    public static final int STATUS_SEND_SUCCESS_LOCAL = 6;
    public static final int STATUS_SEND_FAILURE_LOCAL = 7;
    public static final int STATUS_SEND_FAILURE_ROUTER = 8;
    public static final int STATUS_SEND_FAILURE_NETWORK = 9;
    public static final int STATUS_SEND_FAILURE_BAD_SESSION = 10;
    public static final int STATUS_SEND_FAILURE_BAD_MESSAGE = 11;
    public static final int STATUS_SEND_FAILURE_BAD_OPTIONS = 12;
    public static final int STATUS_SEND_FAILURE_OVERFLOW = 13;
    public static final int STATUS_SEND_FAILURE_EXPIRED = 14;
    public static final int STATUS_SEND_FAILURE_LOCAL_LEASESET = 15;
    public static final int STATUS_SEND_FAILURE_NO_TUNNELS = 16;
    public static final int STATUS_SEND_FAILURE_UNSUPPORTED_ENCRYPTION = 17;
    public static final int STATUS_SEND_FAILURE_DESTINATION = 18;
    public static final int STATUS_SEND_FAILURE_BAD_LEASESET = 19;
    public static final int STATUS_SEND_FAILURE_EXPIRED_LEASESET = 20;
    public static final int STATUS_SEND_FAILURE_NO_LEASESET = 21;

    public long getSessionId() {
        return this._sessionId;
    }

    @Override
    public SessionId sessionId() {
        return this._sessionId >= 0 ? new SessionId(this._sessionId) : null;
    }

    public void setSessionId(long id) {
        this._sessionId = (int)id;
    }

    public int getStatus() {
        return this._status;
    }

    public void setStatus(int status) {
        this._status = status;
    }

    public boolean isSuccessful() {
        return MessageStatusMessage.isSuccessful(this._status);
    }

    public static boolean isSuccessful(int status) {
        return status == 4 || status == 2 || status == 6 || status == 1 || status == 0;
    }

    public long getMessageId() {
        return this._messageId;
    }

    public void setMessageId(long id) {
        this._messageId = id;
    }

    public long getSize() {
        return this._size;
    }

    public void setSize(long size) {
        this._size = size;
    }

    public long getNonce() {
        return this._nonce;
    }

    public void setNonce(long nonce) {
        this._nonce = nonce;
    }

    public static final String getStatusString(int status) {
        switch (status) {
            case 0: {
                return "AVAILABLE          ";
            }
            case 1: {
                return "SEND ACCEPTED      ";
            }
            case 2: {
                return "BEST EFFORT SUCCESS";
            }
            case 4: {
                return "GUARANTEED SUCCESS ";
            }
            case 6: {
                return "LOCAL SUCCESS      ";
            }
            case 3: {
                return "PROBABLE FAILURE   ";
            }
            case 16: {
                return "NO LOCAL TUNNELS   ";
            }
            case 21: {
                return "LEASESET NOT FOUND ";
            }
        }
        return "SEND FAILURE CODE: " + status;
    }

    @Override
    protected void doReadMessage(InputStream in, int size) throws I2CPMessageException, IOException {
        try {
            this._sessionId = (int)DataHelper.readLong(in, 2);
            this._messageId = DataHelper.readLong(in, 4);
            this._status = (int)DataHelper.readLong(in, 1);
            this._size = DataHelper.readLong(in, 4);
            this._nonce = DataHelper.readLong(in, 4);
        }
        catch (DataFormatException dfe) {
            throw new I2CPMessageException("Unable to load the message data", dfe);
        }
    }

    @Override
    public void writeMessage(OutputStream out) throws I2CPMessageException, IOException {
        int len = 15;
        try {
            DataHelper.writeLong(out, 4, len);
            out.write(22);
            DataHelper.writeLong(out, 2, this._sessionId);
            DataHelper.writeLong(out, 4, this._messageId);
            out.write((byte)this._status);
            DataHelper.writeLong(out, 4, this._size);
            DataHelper.writeLong(out, 4, this._nonce);
        }
        catch (DataFormatException dfe) {
            throw new I2CPMessageException("Unable to write the message length or type", dfe);
        }
    }

    @Override
    protected byte[] doWriteMessage() throws I2CPMessageException, IOException {
        throw new UnsupportedOperationException("This shouldn't be called... use writeMessage(out)");
    }

    @Override
    public int getType() {
        return 22;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[MessageStatusMessage: ");
        buf.append("\n\tSessionId: ").append(this._sessionId);
        buf.append("\n\tNonce: ").append(this._nonce);
        buf.append("\n\tMessageId: ").append(this._messageId);
        buf.append("\n\tStatus: ").append(MessageStatusMessage.getStatusString(this._status));
        buf.append("\n\tSize: ").append(this._size);
        buf.append("]");
        return buf.toString();
    }
}

