/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.util.List;
import net.i2p.I2PAppContext;
import net.i2p.util.Log;
import net.i2p.util.SimpleStore;
import net.i2p.util.SimpleTimer;

class Executor
implements Runnable {
    private final I2PAppContext _context;
    private final Log _log;
    private final List<SimpleTimer.TimedEvent> _readyEvents;
    private final SimpleStore runn;

    public Executor(I2PAppContext ctx, Log log, List<SimpleTimer.TimedEvent> events, SimpleStore x) {
        this._context = ctx;
        this._log = log;
        this._readyEvents = events;
        this.runn = x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.runn.getAnswer()) {
            long time;
            SimpleTimer.TimedEvent evt = null;
            List<SimpleTimer.TimedEvent> list = this._readyEvents;
            synchronized (list) {
                if (this._readyEvents.isEmpty()) {
                    try {
                        this._readyEvents.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (!this._readyEvents.isEmpty()) {
                    evt = this._readyEvents.remove(0);
                }
            }
            if (evt == null) continue;
            long before = this._context.clock().now();
            try {
                evt.timeReached();
            }
            catch (Throwable t) {
                this._log.error("Executing task " + evt + " exited unexpectedly, please report", t);
            }
            if ((time = this._context.clock().now() - before) <= 1000L || !this._log.shouldLog(30)) continue;
            this._log.warn("wtf, event execution took " + time + ": " + evt);
        }
    }
}

