/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.lang.reflect.Field;
import java.util.TimeZone;
import net.i2p.I2PAppContext;
import net.i2p.util.VersionComparator;

public abstract class SystemVersion {
    private static final boolean _isWin;
    private static final boolean _isMac;
    private static final boolean _isArm;
    private static final boolean _isX86;
    private static final boolean _isGentoo;
    private static final boolean _isAndroid;
    private static final boolean _isApache;
    private static final boolean _isGNU;
    private static final boolean _isOpenJDK;
    private static final boolean _is64;
    private static final boolean _hasWrapper;
    private static final boolean _oneDotSix;
    private static final boolean _oneDotSeven;
    private static final boolean _oneDotEight;
    private static final boolean _oneDotNine;
    private static final int _androidSDK;

    public static boolean isWindows() {
        return _isWin;
    }

    public static boolean isMac() {
        return _isMac;
    }

    public static boolean isAndroid() {
        return _isAndroid;
    }

    public static boolean isApache() {
        return _isApache || _isAndroid;
    }

    public static boolean isGNU() {
        return _isGNU;
    }

    public static boolean isGentoo() {
        return _isGentoo;
    }

    public static boolean isOpenJDK() {
        return _isOpenJDK;
    }

    public static boolean isARM() {
        return _isArm;
    }

    public static boolean isX86() {
        return _isX86;
    }

    public static boolean isJava6() {
        return _oneDotSix;
    }

    public static boolean isJava7() {
        return _oneDotSeven;
    }

    public static boolean isJava8() {
        return _oneDotEight;
    }

    public static boolean isJava9() {
        return _oneDotNine;
    }

    public static boolean is64Bit() {
        return _is64;
    }

    public static int getAndroidVersion() {
        return _androidSDK;
    }

    public static boolean hasWrapper() {
        return _hasWrapper;
    }

    public static long getMaxMemory() {
        long maxMemory = Runtime.getRuntime().maxMemory();
        if (maxMemory >= 0x3FFFFFFFFFFFFFFFL) {
            maxMemory = 0x6000000L;
        }
        return maxMemory;
    }

    public static TimeZone getSystemTimeZone() {
        return SystemVersion.getSystemTimeZone(I2PAppContext.getGlobalContext());
    }

    public static TimeZone getSystemTimeZone(I2PAppContext ctx) {
        String systemTimeZone = ctx.getProperty("i2p.systemTimeZone");
        if (systemTimeZone != null) {
            return TimeZone.getTimeZone(systemTimeZone);
        }
        return TimeZone.getDefault();
    }

    public static void main(String[] args) {
        System.out.println("64 bit   : " + SystemVersion.is64Bit());
        System.out.println("Java 6   : " + SystemVersion.isJava6());
        System.out.println("Java 7   : " + SystemVersion.isJava7());
        System.out.println("Java 8   : " + SystemVersion.isJava8());
        System.out.println("Java 9   : " + SystemVersion.isJava9());
        System.out.println("Android  : " + SystemVersion.isAndroid());
        if (SystemVersion.isAndroid()) {
            System.out.println("  Version: " + SystemVersion.getAndroidVersion());
        }
        System.out.println("Apache   : " + SystemVersion.isApache());
        System.out.println("ARM      : " + SystemVersion.isARM());
        System.out.println("Mac      : " + SystemVersion.isMac());
        System.out.println("Gentoo   : " + SystemVersion.isGentoo());
        System.out.println("GNU      : " + SystemVersion.isGNU());
        System.out.println("OpenJDK  : " + SystemVersion.isOpenJDK());
        System.out.println("Windows  : " + SystemVersion.isWindows());
        System.out.println("Wrapper  : " + SystemVersion.hasWrapper());
        System.out.println("x86      : " + SystemVersion.isX86());
        System.out.println("Max mem  : " + SystemVersion.getMaxMemory());
    }

    static {
        boolean is64;
        _isWin = System.getProperty("os.name").startsWith("Win");
        _isMac = System.getProperty("os.name").startsWith("Mac");
        _isArm = System.getProperty("os.arch").startsWith("arm");
        _isX86 = System.getProperty("os.arch").contains("86") || System.getProperty("os.arch").equals("amd64");
        _isGentoo = System.getProperty("os.version").contains("gentoo") || System.getProperty("os.version").contains("hardened");
        _hasWrapper = System.getProperty("wrapper.version") != null;
        boolean bl = is64 = "64".equals(System.getProperty("sun.arch.data.model")) || System.getProperty("os.arch").contains("64");
        if (_isWin && !is64) {
            String arch = System.getenv("PROCESSOR_ARCHITECTURE");
            String wow64Arch = System.getenv("PROCESSOR_ARCHITEW6432");
            is64 = arch != null && arch.endsWith("64") || wow64Arch != null && wow64Arch.endsWith("64");
        }
        _is64 = is64;
        String vendor = System.getProperty("java.vendor");
        _isAndroid = vendor.contains("Android");
        _isApache = vendor.startsWith("Apache");
        _isGNU = vendor.startsWith("GNU Classpath") || vendor.startsWith("Free Software Foundation");
        String runtime = System.getProperty("java.runtime.name");
        _isOpenJDK = runtime != null && runtime.contains("OpenJDK");
        int sdk = 0;
        if (_isAndroid) {
            try {
                Class<?> ver = Class.forName("android.os.Build$VERSION", true, ClassLoader.getSystemClassLoader());
                Field field = ver.getField("SDK_INT");
                sdk = field.getInt(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        _androidSDK = sdk;
        if (_isAndroid) {
            _oneDotSix = _androidSDK >= 9;
            _oneDotSeven = _androidSDK >= 19;
            _oneDotEight = false;
            _oneDotNine = false;
        } else {
            _oneDotSix = VersionComparator.comp(System.getProperty("java.version"), "1.6") >= 0;
            _oneDotSeven = _oneDotSix && VersionComparator.comp(System.getProperty("java.version"), "1.7") >= 0;
            _oneDotEight = _oneDotSeven && VersionComparator.comp(System.getProperty("java.version"), "1.8") >= 0;
            _oneDotNine = _oneDotEight && VersionComparator.comp(System.getProperty("java.version"), "1.9") >= 0;
        }
    }
}

