import com.android.tools.perflib.vmtrace.MethodInfo;
import com.android.tools.perflib.vmtrace.TraceAction;
import com.android.tools.perflib.vmtrace.VmTraceHandler;
import com.android.tools.perflib.vmtrace.VmTraceParser;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;

public class Test {
    public static void main(String[] args) {
        String tracePath = "src/main/resources/studioVersion.trace";
        //String tracePath = "src/main/resources/oldVersion.trace";
        LinkedHashMap<Integer, String> threadInfoMap = new LinkedHashMap<>();
        LinkedHashMap<Long, MethodInfo> methodInfoMap = new LinkedHashMap<>();
        ArrayList<String> oderList = new ArrayList<>();
        //用法
        VmTraceParser parser = new VmTraceParser(new File(tracePath), new VmTraceHandler() {
            @Override
            public void setVersion(int version) {
                //System.out.println("version is " + version);
            }

            @Override
            public void setProperty(String key, String value) {
                /*System.out.println("setProperty key is " + key);
                System.out.println("setProperty value is " + value);*/
            }

            @Override
            public void addThread(int id, String name) {
                //System.out.println("addThread id is " + id);
                //System.out.println("addThread name is " + name);
                threadInfoMap.put(id, name);
            }

            @Override
            public void addMethod(long id, MethodInfo info) {
                // System.out.println("addMethod id is " + id);
                //System.out.println("addMethod info is " + info);
                methodInfoMap.put(id, info);
            }

            @Override
            public void addMethodAction(int threadId, long methodId, TraceAction methodAction, int threadTime, int globalTime) {
                //System.out.println("addMethodAction threadId is " + threadId);
                //System.out.println("addMethodAction methodId is " + methodId);
                // System.out.println("addMethodAction methodAction is " + methodAction);
                if (threadInfoMap.get(threadId).contains("main")) {
                    System.out.println("addMethodAction threadTime is " + threadTime);
                    System.out.println("addMethodAction globalTime is " + globalTime);
                    System.out.println("addMethodAction methodName is  "+ methodAction +"\t"+ threadInfoMap.get(threadId) + "\t" + methodInfoMap.get(methodId));
                }

                /*if (methodAction == TraceAction.METHOD_ENTER) {
                    System.out.println("addMethodAction methodName is ent " + threadInfoMap.get(threadId) + "\t" + methodInfoMap.get(methodId));
                    oderList.add("addMethodAction methodName is " + threadInfoMap.get(threadId) + "\t" + methodInfoMap.get(methodId));
                }*/

                /*if (methodAction == TraceAction.METHOD_EXIT) {
                    System.out.println("addMethodAction methodName is xit " + threadInfoMap.get(threadId) + "\t" + methodInfoMap.get(methodId));
                }*/
                /*if (methodAction == TraceAction.METHOD_EXIT_UNROLL) {
                    System.out.println("addMethodAction methodName is ent " + threadInfoMap.get(threadId) + "\t" + methodInfoMap.get(methodId));
                    oderList.add("addMethodAction methodName is " + threadInfoMap.get(threadId) + "\t" + methodInfoMap.get(methodId));
                }*/
            }

            @Override
            public void setStartTimeUs(long startTimeUs) {
                //System.out.println("setStartTimeUs is " + startTimeUs);
            }
        });
        try {
            parser.parse();
            outTxt(oderList, "src/main/resources/appMethodOrderTrace.txt");
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void outTxt(ArrayList<String> list, String fileName) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        for (String s : list) {
            stringBuffer.append(s);
            stringBuffer.append("\n");
        }
        File file = new File(fileName);
        if (!file.exists()) {
            file.createNewFile();
        }
        FileWriter fileWriter = new FileWriter(fileName);
        fileWriter.write(stringBuffer.toString());
        fileWriter.flush();
        fileWriter.close();
    }
}
