package ui;

import javax.swing.table.AbstractTableModel;
import java.util.ArrayList;
import java.util.List;

/**
 * 内容显示面板Tab栏
 */
public class MethodTabModel extends AbstractTableModel {
    private ArrayList<OrderBean> content = new ArrayList<OrderBean>();
    private String[] columns = new String[] { "threadID", "threadName","usecs(μs)",
            "method" };

    public MethodTabModel() {

    }

    @Override
    public int getRowCount() {// 行数
        return content.size();
    }

    @Override
    public int getColumnCount() {// 列数
        return columns.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        OrderBean bean = this.content.get(rowIndex);
        // 每个列显示的内容定制
        switch (columnIndex) {
            case 0:
                return bean.getThreadId();
            case 1:
                return bean.getThreadName();
            case 2:
                return bean.getCostTime();
            case 3:
                return bean.getFunctionName();
        }
        return null;
    }
    @Override
    public String getColumnName(int column) {
        return columns[column];
    }

    public void setContent(List<OrderBean> content) {
        this.content.clear();
        this.content.addAll(content);
        fireTableDataChanged();
    }

}
