import xbmc
import xbmcaddon
import xbmcplugin
import xbmcgui
from xbmcvfs import translatePath
from xbmcgui import ListItem
from routing import Plugin

import os
import uuid
import requests

from .acetv import AceTV

addon = xbmcaddon.Addon()
plugin = Plugin()
plugin.name = addon.getAddonInfo("name")
plugin.addon_id = addon.getAddonInfo("id")
USER_DATA_DIR = translatePath(addon.getAddonInfo("profile"))
if not os.path.exists(USER_DATA_DIR):
    os.makedirs(USER_DATA_DIR)

ENGINE_HOST = addon.getSetting("engine_host")
HTTP_API_PORT = addon.getSetting("http_api_port")
TCP_API_PORT = addon.getSetting("tcp_api_port")

atv = AceTV(USER_DATA_DIR)


@plugin.route("/")
def root():
    list_items = [
        (plugin.url_for(check), ListItem("Check Acestream Version", offscreen=True), False),
        (
            plugin.url_for(play_media, content_id="11b6aa16e978a409504b9e3e9c3b29c56f392bdf"),
            ListItem("Play Test Stream", offscreen=True),
            False,
        ),
        (plugin.url_for(play_cid), ListItem("Play Content ID", offscreen=True), False),
        (plugin.url_for(play_url), ListItem("Play From URL", offscreen=True), False),
        (plugin.url_for(history), ListItem("History", offscreen=True), True),
        (plugin.url_for(settings), ListItem("Open Settings", offscreen=True), False),
    ]
    xbmcplugin.addDirectoryItems(plugin.handle, list_items)
    xbmcplugin.endOfDirectory(plugin.handle)


@plugin.route("/check")
def check():
    service_url = f"http://{ENGINE_HOST}:{HTTP_API_PORT}/webui/api/service"
    try:
        r = requests.get(service_url, {"method": "get_version", "format": "json"}, timeout=5)
    except requests.exceptions.ConnectionError:
        xbmcgui.Dialog().ok("Acestream Version", "Unable to connect to Acestream Engine")
        return
    res = r.json()["result"]
    xbmcgui.Dialog().ok("Acestream Version", f'{res["platform"]} {res["version"]}')


@plugin.route("/play_media")
def play_media():
    if "content_id" in plugin.args:
        play_url = plugin.url_for(play_hls, content_id=plugin.args["content_id"][0])
        xbmc.executebuiltin(f"PlayMedia({play_url})")
    elif "url" in plugin.args:
        play_url = plugin.url_for(play_hls, url=plugin.args["url"][0])
        xbmc.executebuiltin(f"PlayMedia({play_url})")


@plugin.route("/settings")
def settings():
    xbmc.executebuiltin(f"Addon.OpenSettings({plugin.addon_id})")


@plugin.route("/history")
def history():
    list_items = []
    streams = atv.get_last_streams(20)
    for stream in streams:
        title = f"{stream.name} - {stream.content_id}"
        li = ListItem(title, offscreen=True)
        url = plugin.url_for(play_media, content_id=stream.content_id)
        list_items.append((url, li, False))
    xbmcplugin.addDirectoryItems(plugin.handle, list_items)
    xbmcplugin.setContent(plugin.handle, "videos")
    xbmcplugin.endOfDirectory(plugin.handle)


@plugin.route("/play_cid")
def play_cid():
    dialog = xbmcgui.Dialog()
    d = dialog.input("Enter Acestream Content ID", type=xbmcgui.INPUT_ALPHANUM)
    if len(d) == 40:
        play_url = plugin.url_for(play_hls, content_id=d)
        xbmc.executebuiltin(f"PlayMedia({play_url})")
    else:
        xbmcgui.Dialog().notification(plugin.name, "Invalid Content ID", xbmcgui.NOTIFICATION_ERROR)


@plugin.route("/play_url")
def play_url():
    dialog = xbmcgui.Dialog()
    d = dialog.input("Enter URL", type=xbmcgui.INPUT_ALPHANUM)
    if len(d) > 5:
        play_url = plugin.url_for(play_hls, url=d)
        xbmc.executebuiltin(f"PlayMedia({play_url})")
    else:
        xbmcgui.Dialog().notification(plugin.name, "Invalid URL", xbmcgui.NOTIFICATION_ERROR)


@plugin.route("/play_hls.pvr")
def play_hls():
    params = {}
    if "content_id" in plugin.args:
        stream = atv.get_stream_from_cid(plugin.args["content_id"][0])
        if stream:
            params["id"] = stream.content_id
        else:
            params["id"] = plugin.args["content_id"][0]
    elif "url" in plugin.args:
        stream = atv.get_stream_from_url(plugin.args["url"][0])
        if stream:
            params["id"] = stream.content_id
        else:
            params["url"] = plugin.args["url"][0]
    else:
        return

    HLS_API = f"http://{ENGINE_HOST}:{HTTP_API_PORT}/ace/manifest.m3u8"
    IA = addon.getSettingBool("inputstream")
    params["format"] = "json"
    params["use_api_events"] = 1
    params["use_stop_notifications"] = 1
    params["preferred_audio_language"] = "eng"
    params["pid"] = uuid.uuid4().hex
    if IA:
        params["transcode_audio"] = 1
        params["transcode_mp3"] = 1
        params["transcode_ac3"] = 0
    try:
        r = requests.get(HLS_API, params=params, timeout=15)
        r.raise_for_status()
    except requests.exceptions.ConnectionError:
        xbmcgui.Dialog().notification(plugin.name, "Acestream Engine Not Available", xbmcgui.NOTIFICATION_ERROR)
        xbmcplugin.setResolvedUrl(plugin.handle, False, ListItem())
        return
    res = r.json()["response"]
    print(res)
    for i in range(30):
        r = requests.get(res["stat_url"])
        stat = r.json()["response"]
        print(stat)
        if "status" in stat:
            if stat["status"] == "dl":
                break
        xbmc.sleep(1000)

    xbmc.executebuiltin(
        "RunScript({0},{1},{2},{3})".format(
            "program.acestreamhandler.monitor",
            res["event_url"],
            res["stat_url"],
            res["command_url"],
        )
    )
    xbmc.sleep(1000)
    if stream:
        atv.mark_played(stream)
        title = f"{stream.name} - {stream.content_id}"
    else:
        title = "?"
    li = ListItem(title, path=res["playback_url"])
    li.setContentLookup(False)
    li.setMimeType("application/vnd.apple.mpegurl")
    if IA:
        li.setProperty("inputstream", "inputstream.adaptive")
        li.setProperty("inputstream.adaptive.manifest_type", "hls")
    xbmcplugin.setResolvedUrl(plugin.handle, True, li)


def run(args):
    plugin.run(args)
