<?php

/**
 * @version    1.2.1
 * @package    Com_ZohoMail
 * @author     Zoho Mail <zmintegration@zohomail.com>
 * @copyright  Copyright © 2023, Zoho Corporation Pvt. Ltd. All Rights Reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die('Restricted access');
use Joomla\Component\Plugins\Administrator\Model\PluginModel;

use Zoho\Component\ZohoMail\Administrator\Helpers\SettingsHelper;
use Joomla\CMS\Uri\Uri;
require JPATH_BASE . '/components/com_zohomail/src/Helpers/settings.php';
use Joomla\CMS\Factory;
$pluginParams = JComponentHelper::getParams('com_zohomail');
$nonce = bin2hex(random_bytes(16));
$app = Factory::getApplication();
$session = $app->getSession();
$input = $app->input;
$completeRedirectUrl=Uri::base().'index.php?option=com_zohomail';
if ($input->getString('zmail_integ_submit') != null && $_SERVER['REQUEST_METHOD'] === 'POST') {

	$storedNonce = $session->get('oauth_nonce');
	$submittedNonce = $input->get('nonce', '', 'STRING');

	if ($storedNonce != $submittedNonce) {
		echo 'Invalid Token';
		exit;
	}
	else {
		$zmail_integ_client_id = $app->input->getString('zmail_integ_client_id','');
        $zmail_integ_client_secret = $app->input->getString('zmail_integ_client_secret','');
		$zmail_integ_domain_name = $app->input->getString('zmail_integ_domain_name');

		$completeRedirectUrl=Uri::base().'index.php?option=com_zohomail';
		$state=base64_encode(implode(":", array($zmail_integ_client_id, $zmail_integ_client_secret,$zmail_integ_domain_name,$submittedNonce)));

		$authorizeUrl="https://accounts.".SettingsHelper::$domainMapping[$zmail_integ_domain_name]."/oauth/v2/auth?response_type=code&client_id=". $zmail_integ_client_id."&scope=VirtualOffice.messages.CREATE,VirtualOffice.accounts.READ&redirect_uri=".urlencode($completeRedirectUrl)."&prompt=consent&access_type=offline&state=".$state;
		header('Location: ' . $authorizeUrl);
		exit;
	}


	}
	else if($input->get('code')!=null && $_SERVER['REQUEST_METHOD'] === 'GET') {
		$accessTokenData = SettingsHelper::generateTokenByCode($completeRedirectUrl,$input->get('code'));
		if(isset($accessTokenData['error'])){
			echo $accessTokenData['error'];

		}
		else{
			header('Location: ' . $completeRedirectUrl);
		}

		exit;
    }
	else if ($input->get('zmail_integ_save')!=null && $_SERVER['REQUEST_METHOD'] === 'POST') {
		$settings = array();
		$settings['zmail_from_address']=$app->input->getString('zmail_integ_from_email_id');
		$settings['zmail_from_name']=$app->input->getString('zmail_integ_from_name');
		if($pluginParams->get('zmail_connection')) 
		{
			$connection = json_decode($pluginParams->get('zmail_connection'),true);
			$zmail_integ_client_id = $connection['zmail_integ_client_id'];
			$zmail_integ_client_secret = base64_decode($connection['zmail_integ_client_secret']);
			$zmail_integ_domain_name=$connection['zmail_integ_domain_name'];
			
			
		}else 
		{
			$zmail_integ_client_id = '';
			$zmail_integ_client_secret = '';
			$zmail_integ_from_address = '';
			$zmail_integ_from_name='';
			$zmail_integ_domain_name='com';
		}
		
		try
		{
			$zmail_integ_from_address=$input->get('zmail_integ_from_email_id');
			$zmail_from_address = $settings['zmail_from_address'];
			$zmail_from_name=$settings['zmail_from_name'];
			if(SettingsHelper::configureMailDetails($app->input->getString('zmail_integ_from_email_id'),$app->input->getString('zmail_integ_from_name'))) {
				
				$app->enqueueMessage('Configured Successfully','Message');
			} else {
				$app->enqueueMessage("Please check the valid user",'error');
			}
		}
		catch(Exception $e) {
			$app->enqueueMessage($e->getMessage(),'error');
		}
		
		
	}
	else if($input->get('task') == 'maillist') {
		$maildetailJSON = json_decode('{}',true);
		if($pluginParams->get('zmail_connection')) 
		{
			
			try 
			{
				$mailDetail = SettingsHelper::getZohoMailAccountDetail();
				if($mailDetail){
					$maildetailJSON = $mailDetail;
				}
			}
			catch(Exception $e)
			{
				$maildetailJSON['error'] = "Please authentication and try again";
				
			}
			
		}
		else {
			$maildetailJSON['error'] = "Please authentication and try again";
		}
		echo json_encode($maildetailJSON);
		exit;
	} 
	else {
		if($pluginParams->get('zmail_connection')) 
		{
			$connection = json_decode($pluginParams->get('zmail_connection'),true);
			$zmail_integ_client_id = $connection['zmail_integ_client_id'];
			$zmail_integ_client_secret = base64_decode($connection['zmail_integ_client_secret']);
			$zmail_from_address = $pluginParams->get('zmail_from_address');
			$zmail_from_name=$pluginParams->get('zmail_from_name');
			$zmail_integ_domain_name=$connection['zmail_integ_domain_name'];
			
		}else 
		{
			$zmail_integ_client_id = '';
			$zmail_integ_client_secret = '';
			$zmail_integ_from_address = '';
			$zmail_integ_from_name='';
			$zmail_integ_domain_name='com';
			$zmail_from_address = '';
			$zmail_from_name='';
		}
	}
	
	$session->set('oauth_nonce', $nonce);
?>
<head>
    <meta charset="UTF-8">
    <title>Zoho Mail</title>
	
	<?php JHtml::stylesheet('media/com_zohomail/css/style.css');?>
	<?php JHtml::_('jquery.framework');?>

	<script>
	
	$(document).ready(function(){
		$("select[name='zmail_integ_from_email_id']").on("click", function() {
			if ($(this).attr("isLoaded"))
				return;
			
			self=this;
			$('#loadingSymbol').show();
			$.ajax({
				url: '<?php echo $completeRedirectUrl."&task=maillist"; ?>',
				type: 'GET',
				success: function(response) {
					var respJSON = $.parseJSON(response);
					if(respJSON['error']) {
						Joomla.renderMessages({'error':[respJSON['error']]});
						window.scroll({
								top: 0,
								left: 0,
								behavior: 'smooth'
							});
					} 
					else {
						if(respJSON['zmail_acc_id'] === null) {
							Joomla.renderMessages({'error':["Please authenticate and try again"]});
							window.scroll({
								top: 0,
								left: 0,
								behavior: 'smooth'
							});
						} else {
							var options = respJSON['zmail_email_list'];
							$(self).empty();
							$.each(options, function(index, option) {
								$('<option>').val(option).text(option).appendTo(self);
							});
							$(self).attr("isLoaded",true);
						}
						
					}
					
					$('#loadingSymbol').hide();
				}
			});
		});
		
	});

	</script>
</head>


    <head>
    <meta charset="UTF-8">
    <title>Zoho Mail</title>
    </head>
    <body>
	
	<div class="page"><div class="page__content">
            <div class="page__header">
                <h1><?php echo JText::_('COM_ZOHOMAIL_TITLE'); ?></h1>
                <p>Please visit the <a class="zm_a" href=<?php echo "https://accounts.zoho.com/developerconsole"?> target="_blank">Zoho OAuth Creation</a> documentation page for usage instructions.</p>
            </div>
    <form method="post" action="<?php echo $_SERVER["REQUEST_URI"]; ?>">
   
			<?php echo JHtml::_('form.token'); ?>
			<input type="hidden" name="nonce" value="<?php echo $nonce; ?>">
            <div class="form__row">
                <label class="form--label"><?php echo JText::_('COM_ZOHOMAIL_LABEL_HOST'); ?></label>
                <div class="form__domain">
                  <span class="form__domain-info">mail.zoho</span>

                    <select class="form__domain-value" name="zmail_integ_domain_name">
                  			<option value="com" <?php if($zmail_integ_domain_name == "com") {?> selected="true"<?php } ?>>.com</option>
                  			<option value="eu" <?php if($zmail_integ_domain_name == "eu") {?> selected="true"<?php } ?>>.eu</option>
                  			<option value="in" <?php if($zmail_integ_domain_name == "in") {?> selected="true"<?php }?>>.in</option>
                  			<option value="com.cn" <?php if($zmail_integ_domain_name == "com.cn") {?>selected="true"<?php }?>>.com.cn</option>
                  			<option value="com.au" <?php if($zmail_integ_domain_name == "com.au"){?>selected="true"<?php }?>>.com.au</option>
                            <option value="jp" <?php if($zmail_integ_domain_name == "jp"){?>selected="true"<?php }?>>.jp</option>
                            <option value="zohocloud.ca" <?php if($zmail_integ_domain_name == "zohocloud.ca"){?>selected="true"<?php }?>>.zohocloud.ca</option>
                            <option value="sa" <?php if($zmail_integ_domain_name == "sa"){?>selected="true"<?php }?>>.sa</option>
                      </select>
                    
                  </div>
                  <div>
                      <i class="form__row-info"><?php echo JText::_('COM_ZOHOMAIL_INFO_HOST'); ?></i>
                  </div>
                </div>
                <div class="form__row">
                    <label class="form--label"><?php echo JText::_('COM_ZOHOMAIL_LABEL_CLIENTID'); ?></label>
                    <input type="text" value="<?php echo SettingsHelper::zohomail_escape($zmail_integ_client_id); ?>" name="zmail_integ_client_id" class="form--input" id="zmail_integ_client_id" required/> <i class="form__row-info"><?php echo JText::_('COM_ZOHOMAIL_INFO_CLIENT'); ?></i> </div>
                <div class="form__row">
                    <label class="form--label"><?php echo JText::_('COM_ZOHOMAIL_LABEL_CLIENTSECRET'); ?></label>
                    <input type="password" value="<?php echo SettingsHelper::zohomail_escape($zmail_integ_client_secret); ?>" name="zmail_integ_client_secret" class="form--input" id="zmail_integ_client_secret"  required/> <i class="form__row-info"><?php echo JText::_('COM_ZOHOMAIL_INFO_CLIENT'); ?></i> </div>
                <div class="form__row">
                    <label class="form--label"><?php echo JText::_('COM_ZOHOMAIL_LABEL_AUTHORIZEURI'); ?></label>
                    <input type="text" id="zmail_integ_authorization_uri" readonly="readonly" name="zmail_integ_authorization_uri" class="form--input" value="<?php echo Uri::base().'index.php?option=com_zohomail'; ?>" class="regular-text" readonly="readonly" required/> <i class="form__row-info"><?php echo JText::_('COM_ZOHOMAIL_INFO_AUTHORIZEURI'); ?></i> </div>
                
			 
                <div class="form__row form__row-btn">
                  <input type="submit" name="zmail_integ_submit" id="zmail_integ_submit" class="btn" value="Authorize"/> 
                  </div>
                  
                
              
             </form>
			 
			 <form method="post" action="<?php echo $_SERVER["REQUEST_URI"]; ?>">
			 <div class="form__row">
                    <label class="form--label"><?php echo JText::_('COM_ZOHOMAIL_LABEL_FROM'); ?></label>
					<div style="width:100%;position:relative;">
					<div id="loadingSymbol" style="display:none" class="loading-spinner"></div>
					<select class="form--input form--input--select" name="zmail_integ_from_email_id">
					    <option value="<?php echo SettingsHelper::zohomail_escape($zmail_from_address);?>" selected="true"><?php echo SettingsHelper::zohomail_escape($zmail_from_address);?></option>
                  			
                      </select>
					 </div>
                    <i class="form__row-info"><?php echo JText::_('COM_ZOHOMAIL_INFO_FROM'); ?></i> </div>
					<div class="form__row">
                    <label class="form--label"><?php echo JText::_('COM_ZOHOMAIL_LABEL_FROMNAME'); ?></label>
					
                    <input type="text" name="zmail_integ_from_name" value="<?php echo SettingsHelper::zohomail_escape($zmail_from_name); ?>" class="form--input" id="zmail_integ_from_name" required/> <i class="form__row-info"><?php echo JText::_('COM_ZOHOMAIL_LABEL_FROMNAME'); ?></i> </div>
                 
					<div class="form__row form__row-btn">
                  <input type="submit" name="zmail_integ_save" id="zmail_integ_submit" class="btn" value="Save"/> 
                  </div>
			 </form>
			 
			 </div>
			 </div>
			 </div>
           </body>
