<?php
defined('_JEXEC') or die('Restricted access');
/**
 * @version    1.2.1
 * @package    Com_ZohoMailMail
 * @author     Zoho Mail <zmintegration@zohomail.com>
 * @copyright  Copyright © 2023, Zoho Corporation Pvt. Ltd. All Rights Reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */
 

use Joomla\Component\Plugins\Administrator\Model\PluginModel;

use Zoho\Component\ZohoMail\Administrator\Helpers\SettingsHelper;
require JPATH_BASE . '/components/com_zohomail/src/Helpers/settings.php';
use Joomla\CMS\Factory;
$appl =JFactory::getApplication();
$input = $appl->input;
if ($input->getString('zmail_send_mail_submit') != null && $_SERVER['REQUEST_METHOD'] === 'POST') {
	$to = $appl->input->getString('zmail_to_address','');
	$subject = $input->getString('zmail_subject');
	$content =$input->getString('zmail_content');
	$isHtml = $appl->input->getBool('mail_type',false);
    $isPluginEnabled = JPluginHelper::isEnabled('system', 'zohomailer');
    if($isPluginEnabled) {
        SettingsHelper::sendTestMail($to,$subject,$content,$isHtml);
    } else {
		JFactory::getApplication()->enqueueMessage(JText::_("COM_ZOHOMAIL_PLUGIN_ENABLE"),'error');
    }
} else {
    $to = '';
    $subject = '';
    $content = '';
    $isHtml = 0;
}

?>
<head>
    <meta charset="UTF-8">
    <title>Zoho Mail</title>
	<?php JHtml::stylesheet('media/com_zohomail/css/style.css');?>
</head>

<body>
    
           <form method="post" action="<?php echo $_SERVER['REQUEST_URI']; ?>">
               
               <body>
                  <div class="page"><div class="page__content">
                      <div class="page__header">
                          <h1><?php echo JText::_('COM_ZOHOMAIL_LABEL_SENDMAIL'); ?> <span class="ico-send"></span></h1>
                      </div>
                      <div class="form">
                       <div class="form__row">
                        <label class="form--label"><?php echo JText::_('COM_ZOHOMAIL_LABEL_TO'); ?></label>
                        <input type="text" class="form--input" name="zmail_to_address" value="<?php echo $to; ?>" required = "required"/> </div>
                        <div class="form__row">
                            <label class="form--label"><?php echo JText::_('COM_ZOHOMAIL_LABEL_MAILTYPE'); ?></label>
                            <select class="form--input form--input--select" name="mail_type">
                                <option value="0">Text/Plain</option>
                                <option value="1" <?php if($isHtml == 1) {?> selected="true"<?php } ?>>HTML</option>
                            </select>
                        </div>
                        <div class="form__row">
                            <label class="form--label" ><?php echo JText::_('COM_ZOHOMAIL_LABEL_SUBJECT'); ?></label>
                            <input type="text" class="form--input" name="zmail_subject" value="<?php echo SettingsHelper::zohomail_escape($subject); ?>" required = "required"/> </div>
                            <div class="form__row">
                             <label class="form--label"><?php echo JText::_('COM_ZOHOMAIL_LABEL_CONTENT'); ?></label>
                             <textarea class="form--input" name="zmail_content" ><?php echo SettingsHelper::zohomail_escape($content); ?></textarea> </div>
                             <div class="form__row form__row-btn"> <input type="submit" class = "btn" name="zmail_send_mail_submit" id="zmail_send_mail_submit" value="<?php echo JText::_('COM_ZOHOMAIL_LABEL_SENDMAIL'); ?>">

                             </div>
                         </div>
                     </div>
                 </div>
             </body>
         </form>
</body>
