<?php
/**
 * @version    1.2.1
 * @package    Com_ZohoMail
 * @author     Zoho Mail <zmintegration@zohomail.com>
 * @copyright  Copyright © 2023, Zoho Corporation Pvt. Ltd. All Rights Reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die('Restricted access');
jimport('joomla.version');
use Joomla\CMS\Factory;
class PlgSystemZohoMailer extends JPlugin {

    /**
     * Here we will override the JMail class
     *
     * @return bool
     */
    public function onAfterInitialise() {

        $pluginParams = JComponentHelper::getParams('com_zohomail');
		if(!$pluginParams) {
			return false;
		} else if(empty($pluginParams->get('zmail_connection'))){
			return false;
		}
		$version = new JVersion();
		$joomlaVersion = $version->getShortVersion();
		if (version_compare($joomlaVersion, '4.4', '<')) {
			$path = JPATH_ROOT . '/plugins/system/zohomailer/mailer/mail.php';
		} else {
			$path = JPATH_ROOT . '/plugins/system/zohomailer/mailer/v5/mail.php';
			
		}
        JLoader::register('JMail', $path);
        JLoader::load('JMail');
		
	}
}
 



