<?php
/**
 * @version    1.2.1
 * @package    Com_ZohoMail
 * @author     Zoho Mail <zmintegration@zohomail.com>
 * @copyright  Copyright © 2023, Zoho Corporation Pvt. Ltd. All Rights Reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Zoho\Component\ZohoMail\Administrator\Helpers;
use Joomla\CMS\Factory;
use Joomla\Component\Plugins\Administrator\Model\PluginModel;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Uri\Uri;
defined('_JEXEC') or die('Restricted access');



class SettingsHelper {

	private static function configure_zohomail($postData) {
		$appl = \JFactory::getApplication();
		$params = \JComponentHelper::getParams('com_zohomail');
		$input = $appl->input;
		$data = json_encode((array)$params);
		$db = \JFactory::getDbo();
		$prefix = $db->getPrefix();
		$query = $db->getQuery(true);
		$query->select($db->quoteName(array(
        'extension_id',
        'name',
        'params'
		)));
    $query->from($db->quoteName($prefix . 'extensions'));
    $query->where($db->quoteName('name') . ' = \'Zoho Mail\'');
	$db->setQuery($query);
	$results = $db->loadObjectList();
    $db_params = json_decode($results[0]->params, true);

	foreach($postData as $key => $val) {
		$db_params[$key] = $val;
	}
    $db_params = json_encode($db_params);

    $query = $db->getQuery(true);
    $query = $db->getQuery(true);
    $query->clear();

    $fields = array(
        $db->quoteName('params') . ' = ' . $db->quote($db_params)
    );
    $conditions = array(
        $db->quoteName('name') . ' = ' . $db->quote("Zoho Mail")
    );

    $query->update($db->quoteName($prefix . 'extensions'))
        ->set($fields)
        ->where($conditions);

    $db->setQuery($query);

    try {
        $db->execute();
    } catch (RuntimeException $e) {
        $appl->enqueueMessage($e->getMessage(),'error');
    }

	return true;

	}

	public static function sendTestMail($to,$subject,$content,$mail_type) {
		$appl = \JFactory::getApplication();
		$mailer = \JFactory::getMailer();
		$pluginParams = \JComponentHelper::getParams('com_zohomail');

		if(empty($pluginParams->get('zmail_connection'))){
		    $appl->enqueueMessage(Text::_('COM_ZOHOMAIL_NOCONFIG'),'error');
		    return false;
		}

		if (!filter_var($to, FILTER_VALIDATE_EMAIL)) {
          $appl->enqueueMessage(Text::_('COM_ZOHOMAIL_ENTER_RECIPIENT'),'error');
          return false;
        }
        if(empty(trim($subject))) {
            $appl->enqueueMessage(Text::_("COM_ZOHOMAIL_SPECIFY_SUBJECT"),'error');
            return false;
        }
		$mailer->addRecipient($to);
		if(empty(trim($content))) {
		    $appl->enqueueMessage(Text::_("COM_ZOHOMAIL_SPECIFY_CONTENT"),'error');
		    return false;
		}
		$mailer->setBody($content);

		$mailer->setSubject($subject);
		if($mail_type == 1) {
		    $mailer->isHtml();
		}
		if(!$mailer->isZohoMailer) {
			$appl->enqueueMessage('Mail not sent through zohomailer','message');
			return false;
		}
		if($mailer->Send()){
			$appl->enqueueMessage(Text::_("COM_ZOHOMAIL_MAIL_SENT"),'message');
			return true;
		}
		$appl->enqueueMessage(Text::_("COM_ZOHOMAIL_MAIL_NOT_SENT"),'error');
		return false;
	}

	public static function zohomail_escape($text)
	{
		if(!empty($text)) {
			return htmlspecialchars($text, ENT_QUOTES, 'UTF-8');
		}else {
			return $text;
		}

	}


	public static function getZohoMailAccountDetail(){
		$accessTokenData = SettingsHelper::getToken();

		return SettingsHelper::getZohoMailList($accessTokenData);
	}
	private static function getZohoMailList($zmail_connection){
		$zmail_domain_name=$zmail_connection['zmail_integ_domain_name'];
		$zmail_access_token=base64_decode($zmail_connection['zmail_access_token']);
		$mailData = json_decode("{}",true);
		$urlAccounts = "https://mail.".SettingsHelper::$domainMapping[$zmail_domain_name]."/api/accounts";
		$curl = curl_init();
		curl_setopt_array($curl, array(
			CURLOPT_URL => $urlAccounts,
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => "",
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 30,
			CURLOPT_SSLVERSION => CURL_SSLVERSION_TLSv1_2,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => "GET",
			CURLOPT_HTTPHEADER => array(
				"accept: application/json",
				"cache-control: no-cache",
				"content-type: application/json",
				"User-Agent: JoomlaPlugin",
				"Authorization: Zoho-oauthtoken ".$zmail_access_token
			),
		));
		$bodyAccounts = curl_exec($curl);

		$jsonbodyAccounts = json_decode($bodyAccounts);
		$emailList = array();
		if(count($jsonbodyAccounts->data)>0)
		{
			$isConfigured = false;
			if(count($jsonbodyAccounts->data[0]->emailAddress)>0) {
				for($j=0;$j<count($jsonbodyAccounts->data[0]->emailAddress);$j++) {
					if($jsonbodyAccounts->data[0]->emailAddress[$j]->isConfirmed) {
						$mailData['zmail_acc_id'] = $jsonbodyAccounts->data[0]->accountId;
						array_push($emailList,$jsonbodyAccounts->data[0]->emailAddress[$j]->mailId);
					 }
				 }
			 }

		}
		$mailData['zmail_email_list'] = $emailList;
		return $mailData;
	}
	private static function getToken() {
		$pluginParams = \JComponentHelper::getParams('com_zohomail');
		$zmail_connection = json_decode($pluginParams->get('zmail_connection'),true);

		if(time()-$zmail_connection['zmail_integ_timestamp'] > 3300) {
			$urlUsingRefreshToken ="https://accounts.".SettingsHelper::$domainMapping[$zmail_connection['zmail_integ_domain_name']]."/oauth/v2/token?refresh_token=".base64_decode($zmail_connection['zmail_refresh_token'])."&grant_type=refresh_token&client_id=".$zmail_connection['zmail_integ_client_id']."&client_secret=".base64_decode($zmail_connection['zmail_integ_client_secret'])."&redirect_uri=".Uri::base()."administrator/index.php?option=com_zohomail&scope=VirtualOffice.messages.CREATE,VirtualOffice.accounts.READ";
		$acurl = curl_init();

		curl_setopt_array($acurl, array(
									CURLOPT_URL => $urlUsingRefreshToken,
									CURLOPT_RETURNTRANSFER => true,
									CURLOPT_ENCODING => "",
									CURLOPT_MAXREDIRS => 10,
									CURLOPT_TIMEOUT => 30,
									CURLOPT_SSLVERSION => CURL_SSLVERSION_TLSv1_2,
									CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
									CURLOPT_CUSTOMREQUEST => "POST",
									CURLOPT_HTTPHEADER => array(
										"accept: application/json",
										"cache-control: no-cache",
										"content-type: application/json",
										"User-Agent: JoomlaPlugin"
										)
									));
		$bodyAccessTok = curl_exec($acurl);
        $respoJs = json_decode($bodyAccessTok);
		if($respoJs->access_token) {
			$zmail_connection['zmail_access_token'] = base64_encode($respoJs->access_token);
			$zmail_connection['zmail_integ_timestamp'] = time();
		}
		return $zmail_connection;
		} else {
			return $zmail_connection;
		}
	}

	public static function generateTokenByCode($completeRedirectUrl,$authorizationCode) {

		$pluginParams = \JComponentHelper::getParams('com_zohomail');
		$app = Factory::getApplication();
		$session = $app->getSession();
		$input = $app->input;

		$storedNonce = $session->get('oauth_nonce');
		$stateTxt = $input->get('state', '', 'STRING');
		$state = explode(":",base64_decode($stateTxt));
		$zmail_integ_client_id = $state[0];
		$zmail_integ_client_secret = $state[1];
		$zmail_integ_domain_name = $state[2];
		$submittedNonce = $state[3];
		if ($storedNonce != $submittedNonce) {
			echo 'Invalid Token';
			exit;
		}

		$settings = json_decode('{}',true);
		$connection = json_decode($pluginParams->get('zmail_connection'),true);


		$url = "https://accounts.".SettingsHelper::$domainMapping[$zmail_integ_domain_name]."/oauth/v2/token?code=".$authorizationCode."&client_id=".$zmail_integ_client_id."&client_secret=".$zmail_integ_client_secret."&redirect_uri=".urlencode($completeRedirectUrl)."&scope=VirtualOffice.messages.CREATE,VirtualOffice.accounts.READ&grant_type=authorization_code&state=".$stateTxt;

		$data = array();
		$curl = curl_init();
		curl_setopt_array($curl, array(
			CURLOPT_URL => $url,
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => "",
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 30,
			CURLOPT_SSLVERSION => CURL_SSLVERSION_TLSv1_2,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => "POST",
			CURLOPT_HTTPHEADER => array(
				"accept: application/json",
				"cache-control: no-cache",
				"content-type: application/json",
				"User-Agent: JoomlaPlugin"
			),
		));

		$response = curl_exec($curl);


		$accessTokenData = json_decode($response,true);
		if(isset($accessTokenData['access_token'])){
			$connection['zmail_access_token']  = base64_encode($accessTokenData['access_token']);
			$connection['zmail_refresh_token']  = base64_encode($accessTokenData['refresh_token']);
			$connection['zmail_integ_client_id']  = $zmail_integ_client_id;
			$connection['zmail_integ_client_secret']  = base64_encode($zmail_integ_client_secret);
			$connection['zmail_integ_timestamp']  = time();
			$connection['zmail_integ_domain_name'] = $zmail_integ_domain_name;
			$fromAddress = $pluginParams->get('zmail_from_name');
			$mailData = SettingsHelper::getZohoMailList($connection);
			$connection['zmail_acc_id'] = $mailData['zmail_acc_id'];
			if(empty($fromAddress)) {
				if($mailData['zmail_email_list']>0){
					$settings['zmail_from_address'] = $mailData['zmail_email_list'][0];
					$settings['zmail_from_name'] = "Joomla";
				}
			} else {
				if (!in_array($fromAddress, $mailData['zmail_email_list'])) {
					$settings['zmail_from_address'] = $mailData['zmail_email_list'][0];
				} else{
					$settings['zmail_from_address'] = $pluginParams->get('zmail_from_address');
				}
				$settings['zmail_from_name'] =  $pluginParams->get('zmail_from_name');
			}
			$settings['zmail_connection'] = json_encode($connection);
			return SettingsHelper::configure_zohomail($settings);
		}else{
			return $accessTokenData;
		}


	}
	
	public static function configureMailDetails($fromAddress,$fromName) {
		$settings = json_decode('{}',true);
		$settings['zmail_from_address'] = $fromAddress;
		$settings['zmail_from_name'] =  $fromName;
		$pluginParams = \JComponentHelper::getParams('com_zohomail');
		if($pluginParams->get('zmail_connection')==null){
			throw new \Exception("Please authenticate the user",500);
		}
		$mailDetail = SettingsHelper::getZohoMailAccountDetail();
		if($mailDetail && $mailDetail["zmail_email_list"] && count($mailDetail["zmail_email_list"])>0){
			$mailList = $mailDetail["zmail_email_list"];
			
			if (in_array($fromAddress,$mailList)) {
				return SettingsHelper::configure_zohomail($settings);
			}
			else {
				throw new \Exception("Please authenticate valid user account",500);
			}
		}
		return false;
	}
	
	public static $domainMapping = [
				"com"          => "zoho.com",
				"eu"           => "zoho.eu", 
				"in"           => "zoho.in", 
				"com.cn"       => "zoho.com.cn",
				"com.au"       => "zoho.com.au",
				"jp"           => "zoho.jp",
				"zohocloud.ca" => "zohocloud.ca",
				"sa"           => "zoho.sa"
	];
	
}

