/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.io.jdbc;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.apache.flink.api.common.io.RichOutputFormat;
import org.apache.flink.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJDBCOutputFormat<T>
extends RichOutputFormat<T> {
    private static final long serialVersionUID = 1L;
    static final int DEFAULT_FLUSH_MAX_SIZE = 5000;
    static final long DEFAULT_FLUSH_INTERVAL_MILLS = 0L;
    private static final Logger LOG = LoggerFactory.getLogger(AbstractJDBCOutputFormat.class);
    private final String username;
    private final String password;
    private final String drivername;
    protected final String dbURL;
    protected transient Connection connection;

    public AbstractJDBCOutputFormat(String username, String password, String drivername, String dbURL) {
        this.username = username;
        this.password = password;
        this.drivername = drivername;
        this.dbURL = dbURL;
    }

    public void configure(Configuration parameters) {
    }

    protected void establishConnection() throws SQLException, ClassNotFoundException {
        Class.forName(this.drivername);
        this.connection = this.username == null ? DriverManager.getConnection(this.dbURL) : DriverManager.getConnection(this.dbURL, this.username, this.password);
    }

    protected void closeDbConnection() throws IOException {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SQLException se) {
                LOG.warn("JDBC connection could not be closed: " + se.getMessage());
            }
            finally {
                this.connection = null;
            }
        }
    }
}

