/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.io.jdbc;

import java.io.IOException;
import java.sql.SQLException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.flink.api.java.io.jdbc.AbstractJDBCOutputFormat;
import org.apache.flink.api.java.io.jdbc.JDBCOptions;
import org.apache.flink.api.java.io.jdbc.dialect.JDBCDialect;
import org.apache.flink.api.java.io.jdbc.writer.AppendOnlyWriter;
import org.apache.flink.api.java.io.jdbc.writer.JDBCWriter;
import org.apache.flink.api.java.io.jdbc.writer.UpsertWriter;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.util.ExecutorThreadFactory;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCUpsertOutputFormat
extends AbstractJDBCOutputFormat<Tuple2<Boolean, Row>> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(JDBCUpsertOutputFormat.class);
    static final int DEFAULT_MAX_RETRY_TIMES = 3;
    private final String tableName;
    private final JDBCDialect dialect;
    private final String[] fieldNames;
    private final String[] keyFields;
    private final int[] fieldTypes;
    private final int flushMaxSize;
    private final long flushIntervalMills;
    private final int maxRetryTimes;
    private transient JDBCWriter jdbcWriter;
    private transient int batchCount = 0;
    private volatile transient boolean closed = false;
    private transient ScheduledExecutorService scheduler;
    private transient ScheduledFuture scheduledFuture;
    private volatile transient Exception flushException;

    public JDBCUpsertOutputFormat(JDBCOptions options, String[] fieldNames, String[] keyFields, int[] fieldTypes, int flushMaxSize, long flushIntervalMills, int maxRetryTimes) {
        super(options.getUsername(), options.getPassword(), options.getDriverName(), options.getDbURL());
        this.tableName = options.getTableName();
        this.dialect = options.getDialect();
        this.fieldNames = fieldNames;
        this.keyFields = keyFields;
        this.fieldTypes = fieldTypes;
        this.flushMaxSize = flushMaxSize;
        this.flushIntervalMills = flushIntervalMills;
        this.maxRetryTimes = maxRetryTimes;
    }

    public void open(int taskNumber, int numTasks) throws IOException {
        try {
            this.establishConnection();
            if (this.keyFields == null || this.keyFields.length == 0) {
                String insertSQL = this.dialect.getInsertIntoStatement(this.tableName, this.fieldNames);
                this.jdbcWriter = new AppendOnlyWriter(insertSQL, this.fieldTypes);
            } else {
                this.jdbcWriter = UpsertWriter.create(this.dialect, this.tableName, this.fieldNames, this.fieldTypes, this.keyFields, this.getRuntimeContext().getExecutionConfig().isObjectReuseEnabled());
            }
            this.jdbcWriter.open(this.connection);
        }
        catch (SQLException sqe) {
            throw new IllegalArgumentException("open() failed.", sqe);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IllegalArgumentException("JDBC driver class not found.", cnfe);
        }
        if (this.flushIntervalMills != 0L && this.flushMaxSize != 1) {
            this.scheduler = Executors.newScheduledThreadPool(1, (ThreadFactory)new ExecutorThreadFactory("jdbc-upsert-output-format"));
            this.scheduledFuture = this.scheduler.scheduleWithFixedDelay(() -> {
                JDBCUpsertOutputFormat jDBCUpsertOutputFormat = this;
                synchronized (jDBCUpsertOutputFormat) {
                    if (this.closed) {
                        return;
                    }
                    try {
                        this.flush();
                    }
                    catch (Exception e) {
                        this.flushException = e;
                    }
                }
            }, this.flushIntervalMills, this.flushIntervalMills, TimeUnit.MILLISECONDS);
        }
    }

    private void checkFlushException() {
        if (this.flushException != null) {
            throw new RuntimeException("Writing records to JDBC failed.", this.flushException);
        }
    }

    public synchronized void writeRecord(Tuple2<Boolean, Row> tuple2) throws IOException {
        this.checkFlushException();
        try {
            this.jdbcWriter.addRecord(tuple2);
            ++this.batchCount;
            if (this.batchCount >= this.flushMaxSize) {
                this.flush();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Writing records to JDBC failed.", e);
        }
    }

    public synchronized void flush() throws Exception {
        this.checkFlushException();
        for (int i = 1; i <= this.maxRetryTimes; ++i) {
            try {
                this.jdbcWriter.executeBatch();
                this.batchCount = 0;
                break;
            }
            catch (SQLException e) {
                LOG.error("JDBC executeBatch error, retry times = {}", (Object)i, (Object)e);
                if (i >= this.maxRetryTimes) {
                    throw e;
                }
                Thread.sleep(1000 * i);
                continue;
            }
        }
    }

    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.checkFlushException();
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(false);
            this.scheduler.shutdown();
        }
        if (this.batchCount > 0) {
            try {
                this.flush();
            }
            catch (Exception e) {
                throw new RuntimeException("Writing records to JDBC failed.", e);
            }
        }
        try {
            this.jdbcWriter.close();
        }
        catch (SQLException e) {
            LOG.warn("Close JDBC writer failed.", (Throwable)e);
        }
        this.closeDbConnection();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private JDBCOptions options;
        private String[] fieldNames;
        private String[] keyFields;
        private int[] fieldTypes;
        private int flushMaxSize = 5000;
        private long flushIntervalMills = 0L;
        private int maxRetryTimes = 3;

        public Builder setOptions(JDBCOptions options) {
            this.options = options;
            return this;
        }

        public Builder setFieldNames(String[] fieldNames) {
            this.fieldNames = fieldNames;
            return this;
        }

        public Builder setKeyFields(String[] keyFields) {
            this.keyFields = keyFields;
            return this;
        }

        public Builder setFieldTypes(int[] fieldTypes) {
            this.fieldTypes = fieldTypes;
            return this;
        }

        public Builder setFlushMaxSize(int flushMaxSize) {
            this.flushMaxSize = flushMaxSize;
            return this;
        }

        public Builder setFlushIntervalMills(long flushIntervalMills) {
            this.flushIntervalMills = flushIntervalMills;
            return this;
        }

        public Builder setMaxRetryTimes(int maxRetryTimes) {
            this.maxRetryTimes = maxRetryTimes;
            return this;
        }

        public JDBCUpsertOutputFormat build() {
            Preconditions.checkNotNull((Object)this.options, (String)"No options supplied.");
            Preconditions.checkNotNull((Object)this.fieldNames, (String)"No fieldNames supplied.");
            return new JDBCUpsertOutputFormat(this.options, this.fieldNames, this.keyFields, this.fieldTypes, this.flushMaxSize, this.flushIntervalMills, this.maxRetryTimes);
        }
    }
}

