/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.io.jdbc.dialect;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.flink.api.java.io.jdbc.dialect.JDBCDialect;

public final class JDBCDialects {
    private static final List<JDBCDialect> DIALECTS = Arrays.asList(new DerbyDialect(), new MySQLDialect(), new PostgresDialect());

    public static Optional<JDBCDialect> get(String url) {
        for (JDBCDialect dialect : DIALECTS) {
            if (!dialect.canHandle(url)) continue;
            return Optional.of(dialect);
        }
        return Optional.empty();
    }

    private static class PostgresDialect
    implements JDBCDialect {
        private static final long serialVersionUID = 1L;

        private PostgresDialect() {
        }

        @Override
        public boolean canHandle(String url) {
            return url.startsWith("jdbc:postgresql:");
        }

        @Override
        public Optional<String> defaultDriverName() {
            return Optional.of("org.postgresql.Driver");
        }

        @Override
        public Optional<String> getUpsertStatement(String tableName, String[] fieldNames, String[] uniqueKeyFields) {
            String uniqueColumns = Arrays.stream(uniqueKeyFields).map(this::quoteIdentifier).collect(Collectors.joining(", "));
            String updateClause = Arrays.stream(fieldNames).map(f -> this.quoteIdentifier((String)f) + "=EXCLUDED." + this.quoteIdentifier((String)f)).collect(Collectors.joining(", "));
            return Optional.of(this.getInsertIntoStatement(tableName, fieldNames) + " ON CONFLICT (" + uniqueColumns + ") DO UPDATE SET " + updateClause);
        }
    }

    private static class MySQLDialect
    implements JDBCDialect {
        private static final long serialVersionUID = 1L;

        private MySQLDialect() {
        }

        @Override
        public boolean canHandle(String url) {
            return url.startsWith("jdbc:mysql:");
        }

        @Override
        public Optional<String> defaultDriverName() {
            return Optional.of("com.mysql.jdbc.Driver");
        }

        @Override
        public String quoteIdentifier(String identifier) {
            return "`" + identifier + "`";
        }

        @Override
        public Optional<String> getUpsertStatement(String tableName, String[] fieldNames, String[] uniqueKeyFields) {
            String updateClause = Arrays.stream(fieldNames).map(f -> this.quoteIdentifier((String)f) + "=VALUES(" + this.quoteIdentifier((String)f) + ")").collect(Collectors.joining(", "));
            return Optional.of(this.getInsertIntoStatement(tableName, fieldNames) + " ON DUPLICATE KEY UPDATE " + updateClause);
        }
    }

    private static class DerbyDialect
    implements JDBCDialect {
        private static final long serialVersionUID = 1L;

        private DerbyDialect() {
        }

        @Override
        public boolean canHandle(String url) {
            return url.startsWith("jdbc:derby:");
        }

        @Override
        public Optional<String> defaultDriverName() {
            return Optional.of("org.apache.derby.jdbc.EmbeddedDriver");
        }

        @Override
        public String quoteIdentifier(String identifier) {
            return identifier;
        }
    }
}

