/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.uhighlight;

import java.io.IOException;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.analysis.Analyzer;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.analysis.TokenStream;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.IndexReader;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.uhighlight.AnalysisOffsetStrategy;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.uhighlight.OffsetsEnum;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.uhighlight.PhraseHelper;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.automaton.Automata;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.automaton.CharacterRunAutomaton;

public class TokenStreamOffsetStrategy
extends AnalysisOffsetStrategy {
    private static final BytesRef[] ZERO_LEN_BYTES_REF_ARRAY = new BytesRef[0];

    public TokenStreamOffsetStrategy(String field, BytesRef[] terms, PhraseHelper phraseHelper, CharacterRunAutomaton[] automata, Analyzer indexAnalyzer) {
        super(field, ZERO_LEN_BYTES_REF_ARRAY, phraseHelper, TokenStreamOffsetStrategy.convertTermsToAutomata(terms, automata), indexAnalyzer);
        assert (!phraseHelper.hasPositionSensitivity());
    }

    private static CharacterRunAutomaton[] convertTermsToAutomata(BytesRef[] terms, CharacterRunAutomaton[] automata) {
        CharacterRunAutomaton[] newAutomata = new CharacterRunAutomaton[terms.length + automata.length];
        for (int i = 0; i < terms.length; ++i) {
            final String termString = terms[i].utf8ToString();
            newAutomata[i] = new CharacterRunAutomaton(Automata.makeString(termString)){

                @Override
                public String toString() {
                    return termString;
                }
            };
        }
        System.arraycopy(automata, 0, newAutomata, terms.length, automata.length);
        return newAutomata;
    }

    @Override
    public OffsetsEnum getOffsetsEnum(IndexReader reader, int docId, String content) throws IOException {
        return new TokenStreamOffsetsEnum(this.tokenStream(content), this.automata);
    }

    private static class TokenStreamOffsetsEnum
    extends OffsetsEnum {
        TokenStream stream;
        final CharacterRunAutomaton[] matchers;
        final CharTermAttribute charTermAtt;
        final OffsetAttribute offsetAtt;
        int currentMatch = -1;
        final BytesRef[] matchDescriptions;

        TokenStreamOffsetsEnum(TokenStream ts, CharacterRunAutomaton[] matchers) throws IOException {
            this.stream = ts;
            this.matchers = matchers;
            this.matchDescriptions = new BytesRef[matchers.length];
            this.charTermAtt = ts.addAttribute(CharTermAttribute.class);
            this.offsetAtt = ts.addAttribute(OffsetAttribute.class);
            ts.reset();
        }

        @Override
        public boolean nextPosition() throws IOException {
            if (this.stream != null) {
                while (this.stream.incrementToken()) {
                    for (int i = 0; i < this.matchers.length; ++i) {
                        if (!this.matchers[i].run(this.charTermAtt.buffer(), 0, this.charTermAtt.length())) continue;
                        this.currentMatch = i;
                        return true;
                    }
                }
                this.stream.end();
                this.close();
            }
            return false;
        }

        @Override
        public int freq() throws IOException {
            return Integer.MAX_VALUE;
        }

        @Override
        public int startOffset() throws IOException {
            return this.offsetAtt.startOffset();
        }

        @Override
        public int endOffset() throws IOException {
            return this.offsetAtt.endOffset();
        }

        @Override
        public BytesRef getTerm() throws IOException {
            if (this.matchDescriptions[this.currentMatch] == null) {
                this.matchDescriptions[this.currentMatch] = new BytesRef(this.matchers[this.currentMatch].toString());
            }
            return this.matchDescriptions[this.currentMatch];
        }

        @Override
        public void close() throws IOException {
            if (this.stream != null) {
                this.stream.close();
                this.stream = null;
            }
        }
    }
}

