/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.apache.lucene.spatial.prefix;

import java.io.IOException;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.LeafReaderContext;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.DocIdSet;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.spatial.prefix.AbstractVisitingPrefixTreeQuery;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.spatial.prefix.tree.Cell;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.spatial.prefix.tree.CellIterator;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.spatial.prefix.tree.SpatialPrefixTree;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.BitDocIdSet;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.FixedBitSet;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.distance.DistanceUtils;
import org.locationtech.spatial4j.shape.Circle;
import org.locationtech.spatial4j.shape.Point;
import org.locationtech.spatial4j.shape.Rectangle;
import org.locationtech.spatial4j.shape.Shape;
import org.locationtech.spatial4j.shape.SpatialRelation;

public class WithinPrefixTreeQuery
extends AbstractVisitingPrefixTreeQuery {
    private final Shape bufferedQueryShape;

    public WithinPrefixTreeQuery(Shape queryShape, String fieldName, SpatialPrefixTree grid, int detailLevel, int prefixGridScanLevel, double queryBuffer) {
        super(queryShape, fieldName, grid, detailLevel, prefixGridScanLevel);
        this.bufferedQueryShape = queryBuffer == -1.0 ? null : this.bufferShape(queryShape, queryBuffer);
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        WithinPrefixTreeQuery that = (WithinPrefixTreeQuery)o;
        return !(this.bufferedQueryShape != null ? !this.bufferedQueryShape.equals((Object)that.bufferedQueryShape) : that.bufferedQueryShape != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.bufferedQueryShape != null ? this.bufferedQueryShape.hashCode() : 0);
        return result;
    }

    @Override
    public String toString(String field) {
        return this.getClass().getSimpleName() + "(fieldName=" + this.fieldName + ",queryShape=" + this.queryShape + ",detailLevel=" + this.detailLevel + ",prefixGridScanLevel=" + this.prefixGridScanLevel + ")";
    }

    protected Shape bufferShape(Shape shape, double distErr) {
        if (distErr <= 0.0) {
            throw new IllegalArgumentException("distErr must be > 0");
        }
        SpatialContext ctx = this.grid.getSpatialContext();
        if (shape instanceof Point) {
            return ctx.makeCircle((Point)shape, distErr);
        }
        if (shape instanceof Circle) {
            Circle circle = (Circle)shape;
            double newDist = circle.getRadius() + distErr;
            if (ctx.isGeo() && newDist > 180.0) {
                newDist = 180.0;
            }
            return ctx.makeCircle(circle.getCenter(), newDist);
        }
        Rectangle bbox = shape.getBoundingBox();
        double newMinX = bbox.getMinX() - distErr;
        double newMaxX = bbox.getMaxX() + distErr;
        double newMinY = bbox.getMinY() - distErr;
        double newMaxY = bbox.getMaxY() + distErr;
        if (ctx.isGeo()) {
            if (newMinY < -90.0) {
                newMinY = -90.0;
            }
            if (newMaxY > 90.0) {
                newMaxY = 90.0;
            }
            if (newMinY == -90.0 || newMaxY == 90.0 || bbox.getWidth() + 2.0 * distErr > 360.0) {
                newMinX = -180.0;
                newMaxX = 180.0;
            } else {
                newMinX = DistanceUtils.normLonDEG((double)newMinX);
                newMaxX = DistanceUtils.normLonDEG((double)newMaxX);
            }
        } else {
            newMinX = Math.max(newMinX, ctx.getWorldBounds().getMinX());
            newMaxX = Math.min(newMaxX, ctx.getWorldBounds().getMaxX());
            newMinY = Math.max(newMinY, ctx.getWorldBounds().getMinY());
            newMaxY = Math.min(newMaxY, ctx.getWorldBounds().getMaxY());
        }
        return ctx.makeRectangle(newMinX, newMaxX, newMinY, newMaxY);
    }

    @Override
    protected DocIdSet getDocIdSet(LeafReaderContext context) throws IOException {
        return new AbstractVisitingPrefixTreeQuery.VisitorTemplate(context){
            private FixedBitSet inside;
            private FixedBitSet outside;

            @Override
            protected void start() {
                this.inside = new FixedBitSet(this.maxDoc);
                this.outside = new FixedBitSet(this.maxDoc);
            }

            @Override
            protected DocIdSet finish() {
                this.inside.andNot(this.outside);
                return new BitDocIdSet(this.inside);
            }

            @Override
            protected CellIterator findSubCellsToVisit(Cell cell) {
                return cell.getNextLevelCells(WithinPrefixTreeQuery.this.bufferedQueryShape);
            }

            @Override
            protected boolean visitPrefix(Cell cell) throws IOException {
                SpatialRelation visitRelation = cell.getShape().relate(WithinPrefixTreeQuery.this.queryShape);
                if (cell.getLevel() == WithinPrefixTreeQuery.this.detailLevel) {
                    this.collectDocs(visitRelation.intersects() ? this.inside : this.outside);
                    return false;
                }
                if (visitRelation == SpatialRelation.WITHIN) {
                    this.collectDocs(this.inside);
                    return false;
                }
                if (visitRelation == SpatialRelation.DISJOINT) {
                    this.collectDocs(this.outside);
                    return false;
                }
                return true;
            }

            @Override
            protected void visitLeaf(Cell cell) throws IOException {
                if (this.allCellsIntersectQuery(cell)) {
                    this.collectDocs(this.inside);
                } else {
                    this.collectDocs(this.outside);
                }
            }

            private boolean allCellsIntersectQuery(Cell cell) {
                SpatialRelation relate = cell.getShape().relate(WithinPrefixTreeQuery.this.queryShape);
                if (cell.getLevel() == WithinPrefixTreeQuery.this.detailLevel) {
                    return relate.intersects();
                }
                if (relate == SpatialRelation.WITHIN) {
                    return true;
                }
                if (relate == SpatialRelation.DISJOINT) {
                    return false;
                }
                CellIterator subCells = cell.getNextLevelCells(null);
                while (subCells.hasNext()) {
                    Cell subCell = subCells.next();
                    if (this.allCellsIntersectQuery(subCell)) continue;
                    return false;
                }
                return true;
            }

            @Override
            protected void visitScanned(Cell cell) throws IOException {
                this.visitLeaf(cell);
            }
        }.getDocIdSet();
    }
}

