/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util;

import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.ArrayUtil;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.IntsRef;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.UnicodeUtil;

public class IntsRefBuilder {
    private final IntsRef ref = new IntsRef();

    public int[] ints() {
        return this.ref.ints;
    }

    public int length() {
        return this.ref.length;
    }

    public void setLength(int length) {
        this.ref.length = length;
    }

    public void clear() {
        this.setLength(0);
    }

    public int intAt(int offset) {
        return this.ref.ints[offset];
    }

    public void setIntAt(int offset, int b) {
        this.ref.ints[offset] = b;
    }

    public void append(int i) {
        this.grow(this.ref.length + 1);
        this.ref.ints[this.ref.length++] = i;
    }

    public void grow(int newLength) {
        this.ref.ints = ArrayUtil.grow(this.ref.ints, newLength);
    }

    public void copyInts(int[] otherInts, int otherOffset, int otherLength) {
        this.grow(otherLength);
        System.arraycopy(otherInts, otherOffset, this.ref.ints, 0, otherLength);
        this.ref.length = otherLength;
    }

    public void copyInts(IntsRef ints) {
        this.copyInts(ints.ints, ints.offset, ints.length);
    }

    public void copyUTF8Bytes(BytesRef bytes) {
        this.grow(bytes.length);
        this.ref.length = UnicodeUtil.UTF8toUTF32(bytes, this.ref.ints);
    }

    public IntsRef get() {
        assert (this.ref.offset == 0) : "Modifying the offset of the returned ref is illegal";
        return this.ref;
    }

    public IntsRef toIntsRef() {
        return IntsRef.deepCopyOf(this.get());
    }

    public boolean equals(Object obj) {
        throw new UnsupportedOperationException();
    }

    public int hashCode() {
        throw new UnsupportedOperationException();
    }
}

