/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.admin.indices.shards;

import com.carrotsearch.hppc.cursors.IntObjectCursor;
import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.ElasticsearchException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.Version;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.ActionResponse;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.support.DefaultShardOperationFailedException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.node.DiscoveryNode;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.collect.ImmutableOpenIntMap;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.collect.ImmutableOpenMap;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.Streamable;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.ToXContentFragment;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentBuilder;

public class IndicesShardStoresResponse
extends ActionResponse
implements ToXContentFragment {
    private ImmutableOpenMap<String, ImmutableOpenIntMap<List<StoreStatus>>> storeStatuses;
    private List<Failure> failures;

    public IndicesShardStoresResponse(ImmutableOpenMap<String, ImmutableOpenIntMap<List<StoreStatus>>> storeStatuses, List<Failure> failures) {
        this.storeStatuses = storeStatuses;
        this.failures = failures;
    }

    IndicesShardStoresResponse() {
        this(ImmutableOpenMap.of(), Collections.emptyList());
    }

    public ImmutableOpenMap<String, ImmutableOpenIntMap<List<StoreStatus>>> getStoreStatuses() {
        return this.storeStatuses;
    }

    public List<Failure> getFailures() {
        return this.failures;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        int numResponse = in.readVInt();
        ImmutableOpenMap.Builder storeStatusesBuilder = ImmutableOpenMap.builder();
        for (int i = 0; i < numResponse; ++i) {
            String index = in.readString();
            int indexEntries = in.readVInt();
            ImmutableOpenIntMap.Builder shardEntries = ImmutableOpenIntMap.builder();
            for (int shardCount = 0; shardCount < indexEntries; ++shardCount) {
                int shardID = in.readInt();
                int nodeEntries = in.readVInt();
                ArrayList<StoreStatus> storeStatuses = new ArrayList<StoreStatus>(nodeEntries);
                for (int nodeCount = 0; nodeCount < nodeEntries; ++nodeCount) {
                    storeStatuses.add(StoreStatus.readStoreStatus(in));
                }
                shardEntries.put(shardID, storeStatuses);
            }
            storeStatusesBuilder.put(index, shardEntries.build());
        }
        int numFailure = in.readVInt();
        ArrayList<Failure> failureBuilder = new ArrayList<Failure>();
        for (int i = 0; i < numFailure; ++i) {
            failureBuilder.add(Failure.readFailure(in));
        }
        this.storeStatuses = storeStatusesBuilder.build();
        this.failures = Collections.unmodifiableList(failureBuilder);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.storeStatuses.size());
        for (ObjectObjectCursor<String, ImmutableOpenIntMap<List<StoreStatus>>> objectObjectCursor : this.storeStatuses) {
            out.writeString((String)objectObjectCursor.key);
            out.writeVInt(((ImmutableOpenIntMap)objectObjectCursor.value).size());
            for (IntObjectCursor shardStatusesEntry : (ImmutableOpenIntMap)objectObjectCursor.value) {
                out.writeInt(shardStatusesEntry.key);
                out.writeVInt(((List)shardStatusesEntry.value).size());
                for (StoreStatus storeStatus : (List)shardStatusesEntry.value) {
                    storeStatus.writeTo(out);
                }
            }
        }
        out.writeVInt(this.failures.size());
        for (Failure failure : this.failures) {
            failure.writeTo(out);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.failures.size() > 0) {
            builder.startArray("failures");
            for (Failure failure : this.failures) {
                builder.startObject();
                failure.toXContent(builder, params);
                builder.endObject();
            }
            builder.endArray();
        }
        builder.startObject("indices");
        for (ObjectObjectCursor objectObjectCursor : this.storeStatuses) {
            builder.startObject((String)objectObjectCursor.key);
            builder.startObject("shards");
            for (IntObjectCursor shardStatusesEntry : (ImmutableOpenIntMap)objectObjectCursor.value) {
                builder.startObject(String.valueOf(shardStatusesEntry.key));
                builder.startArray("stores");
                for (StoreStatus storeStatus : (List)shardStatusesEntry.value) {
                    builder.startObject();
                    storeStatus.toXContent(builder, params);
                    builder.endObject();
                }
                builder.endArray();
                builder.endObject();
            }
            builder.endObject();
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    static final class Fields {
        static final String INDICES = "indices";
        static final String SHARDS = "shards";
        static final String FAILURES = "failures";
        static final String STORES = "stores";
        static final String ALLOCATION_ID = "allocation_id";
        static final String STORE_EXCEPTION = "store_exception";
        static final String ALLOCATED = "allocation";

        Fields() {
        }
    }

    public static class Failure
    extends DefaultShardOperationFailedException {
        private String nodeId;

        public Failure(String nodeId, String index, int shardId, Throwable reason) {
            super(index, shardId, reason);
            this.nodeId = nodeId;
        }

        private Failure() {
        }

        public String nodeId() {
            return this.nodeId;
        }

        public static Failure readFailure(StreamInput in) throws IOException {
            Failure failure = new Failure();
            failure.readFrom(in);
            return failure;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.nodeId = in.readString();
            super.readFrom(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.nodeId);
            super.writeTo(out);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field("node", this.nodeId());
            super.toXContent(builder, params);
            return builder;
        }
    }

    public static class StoreStatus
    implements Streamable,
    ToXContentFragment,
    Comparable<StoreStatus> {
        private DiscoveryNode node;
        private String allocationId;
        private Exception storeException;
        private AllocationStatus allocationStatus;

        private StoreStatus() {
        }

        public StoreStatus(DiscoveryNode node, String allocationId, AllocationStatus allocationStatus, Exception storeException) {
            this.node = node;
            this.allocationId = allocationId;
            this.allocationStatus = allocationStatus;
            this.storeException = storeException;
        }

        public DiscoveryNode getNode() {
            return this.node;
        }

        public String getAllocationId() {
            return this.allocationId;
        }

        public Exception getStoreException() {
            return this.storeException;
        }

        public AllocationStatus getAllocationStatus() {
            return this.allocationStatus;
        }

        public static StoreStatus readStoreStatus(StreamInput in) throws IOException {
            StoreStatus storeStatus = new StoreStatus();
            storeStatus.readFrom(in);
            return storeStatus;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.node = new DiscoveryNode(in);
            if (in.getVersion().before(Version.V_6_0_0_alpha1)) {
                in.readLong();
            }
            this.allocationId = in.readOptionalString();
            this.allocationStatus = AllocationStatus.readFrom(in);
            if (in.readBoolean()) {
                this.storeException = in.readException();
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            this.node.writeTo(out);
            if (out.getVersion().before(Version.V_6_0_0_alpha1)) {
                out.writeLong(-1L);
            }
            out.writeOptionalString(this.allocationId);
            this.allocationStatus.writeTo(out);
            if (this.storeException != null) {
                out.writeBoolean(true);
                out.writeException(this.storeException);
            } else {
                out.writeBoolean(false);
            }
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            this.node.toXContent(builder, params);
            if (this.allocationId != null) {
                builder.field("allocation_id", this.allocationId);
            }
            builder.field("allocation", this.allocationStatus.value());
            if (this.storeException != null) {
                builder.startObject("store_exception");
                ElasticsearchException.generateThrowableXContent(builder, params, this.storeException);
                builder.endObject();
            }
            return builder;
        }

        @Override
        public int compareTo(StoreStatus other) {
            if (this.storeException != null && other.storeException == null) {
                return 1;
            }
            if (other.storeException != null && this.storeException == null) {
                return -1;
            }
            if (this.allocationId != null && other.allocationId == null) {
                return -1;
            }
            if (this.allocationId == null && other.allocationId != null) {
                return 1;
            }
            if (this.allocationId == null && other.allocationId == null) {
                return Integer.compare(this.allocationStatus.id, other.allocationStatus.id);
            }
            int compare = Integer.compare(this.allocationStatus.id, other.allocationStatus.id);
            if (compare == 0) {
                return this.allocationId.compareTo(other.allocationId);
            }
            return compare;
        }

        public static enum AllocationStatus {
            PRIMARY(0),
            REPLICA(1),
            UNUSED(2);

            private final byte id;

            private AllocationStatus(byte id) {
                this.id = id;
            }

            private static AllocationStatus fromId(byte id) {
                switch (id) {
                    case 0: {
                        return PRIMARY;
                    }
                    case 1: {
                        return REPLICA;
                    }
                    case 2: {
                        return UNUSED;
                    }
                }
                throw new IllegalArgumentException("unknown id for allocation status [" + id + "]");
            }

            public String value() {
                switch (this.id) {
                    case 0: {
                        return "primary";
                    }
                    case 1: {
                        return "replica";
                    }
                    case 2: {
                        return "unused";
                    }
                }
                throw new IllegalArgumentException("unknown id for allocation status [" + this.id + "]");
            }

            private static AllocationStatus readFrom(StreamInput in) throws IOException {
                return AllocationStatus.fromId(in.readByte());
            }

            private void writeTo(StreamOutput out) throws IOException {
                out.writeByte(this.id);
            }
        }
    }
}

