/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.node;

import java.util.Map;
import java.util.function.Supplier;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.Action;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.ActionListener;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.ActionRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.ActionRequestBuilder;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.ActionResponse;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.GenericAction;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.support.TransportAction;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.Client;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.support.AbstractClient;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.tasks.Task;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.tasks.TaskListener;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.threadpool.ThreadPool;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.transport.RemoteClusterService;

public class NodeClient
extends AbstractClient {
    private Map<GenericAction, TransportAction> actions;
    private Supplier<String> localNodeId;
    private RemoteClusterService remoteClusterService;

    public NodeClient(Settings settings, ThreadPool threadPool) {
        super(settings, threadPool);
    }

    public void initialize(Map<GenericAction, TransportAction> actions, Supplier<String> localNodeId, RemoteClusterService remoteClusterService) {
        this.actions = actions;
        this.localNodeId = localNodeId;
        this.remoteClusterService = remoteClusterService;
    }

    @Override
    public void close() {
    }

    @Override
    public <Request extends ActionRequest, Response extends ActionResponse, RequestBuilder extends ActionRequestBuilder<Request, Response, RequestBuilder>> void doExecute(Action<Request, Response, RequestBuilder> action, Request request, ActionListener<Response> listener) {
        this.executeLocally(action, request, listener);
    }

    public <Request extends ActionRequest, Response extends ActionResponse> Task executeLocally(GenericAction<Request, Response> action, Request request, ActionListener<Response> listener) {
        return this.transportAction(action).execute(request, listener);
    }

    public <Request extends ActionRequest, Response extends ActionResponse> Task executeLocally(GenericAction<Request, Response> action, Request request, TaskListener<Response> listener) {
        return this.transportAction(action).execute(request, listener);
    }

    public String getLocalNodeId() {
        return this.localNodeId.get();
    }

    private <Request extends ActionRequest, Response extends ActionResponse> TransportAction<Request, Response> transportAction(GenericAction<Request, Response> action) {
        if (this.actions == null) {
            throw new IllegalStateException("NodeClient has not been initialized");
        }
        TransportAction transportAction = this.actions.get(action);
        if (transportAction == null) {
            throw new IllegalStateException("failed to find action [" + action + "] to execute");
        }
        return transportAction;
    }

    @Override
    public Client getRemoteClusterClient(String clusterAlias) {
        return this.remoteClusterService.getRemoteClusterClient(this.threadPool(), clusterAlias);
    }
}

