/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.health;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.ClusterState;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.health.ClusterIndexHealth;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.metadata.IndexMetaData;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.routing.ShardRouting;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.Writeable;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.RestStatus;

public final class ClusterStateHealth
implements Iterable<ClusterIndexHealth>,
Writeable {
    private final int numberOfNodes;
    private final int numberOfDataNodes;
    private final int activeShards;
    private final int relocatingShards;
    private final int activePrimaryShards;
    private final int initializingShards;
    private final int unassignedShards;
    private final double activeShardsPercent;
    private final ClusterHealthStatus status;
    private final Map<String, ClusterIndexHealth> indices = new HashMap<String, ClusterIndexHealth>();

    public ClusterStateHealth(ClusterState clusterState) {
        this(clusterState, clusterState.metaData().getConcreteAllIndices());
    }

    public ClusterStateHealth(ClusterState clusterState, String[] concreteIndices) {
        this.numberOfNodes = clusterState.nodes().getSize();
        this.numberOfDataNodes = clusterState.nodes().getDataNodes().size();
        for (String index : concreteIndices) {
            IndexRoutingTable indexRoutingTable = clusterState.routingTable().index(index);
            IndexMetaData indexMetaData = clusterState.metaData().index(index);
            if (indexRoutingTable == null) continue;
            ClusterIndexHealth indexHealth = new ClusterIndexHealth(indexMetaData, indexRoutingTable);
            this.indices.put(indexHealth.getIndex(), indexHealth);
        }
        ClusterHealthStatus computeStatus = ClusterHealthStatus.GREEN;
        int computeActivePrimaryShards = 0;
        int computeActiveShards = 0;
        int computeRelocatingShards = 0;
        int computeInitializingShards = 0;
        int computeUnassignedShards = 0;
        for (ClusterIndexHealth indexHealth : this.indices.values()) {
            computeActivePrimaryShards += indexHealth.getActivePrimaryShards();
            computeActiveShards += indexHealth.getActiveShards();
            computeRelocatingShards += indexHealth.getRelocatingShards();
            computeInitializingShards += indexHealth.getInitializingShards();
            computeUnassignedShards += indexHealth.getUnassignedShards();
            if (indexHealth.getStatus() == ClusterHealthStatus.RED) {
                computeStatus = ClusterHealthStatus.RED;
                continue;
            }
            if (indexHealth.getStatus() != ClusterHealthStatus.YELLOW || computeStatus == ClusterHealthStatus.RED) continue;
            computeStatus = ClusterHealthStatus.YELLOW;
        }
        if (clusterState.blocks().hasGlobalBlock(RestStatus.SERVICE_UNAVAILABLE)) {
            computeStatus = ClusterHealthStatus.RED;
        }
        this.status = computeStatus;
        this.activePrimaryShards = computeActivePrimaryShards;
        this.activeShards = computeActiveShards;
        this.relocatingShards = computeRelocatingShards;
        this.initializingShards = computeInitializingShards;
        this.unassignedShards = computeUnassignedShards;
        if (computeStatus.equals(ClusterHealthStatus.GREEN)) {
            this.activeShardsPercent = 100.0;
        } else {
            List<ShardRouting> shardRoutings = clusterState.getRoutingTable().allShards();
            int activeShardCount = 0;
            int totalShardCount = 0;
            for (ShardRouting shardRouting : shardRoutings) {
                if (shardRouting.active()) {
                    ++activeShardCount;
                }
                ++totalShardCount;
            }
            this.activeShardsPercent = (double)activeShardCount / (double)totalShardCount * 100.0;
        }
    }

    public ClusterStateHealth(StreamInput in) throws IOException {
        this.activePrimaryShards = in.readVInt();
        this.activeShards = in.readVInt();
        this.relocatingShards = in.readVInt();
        this.initializingShards = in.readVInt();
        this.unassignedShards = in.readVInt();
        this.numberOfNodes = in.readVInt();
        this.numberOfDataNodes = in.readVInt();
        this.status = ClusterHealthStatus.fromValue(in.readByte());
        int size = in.readVInt();
        for (int i = 0; i < size; ++i) {
            ClusterIndexHealth indexHealth = new ClusterIndexHealth(in);
            this.indices.put(indexHealth.getIndex(), indexHealth);
        }
        this.activeShardsPercent = in.readDouble();
    }

    public int getActiveShards() {
        return this.activeShards;
    }

    public int getRelocatingShards() {
        return this.relocatingShards;
    }

    public int getActivePrimaryShards() {
        return this.activePrimaryShards;
    }

    public int getInitializingShards() {
        return this.initializingShards;
    }

    public int getUnassignedShards() {
        return this.unassignedShards;
    }

    public int getNumberOfNodes() {
        return this.numberOfNodes;
    }

    public int getNumberOfDataNodes() {
        return this.numberOfDataNodes;
    }

    public ClusterHealthStatus getStatus() {
        return this.status;
    }

    public Map<String, ClusterIndexHealth> getIndices() {
        return Collections.unmodifiableMap(this.indices);
    }

    public double getActiveShardsPercent() {
        return this.activeShardsPercent;
    }

    @Override
    public Iterator<ClusterIndexHealth> iterator() {
        return this.indices.values().iterator();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.activePrimaryShards);
        out.writeVInt(this.activeShards);
        out.writeVInt(this.relocatingShards);
        out.writeVInt(this.initializingShards);
        out.writeVInt(this.unassignedShards);
        out.writeVInt(this.numberOfNodes);
        out.writeVInt(this.numberOfDataNodes);
        out.writeByte(this.status.value());
        out.writeVInt(this.indices.size());
        for (ClusterIndexHealth indexHealth : this) {
            indexHealth.writeTo(out);
        }
        out.writeDouble(this.activeShardsPercent);
    }
}

