/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.routing.allocation.decider;

import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.routing.RoutingNode;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.routing.ShardRouting;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.Settings;

public class ReplicaAfterPrimaryActiveAllocationDecider
extends AllocationDecider {
    private static final String NAME = "replica_after_primary_active";

    public ReplicaAfterPrimaryActiveAllocationDecider(Settings settings) {
        super(settings);
    }

    @Override
    public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return this.canAllocate(shardRouting, allocation);
    }

    @Override
    public Decision canAllocate(ShardRouting shardRouting, RoutingAllocation allocation) {
        if (shardRouting.primary()) {
            return allocation.decision(Decision.YES, NAME, "shard is primary and can be allocated", new Object[0]);
        }
        ShardRouting primary = allocation.routingNodes().activePrimary(shardRouting.shardId());
        if (primary == null) {
            return allocation.decision(Decision.NO, NAME, "primary shard for this replica is not yet active", new Object[0]);
        }
        return allocation.decision(Decision.YES, NAME, "primary shard for this replica is already active", new Object[0]);
    }
}

