/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.flink.elasticsearch6.shaded.org.apache.logging.log4j.Logger;
import org.apache.flink.elasticsearch6.shaded.org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.Assertions;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.AckedClusterStateTaskListener;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.ClusterChangedEvent;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.ClusterState;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.ClusterStateTaskListener;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.metadata.MetaData;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.metadata.ProcessClusterEventTimeoutException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.node.DiscoveryNode;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.node.DiscoveryNodes;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.routing.RoutingTable;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.service.ClusterService;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.service.PendingClusterTask;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.service.SourcePrioritizedRunnable;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.service.TaskBatcher;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.Nullable;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.Priority;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.logging.Loggers;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.text.Text;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.unit.TimeValue;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.util.concurrent.CountDown;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.util.concurrent.EsExecutors;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.util.concurrent.FutureUtils;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.util.concurrent.PrioritizedEsThreadPoolExecutor;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.discovery.Discovery;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.threadpool.ThreadPool;

public class MasterService
extends AbstractLifecycleComponent {
    public static final String MASTER_UPDATE_THREAD_NAME = "masterService#updateTask";
    private BiConsumer<ClusterChangedEvent, Discovery.AckListener> clusterStatePublisher;
    private Supplier<ClusterState> clusterStateSupplier;
    private volatile TimeValue slowTaskLoggingThreshold;
    protected final ThreadPool threadPool;
    private volatile PrioritizedEsThreadPoolExecutor threadPoolExecutor;
    private volatile Batcher taskBatcher;

    public MasterService(Settings settings, ThreadPool threadPool) {
        super(settings);
        this.slowTaskLoggingThreshold = ClusterService.CLUSTER_SERVICE_SLOW_TASK_LOGGING_THRESHOLD_SETTING.get(settings);
        this.threadPool = threadPool;
    }

    public void setSlowTaskLoggingThreshold(TimeValue slowTaskLoggingThreshold) {
        this.slowTaskLoggingThreshold = slowTaskLoggingThreshold;
    }

    public synchronized void setClusterStatePublisher(BiConsumer<ClusterChangedEvent, Discovery.AckListener> publisher) {
        this.clusterStatePublisher = publisher;
    }

    public synchronized void setClusterStateSupplier(Supplier<ClusterState> clusterStateSupplier) {
        this.clusterStateSupplier = clusterStateSupplier;
    }

    @Override
    protected synchronized void doStart() {
        Objects.requireNonNull(this.clusterStatePublisher, "please set a cluster state publisher before starting");
        Objects.requireNonNull(this.clusterStateSupplier, "please set a cluster state supplier before starting");
        this.threadPoolExecutor = EsExecutors.newSinglePrioritizing(this.nodeName() + "/" + MASTER_UPDATE_THREAD_NAME, EsExecutors.daemonThreadFactory(this.settings, MASTER_UPDATE_THREAD_NAME), this.threadPool.getThreadContext(), this.threadPool.scheduler());
        this.taskBatcher = new Batcher(this.logger, this.threadPoolExecutor);
    }

    @Override
    protected synchronized void doStop() {
        ThreadPool.terminate(this.threadPoolExecutor, 10L, TimeUnit.SECONDS);
    }

    @Override
    protected synchronized void doClose() {
    }

    ClusterState state() {
        return this.clusterStateSupplier.get();
    }

    public static boolean assertMasterUpdateThread() {
        assert (Thread.currentThread().getName().contains(MASTER_UPDATE_THREAD_NAME)) : "not called from the master service thread";
        return true;
    }

    public static boolean assertNotMasterUpdateThread(String reason) {
        assert (!Thread.currentThread().getName().contains(MASTER_UPDATE_THREAD_NAME)) : "Expected current thread [" + Thread.currentThread() + "] to not be the master service thread. Reason: [" + reason + "]";
        return true;
    }

    protected void runTasks(TaskInputs taskInputs) {
        String summary = taskInputs.summary;
        if (!this.lifecycle.started()) {
            this.logger.debug("processing [{}]: ignoring, master service not started", (Object)summary);
            return;
        }
        this.logger.debug("processing [{}]: execute", (Object)summary);
        ClusterState previousClusterState = this.state();
        if (!previousClusterState.nodes().isLocalNodeElectedMaster() && taskInputs.runOnlyWhenMaster()) {
            this.logger.debug("failing [{}]: local node is no longer master", (Object)summary);
            taskInputs.onNoLongerMaster();
            return;
        }
        long startTimeNS = this.currentTimeInNanos();
        TaskOutputs taskOutputs = this.calculateTaskOutputs(taskInputs, previousClusterState, startTimeNS);
        taskOutputs.notifyFailedTasks();
        if (taskOutputs.clusterStateUnchanged()) {
            taskOutputs.notifySuccessfulTasksOnUnchangedClusterState();
            TimeValue executionTime = TimeValue.timeValueMillis(Math.max(0L, TimeValue.nsecToMSec(this.currentTimeInNanos() - startTimeNS)));
            this.logger.debug("processing [{}]: took [{}] no change in cluster state", (Object)summary, (Object)executionTime);
            this.warnAboutSlowTaskIfNeeded(executionTime, summary);
        } else {
            ClusterState newClusterState = taskOutputs.newClusterState;
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("cluster state updated, source [{}]\n{}", (Object)summary, (Object)newClusterState);
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug("cluster state updated, version [{}], source [{}]", (Object)newClusterState.version(), (Object)summary);
            }
            try {
                String nodeSummary;
                ClusterChangedEvent clusterChangedEvent = new ClusterChangedEvent(summary, newClusterState, previousClusterState);
                DiscoveryNodes.Delta nodesDelta = clusterChangedEvent.nodesDelta();
                if (nodesDelta.hasChanges() && this.logger.isInfoEnabled() && (nodeSummary = nodesDelta.shortSummary()).length() > 0) {
                    this.logger.info("{}, reason: {}", (Object)summary, (Object)nodeSummary);
                }
                this.logger.debug("publishing cluster state version [{}]", (Object)newClusterState.version());
                try {
                    this.clusterStatePublisher.accept(clusterChangedEvent, taskOutputs.createAckListener(this.threadPool, newClusterState));
                }
                catch (Discovery.FailedToCommitClusterStateException t) {
                    long version = newClusterState.version();
                    this.logger.warn(() -> new ParameterizedMessage("failing [{}]: failed to commit cluster state version [{}]", (Object)summary, (Object)version), (Throwable)t);
                    taskOutputs.publishingFailed(t);
                    return;
                }
                taskOutputs.processedDifferentClusterState(previousClusterState, newClusterState);
                try {
                    taskOutputs.clusterStatePublished(clusterChangedEvent);
                }
                catch (Exception e) {
                    this.logger.error(() -> new ParameterizedMessage("exception thrown while notifying executor of new cluster state publication [{}]", (Object)summary), (Throwable)e);
                }
                TimeValue executionTime = TimeValue.timeValueMillis(Math.max(0L, TimeValue.nsecToMSec(this.currentTimeInNanos() - startTimeNS)));
                this.logger.debug("processing [{}]: took [{}] done publishing updated cluster state (version: {}, uuid: {})", (Object)summary, (Object)executionTime, (Object)newClusterState.version(), (Object)newClusterState.stateUUID());
                this.warnAboutSlowTaskIfNeeded(executionTime, summary);
            }
            catch (Exception e) {
                TimeValue executionTime = TimeValue.timeValueMillis(Math.max(0L, TimeValue.nsecToMSec(this.currentTimeInNanos() - startTimeNS)));
                long version = newClusterState.version();
                String stateUUID = newClusterState.stateUUID();
                String fullState = newClusterState.toString();
                this.logger.warn(() -> new ParameterizedMessage("failed to publish updated cluster state in [{}]:\nversion [{}], uuid [{}], source [{}]\n{}", executionTime, version, stateUUID, summary, fullState), (Throwable)e);
            }
        }
    }

    public TaskOutputs calculateTaskOutputs(TaskInputs taskInputs, ClusterState previousClusterState, long startTimeNS) {
        ClusterStateTaskExecutor.ClusterTasksResult<Object> clusterTasksResult = this.executeTasks(taskInputs, startTimeNS, previousClusterState);
        ClusterState newClusterState = this.patchVersions(previousClusterState, clusterTasksResult);
        return new TaskOutputs(taskInputs, previousClusterState, newClusterState, this.getNonFailedTasks(taskInputs, clusterTasksResult), clusterTasksResult.executionResults);
    }

    private ClusterState patchVersions(ClusterState previousClusterState, ClusterStateTaskExecutor.ClusterTasksResult<?> executionResult) {
        ClusterState newClusterState = executionResult.resultingState;
        if (previousClusterState != newClusterState) {
            ClusterState.Builder builder = ClusterState.builder(newClusterState).incrementVersion();
            if (previousClusterState.routingTable() != newClusterState.routingTable()) {
                builder.routingTable(RoutingTable.builder(newClusterState.routingTable()).version(newClusterState.routingTable().version() + 1L).build());
            }
            if (previousClusterState.metaData() != newClusterState.metaData()) {
                builder.metaData(MetaData.builder(newClusterState.metaData()).version(newClusterState.metaData().version() + 1L));
            }
            newClusterState = builder.build();
        }
        return newClusterState;
    }

    public <T extends ClusterStateTaskConfig & ClusterStateTaskExecutor<T>> void submitStateUpdateTask(String source, T updateTask) {
        this.submitStateUpdateTask(source, updateTask, updateTask, updateTask, (ClusterStateTaskListener)updateTask);
    }

    public <T> void submitStateUpdateTask(String source, T task, ClusterStateTaskConfig config, ClusterStateTaskExecutor<T> executor, ClusterStateTaskListener listener) {
        this.submitStateUpdateTasks(source, Collections.singletonMap(task, listener), config, executor);
    }

    public List<PendingClusterTask> pendingTasks() {
        return Arrays.stream(this.threadPoolExecutor.getPending()).map(pending -> {
            assert (pending.task instanceof SourcePrioritizedRunnable) : "thread pool executor should only use SourcePrioritizedRunnable instances but found: " + pending.task.getClass().getName();
            SourcePrioritizedRunnable task = (SourcePrioritizedRunnable)pending.task;
            return new PendingClusterTask(pending.insertionOrder, pending.priority, new Text(task.source()), task.getAgeInMillis(), pending.executing);
        }).collect(Collectors.toList());
    }

    public int numberOfPendingTasks() {
        return this.threadPoolExecutor.getNumberOfPendingTasks();
    }

    public TimeValue getMaxTaskWaitTime() {
        return this.threadPoolExecutor.getMaxTaskWaitTime();
    }

    private SafeClusterStateTaskListener safe(ClusterStateTaskListener listener) {
        if (listener instanceof AckedClusterStateTaskListener) {
            return new SafeAckedClusterStateTaskListener((AckedClusterStateTaskListener)listener, this.logger);
        }
        return new SafeClusterStateTaskListener(listener, this.logger);
    }

    protected void warnAboutSlowTaskIfNeeded(TimeValue executionTime, String source) {
        if (executionTime.getMillis() > this.slowTaskLoggingThreshold.getMillis()) {
            this.logger.warn("cluster state update task [{}] took [{}] above the warn threshold of {}", (Object)source, (Object)executionTime, (Object)this.slowTaskLoggingThreshold);
        }
    }

    protected ClusterStateTaskExecutor.ClusterTasksResult<Object> executeTasks(TaskInputs taskInputs, long startTimeNS, ClusterState previousClusterState) {
        ClusterStateTaskExecutor.ClusterTasksResult<Object> clusterTasksResult;
        try {
            List inputs = taskInputs.updateTasks.stream().map(tUpdateTask -> tUpdateTask.task).collect(Collectors.toList());
            clusterTasksResult = taskInputs.executor.execute(previousClusterState, inputs);
            if (previousClusterState != clusterTasksResult.resultingState && previousClusterState.nodes().isLocalNodeElectedMaster() && !clusterTasksResult.resultingState.nodes().isLocalNodeElectedMaster()) {
                throw new AssertionError((Object)"update task submitted to MasterService cannot remove master");
            }
        }
        catch (Exception e) {
            TimeValue executionTime = TimeValue.timeValueMillis(Math.max(0L, TimeValue.nsecToMSec(this.currentTimeInNanos() - startTimeNS)));
            if (this.logger.isTraceEnabled()) {
                this.logger.trace(() -> new ParameterizedMessage("failed to execute cluster state update in [{}], state:\nversion [{}], source [{}]\n{}{}{}", executionTime, previousClusterState.version(), taskInputs.summary, previousClusterState.nodes(), previousClusterState.routingTable(), previousClusterState.getRoutingNodes()), (Throwable)e);
            }
            this.warnAboutSlowTaskIfNeeded(executionTime, taskInputs.summary);
            clusterTasksResult = ClusterStateTaskExecutor.ClusterTasksResult.builder().failures(taskInputs.updateTasks.stream().map(updateTask -> updateTask.task)::iterator, e).build(previousClusterState);
        }
        assert (clusterTasksResult.executionResults != null);
        assert (clusterTasksResult.executionResults.size() == taskInputs.updateTasks.size()) : String.format(Locale.ROOT, "expected [%d] task result%s but was [%d]", taskInputs.updateTasks.size(), taskInputs.updateTasks.size() == 1 ? "" : "s", clusterTasksResult.executionResults.size());
        if (Assertions.ENABLED) {
            ClusterStateTaskExecutor.ClusterTasksResult<Object> finalClusterTasksResult = clusterTasksResult;
            taskInputs.updateTasks.forEach(updateTask -> {
                assert (finalClusterTasksResult.executionResults.containsKey(updateTask.task)) : "missing task result for " + updateTask;
            });
        }
        return clusterTasksResult;
    }

    public List<Batcher.UpdateTask> getNonFailedTasks(TaskInputs taskInputs, ClusterStateTaskExecutor.ClusterTasksResult<Object> clusterTasksResult) {
        return taskInputs.updateTasks.stream().filter(updateTask -> {
            assert (clusterTasksResult.executionResults.containsKey(updateTask.task)) : "missing " + updateTask;
            ClusterStateTaskExecutor.TaskResult taskResult = clusterTasksResult.executionResults.get(updateTask.task);
            return taskResult.isSuccess();
        }).collect(Collectors.toList());
    }

    public <T> void submitStateUpdateTasks(String source, Map<T, ClusterStateTaskListener> tasks, ClusterStateTaskConfig config, ClusterStateTaskExecutor<T> executor) {
        block3: {
            if (!this.lifecycle.started()) {
                return;
            }
            try {
                List safeTasks = tasks.entrySet().stream().map(e -> {
                    Batcher batcher = this.taskBatcher;
                    Objects.requireNonNull(batcher);
                    return batcher.new Batcher.UpdateTask(config.priority(), source, e.getKey(), this.safe((ClusterStateTaskListener)e.getValue()), executor);
                }).collect(Collectors.toList());
                this.taskBatcher.submitTasks(safeTasks, config.timeout());
            }
            catch (EsRejectedExecutionException e2) {
                if (this.lifecycle.stoppedOrClosed()) break block3;
                throw e2;
            }
        }
    }

    protected long currentTimeInNanos() {
        return System.nanoTime();
    }

    protected class TaskInputs {
        public final String summary;
        public final List<Batcher.UpdateTask> updateTasks;
        public final ClusterStateTaskExecutor<Object> executor;

        TaskInputs(ClusterStateTaskExecutor<Object> executor, List<Batcher.UpdateTask> updateTasks, String summary) {
            this.summary = summary;
            this.executor = executor;
            this.updateTasks = updateTasks;
        }

        public boolean runOnlyWhenMaster() {
            return this.executor.runOnlyOnMaster();
        }

        public void onNoLongerMaster() {
            this.updateTasks.forEach(task -> task.listener.onNoLongerMaster(task.source()));
        }
    }

    private static class AckCountDownListener
    implements Discovery.AckListener {
        private static final Logger logger = Loggers.getLogger(AckCountDownListener.class);
        private final AckedClusterStateTaskListener ackedTaskListener;
        private final CountDown countDown;
        private final DiscoveryNodes nodes;
        private final long clusterStateVersion;
        private final Future<?> ackTimeoutCallback;
        private Exception lastFailure;

        AckCountDownListener(AckedClusterStateTaskListener ackedTaskListener, long clusterStateVersion, DiscoveryNodes nodes, ThreadPool threadPool) {
            this.ackedTaskListener = ackedTaskListener;
            this.clusterStateVersion = clusterStateVersion;
            this.nodes = nodes;
            int countDown = 0;
            for (DiscoveryNode node : nodes) {
                if (!ackedTaskListener.mustAck(node)) continue;
                ++countDown;
            }
            countDown = Math.max(1, countDown);
            logger.trace("expecting {} acknowledgements for cluster_state update (version: {})", (Object)countDown, (Object)clusterStateVersion);
            this.countDown = new CountDown(countDown);
            this.ackTimeoutCallback = threadPool.schedule(ackedTaskListener.ackTimeout(), "generic", () -> this.onTimeout());
        }

        @Override
        public void onNodeAck(DiscoveryNode node, @Nullable Exception e) {
            if (!this.ackedTaskListener.mustAck(node) && !node.equals(this.nodes.getMasterNode())) {
                return;
            }
            if (e == null) {
                logger.trace("ack received from node [{}], cluster_state update (version: {})", (Object)node, (Object)this.clusterStateVersion);
            } else {
                this.lastFailure = e;
                logger.debug(() -> new ParameterizedMessage("ack received from node [{}], cluster_state update (version: {})", (Object)node, (Object)this.clusterStateVersion), (Throwable)e);
            }
            if (this.countDown.countDown()) {
                logger.trace("all expected nodes acknowledged cluster_state update (version: {})", (Object)this.clusterStateVersion);
                FutureUtils.cancel(this.ackTimeoutCallback);
                this.ackedTaskListener.onAllNodesAcked(this.lastFailure);
            }
        }

        @Override
        public void onTimeout() {
            if (this.countDown.fastForward()) {
                logger.trace("timeout waiting for acknowledgement for cluster_state update (version: {})", (Object)this.clusterStateVersion);
                this.ackedTaskListener.onAckTimeout();
            }
        }
    }

    private static class DelegetingAckListener
    implements Discovery.AckListener {
        private final List<Discovery.AckListener> listeners;

        private DelegetingAckListener(List<Discovery.AckListener> listeners) {
            this.listeners = listeners;
        }

        @Override
        public void onNodeAck(DiscoveryNode node, @Nullable Exception e) {
            for (Discovery.AckListener listener : this.listeners) {
                listener.onNodeAck(node, e);
            }
        }

        @Override
        public void onTimeout() {
            throw new UnsupportedOperationException("no timeout delegation");
        }
    }

    private static class SafeAckedClusterStateTaskListener
    extends SafeClusterStateTaskListener
    implements AckedClusterStateTaskListener {
        private final AckedClusterStateTaskListener listener;
        private final Logger logger;

        SafeAckedClusterStateTaskListener(AckedClusterStateTaskListener listener, Logger logger) {
            super(listener, logger);
            this.listener = listener;
            this.logger = logger;
        }

        @Override
        public boolean mustAck(DiscoveryNode discoveryNode) {
            return this.listener.mustAck(discoveryNode);
        }

        @Override
        public void onAllNodesAcked(@Nullable Exception e) {
            try {
                this.listener.onAllNodesAcked(e);
            }
            catch (Exception inner) {
                inner.addSuppressed(e);
                this.logger.error("exception thrown by listener while notifying on all nodes acked", (Throwable)inner);
            }
        }

        @Override
        public void onAckTimeout() {
            try {
                this.listener.onAckTimeout();
            }
            catch (Exception e) {
                this.logger.error("exception thrown by listener while notifying on ack timeout", (Throwable)e);
            }
        }

        @Override
        public TimeValue ackTimeout() {
            return this.listener.ackTimeout();
        }
    }

    private static class SafeClusterStateTaskListener
    implements ClusterStateTaskListener {
        private final ClusterStateTaskListener listener;
        private final Logger logger;

        SafeClusterStateTaskListener(ClusterStateTaskListener listener, Logger logger) {
            this.listener = listener;
            this.logger = logger;
        }

        @Override
        public void onFailure(String source, Exception e) {
            try {
                this.listener.onFailure(source, e);
            }
            catch (Exception inner) {
                inner.addSuppressed(e);
                this.logger.error(() -> new ParameterizedMessage("exception thrown by listener notifying of failure from [{}]", (Object)source), (Throwable)inner);
            }
        }

        @Override
        public void onNoLongerMaster(String source) {
            try {
                this.listener.onNoLongerMaster(source);
            }
            catch (Exception e) {
                this.logger.error(() -> new ParameterizedMessage("exception thrown by listener while notifying no longer master from [{}]", (Object)source), (Throwable)e);
            }
        }

        @Override
        public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
            try {
                this.listener.clusterStateProcessed(source, oldState, newState);
            }
            catch (Exception e) {
                this.logger.error(() -> new ParameterizedMessage("exception thrown by listener while notifying of cluster state processed from [{}], old cluster state:\n{}\nnew cluster state:\n{}", source, oldState, newState), (Throwable)e);
            }
        }
    }

    class TaskOutputs {
        public final TaskInputs taskInputs;
        public final ClusterState previousClusterState;
        public final ClusterState newClusterState;
        public final List<Batcher.UpdateTask> nonFailedTasks;
        public final Map<Object, ClusterStateTaskExecutor.TaskResult> executionResults;

        TaskOutputs(TaskInputs taskInputs, ClusterState previousClusterState, ClusterState newClusterState, List<Batcher.UpdateTask> nonFailedTasks, Map<Object, ClusterStateTaskExecutor.TaskResult> executionResults) {
            this.taskInputs = taskInputs;
            this.previousClusterState = previousClusterState;
            this.newClusterState = newClusterState;
            this.nonFailedTasks = nonFailedTasks;
            this.executionResults = executionResults;
        }

        public void publishingFailed(Discovery.FailedToCommitClusterStateException t) {
            this.nonFailedTasks.forEach(task -> task.listener.onFailure(task.source(), t));
        }

        public void processedDifferentClusterState(ClusterState previousClusterState, ClusterState newClusterState) {
            this.nonFailedTasks.forEach(task -> task.listener.clusterStateProcessed(task.source(), previousClusterState, newClusterState));
        }

        public void clusterStatePublished(ClusterChangedEvent clusterChangedEvent) {
            this.taskInputs.executor.clusterStatePublished(clusterChangedEvent);
        }

        public Discovery.AckListener createAckListener(ThreadPool threadPool, ClusterState newClusterState) {
            ArrayList ackListeners = new ArrayList();
            this.nonFailedTasks.stream().filter(task -> task.listener instanceof AckedClusterStateTaskListener).forEach(task -> {
                AckedClusterStateTaskListener ackedListener = (AckedClusterStateTaskListener)task.listener;
                if (ackedListener.ackTimeout() == null || ackedListener.ackTimeout().millis() == 0L) {
                    ackedListener.onAckTimeout();
                } else {
                    try {
                        ackListeners.add(new AckCountDownListener(ackedListener, newClusterState.version(), newClusterState.nodes(), threadPool));
                    }
                    catch (EsRejectedExecutionException ex) {
                        if (MasterService.this.logger.isDebugEnabled()) {
                            MasterService.this.logger.debug("Couldn't schedule timeout thread - node might be shutting down", (Throwable)ex);
                        }
                        ackedListener.onAckTimeout();
                    }
                }
            });
            return new DelegetingAckListener(ackListeners);
        }

        public boolean clusterStateUnchanged() {
            return this.previousClusterState == this.newClusterState;
        }

        public void notifyFailedTasks() {
            for (Batcher.UpdateTask updateTask : this.taskInputs.updateTasks) {
                assert (this.executionResults.containsKey(updateTask.task)) : "missing " + updateTask;
                ClusterStateTaskExecutor.TaskResult taskResult = this.executionResults.get(updateTask.task);
                if (taskResult.isSuccess()) continue;
                updateTask.listener.onFailure(updateTask.source(), taskResult.getFailure());
            }
        }

        public void notifySuccessfulTasksOnUnchangedClusterState() {
            this.nonFailedTasks.forEach(task -> {
                if (task.listener instanceof AckedClusterStateTaskListener) {
                    ((AckedClusterStateTaskListener)task.listener).onAllNodesAcked(null);
                }
                task.listener.clusterStateProcessed(task.source(), this.newClusterState, this.newClusterState);
            });
        }
    }

    class Batcher
    extends TaskBatcher {
        Batcher(Logger logger, PrioritizedEsThreadPoolExecutor threadExecutor) {
            super(logger, threadExecutor);
        }

        @Override
        protected void onTimeout(List<? extends TaskBatcher.BatchedTask> tasks, TimeValue timeout) {
            MasterService.this.threadPool.generic().execute(() -> tasks.forEach(task -> ((UpdateTask)task).listener.onFailure(task.source, new ProcessClusterEventTimeoutException(timeout, task.source))));
        }

        @Override
        protected void run(Object batchingKey, List<? extends TaskBatcher.BatchedTask> tasks, String tasksSummary) {
            ClusterStateTaskExecutor taskExecutor = (ClusterStateTaskExecutor)batchingKey;
            List<? extends TaskBatcher.BatchedTask> updateTasks = tasks;
            MasterService.this.runTasks(new TaskInputs(taskExecutor, updateTasks, tasksSummary));
        }

        class UpdateTask
        extends TaskBatcher.BatchedTask {
            final ClusterStateTaskListener listener;

            UpdateTask(Priority priority, String source, Object task, ClusterStateTaskListener listener, ClusterStateTaskExecutor<?> executor) {
                super(priority, source, executor, task);
                this.listener = listener;
            }

            @Override
            public String describeTasks(List<? extends TaskBatcher.BatchedTask> tasks) {
                return ((ClusterStateTaskExecutor)this.batchingKey).describeTasks(tasks.stream().map(TaskBatcher.BatchedTask::getTask).collect(Collectors.toList()));
            }
        }
    }
}

