/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.lucene.uid;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.IndexReader;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.LeafReader;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.LeafReaderContext;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.NumericDocValues;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.Term;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.CloseableThreadLocal;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.lucene.uid.PerThreadIDVersionAndSeqNoLookup;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.util.concurrent.ConcurrentCollections;

public final class VersionsAndSeqNoResolver {
    static final ConcurrentMap<IndexReader.CacheKey, CloseableThreadLocal<PerThreadIDVersionAndSeqNoLookup[]>> lookupStates = ConcurrentCollections.newConcurrentMapWithAggressiveConcurrency();
    private static final IndexReader.ClosedListener removeLookupState = key -> {
        CloseableThreadLocal ctl = (CloseableThreadLocal)lookupStates.remove(key);
        if (ctl != null) {
            ctl.close();
        }
    };

    private static PerThreadIDVersionAndSeqNoLookup[] getLookupState(IndexReader reader, String uidField) throws IOException {
        PerThreadIDVersionAndSeqNoLookup[] lookupState;
        IndexReader.CacheHelper cacheHelper = reader.getReaderCacheHelper();
        CloseableThreadLocal<PerThreadIDVersionAndSeqNoLookup[]> ctl = (CloseableThreadLocal<PerThreadIDVersionAndSeqNoLookup[]>)lookupStates.get(cacheHelper.getKey());
        if (ctl == null) {
            ctl = new CloseableThreadLocal<PerThreadIDVersionAndSeqNoLookup[]>();
            CloseableThreadLocal other = lookupStates.putIfAbsent(cacheHelper.getKey(), ctl);
            if (other == null) {
                cacheHelper.addClosedListener(removeLookupState);
            } else {
                ctl = other;
            }
        }
        if ((lookupState = (PerThreadIDVersionAndSeqNoLookup[])ctl.get()) == null) {
            lookupState = new PerThreadIDVersionAndSeqNoLookup[reader.leaves().size()];
            for (LeafReaderContext leaf : reader.leaves()) {
                lookupState[leaf.ord] = new PerThreadIDVersionAndSeqNoLookup(leaf.reader(), uidField);
            }
            ctl.set(lookupState);
        }
        if (lookupState.length != reader.leaves().size()) {
            throw new AssertionError((Object)("Mismatched numbers of leaves: " + lookupState.length + " != " + reader.leaves().size()));
        }
        if (lookupState.length > 0 && !Objects.equals(lookupState[0].uidField, uidField)) {
            throw new AssertionError((Object)("Index does not consistently use the same uid field: [" + uidField + "] != [" + lookupState[0].uidField + "]"));
        }
        return lookupState;
    }

    private VersionsAndSeqNoResolver() {
    }

    public static DocIdAndVersion loadDocIdAndVersion(IndexReader reader, Term term) throws IOException {
        PerThreadIDVersionAndSeqNoLookup[] lookups = VersionsAndSeqNoResolver.getLookupState(reader, term.field());
        List<LeafReaderContext> leaves = reader.leaves();
        for (int i = leaves.size() - 1; i >= 0; --i) {
            LeafReaderContext leaf = leaves.get(i);
            PerThreadIDVersionAndSeqNoLookup lookup = lookups[leaf.ord];
            DocIdAndVersion result = lookup.lookupVersion(term.bytes(), leaf);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static DocIdAndSeqNo loadDocIdAndSeqNo(IndexReader reader, Term term) throws IOException {
        PerThreadIDVersionAndSeqNoLookup[] lookups = VersionsAndSeqNoResolver.getLookupState(reader, term.field());
        List<LeafReaderContext> leaves = reader.leaves();
        for (int i = leaves.size() - 1; i >= 0; --i) {
            LeafReaderContext leaf = leaves.get(i);
            PerThreadIDVersionAndSeqNoLookup lookup = lookups[leaf.ord];
            DocIdAndSeqNo result = lookup.lookupSeqNo(term.bytes(), leaf);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static long loadPrimaryTerm(DocIdAndSeqNo docIdAndSeqNo, String uidField) throws IOException {
        NumericDocValues primaryTerms = docIdAndSeqNo.context.reader().getNumericDocValues("_primary_term");
        long result = primaryTerms != null && primaryTerms.advanceExact(docIdAndSeqNo.docId) ? primaryTerms.longValue() : 0L;
        assert (result > 0L) : "should always resolve a primary term for a resolved sequence number. primary_term [" + result + "] docId [" + docIdAndSeqNo.docId + "] seqNo [" + docIdAndSeqNo.seqNo + "]";
        return result;
    }

    public static long loadVersion(IndexReader reader, Term term) throws IOException {
        DocIdAndVersion docIdAndVersion = VersionsAndSeqNoResolver.loadDocIdAndVersion(reader, term);
        return docIdAndVersion == null ? -1L : docIdAndVersion.version;
    }

    public static class DocIdAndSeqNo {
        public final int docId;
        public final long seqNo;
        public final LeafReaderContext context;

        DocIdAndSeqNo(int docId, long seqNo, LeafReaderContext context) {
            this.docId = docId;
            this.seqNo = seqNo;
            this.context = context;
        }
    }

    public static class DocIdAndVersion {
        public final int docId;
        public final long version;
        public final LeafReader reader;
        public final int docBase;

        public DocIdAndVersion(int docId, long version, LeafReader reader, int docBase) {
            this.docId = docId;
            this.version = version;
            this.reader = reader;
            this.docBase = docBase;
        }
    }
}

