/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.util.concurrent;

import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.util.concurrent.AbstractRunnable;

class TimedRunnable
extends AbstractRunnable {
    private final Runnable original;
    private final long creationTimeNanos;
    private long startTimeNanos;
    private long finishTimeNanos = -1L;

    TimedRunnable(Runnable original) {
        this.original = original;
        this.creationTimeNanos = System.nanoTime();
    }

    @Override
    public void doRun() {
        try {
            this.startTimeNanos = System.nanoTime();
            this.original.run();
        }
        finally {
            this.finishTimeNanos = System.nanoTime();
        }
    }

    @Override
    public void onRejection(Exception e) {
        if (this.original instanceof AbstractRunnable) {
            ((AbstractRunnable)this.original).onRejection(e);
        }
    }

    @Override
    public void onAfter() {
        if (this.original instanceof AbstractRunnable) {
            ((AbstractRunnable)this.original).onAfter();
        }
    }

    @Override
    public void onFailure(Exception e) {
        if (this.original instanceof AbstractRunnable) {
            ((AbstractRunnable)this.original).onFailure(e);
        }
    }

    @Override
    public boolean isForceExecution() {
        return this.original instanceof AbstractRunnable && ((AbstractRunnable)this.original).isForceExecution();
    }

    long getTotalNanos() {
        if (this.finishTimeNanos == -1L) {
            return -1L;
        }
        return Math.max(this.finishTimeNanos - this.creationTimeNanos, 1L);
    }

    long getTotalExecutionNanos() {
        if (this.startTimeNanos == -1L || this.finishTimeNanos == -1L) {
            return -1L;
        }
        return Math.max(this.finishTimeNanos - this.startTimeNanos, 1L);
    }
}

