/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.discovery;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.ClusterState;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.node.DiscoveryNode;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.service.ClusterApplier;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.service.MasterService;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.logging.Loggers;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.network.NetworkService;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.ClusterSettings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.Setting;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.discovery.Discovery;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.discovery.single.SingleNodeDiscovery;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.discovery.zen.UnicastHostsProvider;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.discovery.zen.ZenDiscovery;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.plugins.DiscoveryPlugin;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.threadpool.ThreadPool;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.transport.TransportService;

public class DiscoveryModule {
    public static final Setting<String> DISCOVERY_TYPE_SETTING = new Setting("discovery.type", "zen", Function.identity(), Setting.Property.NodeScope);
    public static final Setting<Optional<String>> DISCOVERY_HOSTS_PROVIDER_SETTING = new Setting<Optional>("discovery.zen.hosts_provider", (String)null, Optional::ofNullable, Setting.Property.NodeScope);
    private final Discovery discovery;

    public DiscoveryModule(Settings settings, ThreadPool threadPool, TransportService transportService, NamedWriteableRegistry namedWriteableRegistry, NetworkService networkService, MasterService masterService, ClusterApplier clusterApplier, ClusterSettings clusterSettings, List<DiscoveryPlugin> plugins, AllocationService allocationService) {
        UnicastHostsProvider hostsProvider;
        ArrayList<BiConsumer<DiscoveryNode, ClusterState>> joinValidators = new ArrayList<BiConsumer<DiscoveryNode, ClusterState>>();
        HashMap hostProviders = new HashMap();
        for (DiscoveryPlugin plugin : plugins) {
            plugin.getZenHostsProviders(transportService, networkService).entrySet().forEach(entry -> {
                if (hostProviders.put((String)entry.getKey(), (Supplier)entry.getValue()) != null) {
                    throw new IllegalArgumentException("Cannot register zen hosts provider [" + (String)entry.getKey() + "] twice");
                }
            });
            BiConsumer<DiscoveryNode, ClusterState> joinValidator = plugin.getJoinValidator();
            if (joinValidator == null) continue;
            joinValidators.add(joinValidator);
        }
        Optional<String> hostsProviderName = DISCOVERY_HOSTS_PROVIDER_SETTING.get(settings);
        if (hostsProviderName.isPresent()) {
            Supplier hostsProviderSupplier = (Supplier)hostProviders.get(hostsProviderName.get());
            if (hostsProviderSupplier == null) {
                throw new IllegalArgumentException("Unknown zen hosts provider [" + hostsProviderName.get() + "]");
            }
            hostsProvider = Objects.requireNonNull((UnicastHostsProvider)hostsProviderSupplier.get());
        } else {
            hostsProvider = Collections::emptyList;
        }
        HashMap<String, Supplier<Discovery>> discoveryTypes = new HashMap<String, Supplier<Discovery>>();
        discoveryTypes.put("zen", () -> new ZenDiscovery(settings, threadPool, transportService, namedWriteableRegistry, masterService, clusterApplier, clusterSettings, hostsProvider, allocationService, Collections.unmodifiableCollection(joinValidators)));
        discoveryTypes.put("single-node", () -> new SingleNodeDiscovery(settings, transportService, masterService, clusterApplier));
        for (DiscoveryPlugin plugin : plugins) {
            plugin.getDiscoveryTypes(threadPool, transportService, namedWriteableRegistry, masterService, clusterApplier, clusterSettings, hostsProvider, allocationService).entrySet().forEach(entry -> {
                if (discoveryTypes.put((String)entry.getKey(), (Supplier)entry.getValue()) != null) {
                    throw new IllegalArgumentException("Cannot register discovery type [" + (String)entry.getKey() + "] twice");
                }
            });
        }
        String discoveryType = DISCOVERY_TYPE_SETTING.get(settings);
        Supplier discoverySupplier = (Supplier)discoveryTypes.get(discoveryType);
        if (discoverySupplier == null) {
            throw new IllegalArgumentException("Unknown discovery type [" + discoveryType + "]");
        }
        Loggers.getLogger(this.getClass(), settings, new String[0]).info("using discovery type [{}]", (Object)discoveryType);
        this.discovery = Objects.requireNonNull((Discovery)discoverySupplier.get());
    }

    public Discovery getDiscovery() {
        return this.discovery;
    }
}

